/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion;

import com.intellij.ml.inline.completion.execution.MLCompletionContext;
import com.intellij.ml.inline.completion.impl.diagnostic.ContextMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosableContext;
import com.intellij.ml.llm.completion.cloud.CloudCompletionRequest;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.openapi.DocumentPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.terminal.completion.TerminalCloudCompletionContext;
import com.intellij.ml.llm.terminal.completion.TerminalCloudCompletionContextKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.session.TerminalOutputBlock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0017\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003JE\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext;", "Lcom/intellij/ml/inline/completion/execution/MLCompletionContext;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/DiagnosableContext;", "commandHistory", "Lcom/intellij/ml/llm/privacy/PSString;", "commandWithOutputHistory", "commandPrefix", "clipboardContent", "fileTree", "requestSnapshot", "Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest$Snapshot;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest$Snapshot;)V", "getCommandHistory", "()Lcom/intellij/ml/llm/privacy/PSString;", "getCommandWithOutputHistory", "getCommandPrefix", "getClipboardContent", "getFileTree", "getRequestSnapshot", "()Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest$Snapshot;", "getTerminalContextItems", "", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ContextMessage$Item;", "provideDiagnosticMessage", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ContextMessage;", "timeToAssemble", "Lkotlin/time/Duration;", "provideDiagnosticMessage-LRDsOJo", "(J)Lcom/intellij/ml/inline/completion/impl/diagnostic/ContextMessage;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "intellij.ml.llm.terminal.completion"})
public final class TerminalCloudCompletionContext
extends MLCompletionContext
implements DiagnosableContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PSString commandHistory;
    @NotNull
    private final PSString commandWithOutputHistory;
    @NotNull
    private final PSString commandPrefix;
    @NotNull
    private final PSString clipboardContent;
    @NotNull
    private final PSString fileTree;
    @NotNull
    private final CloudCompletionRequest.Snapshot requestSnapshot;
    private static final int TOTAL_CHAR_LIMIT = 8000;
    private static final int CLIPBOARD_LIMIT = 500;
    private static final int FILE_TREE_LIMIT = 2000;
    private static final int COMMAND_PREFIX_LIMIT = 500;
    private static final int DETAILED_HISTORY_LIMIT = 3000;
    private static final int DETAILED_HISTORY_OUTPUT_LIMIT = 1000;

    public TerminalCloudCompletionContext(@NotNull PSString commandHistory, @NotNull PSString commandWithOutputHistory, @NotNull PSString commandPrefix, @NotNull PSString clipboardContent, @NotNull PSString fileTree, @NotNull CloudCompletionRequest.Snapshot requestSnapshot) {
        Intrinsics.checkNotNullParameter((Object)commandHistory, (String)"commandHistory");
        Intrinsics.checkNotNullParameter((Object)commandWithOutputHistory, (String)"commandWithOutputHistory");
        Intrinsics.checkNotNullParameter((Object)commandPrefix, (String)"commandPrefix");
        Intrinsics.checkNotNullParameter((Object)clipboardContent, (String)"clipboardContent");
        Intrinsics.checkNotNullParameter((Object)fileTree, (String)"fileTree");
        Intrinsics.checkNotNullParameter((Object)requestSnapshot, (String)"requestSnapshot");
        this.commandHistory = commandHistory;
        this.commandWithOutputHistory = commandWithOutputHistory;
        this.commandPrefix = commandPrefix;
        this.clipboardContent = clipboardContent;
        this.fileTree = fileTree;
        this.requestSnapshot = requestSnapshot;
    }

    @NotNull
    public final PSString getCommandHistory() {
        return this.commandHistory;
    }

    @NotNull
    public final PSString getCommandWithOutputHistory() {
        return this.commandWithOutputHistory;
    }

    @NotNull
    public final PSString getCommandPrefix() {
        return this.commandPrefix;
    }

    @NotNull
    public final PSString getClipboardContent() {
        return this.clipboardContent;
    }

    @NotNull
    public final PSString getFileTree() {
        return this.fileTree;
    }

    @Override
    @NotNull
    public CloudCompletionRequest.Snapshot getRequestSnapshot() {
        return this.requestSnapshot;
    }

    private final List<ContextMessage.Item> getTerminalContextItems() {
        Object[] objectArray = new ContextMessage.Item[]{new ContextMessage.Item("Command history", "Command history", (String)this.commandHistory.unwrap(), 0), new ContextMessage.Item("Command-only history", "Command-only history", (String)this.commandWithOutputHistory.unwrap(), 0), new ContextMessage.Item("Clipboard content", "Clipboard content", (String)this.clipboardContent.unwrap(), 0), new ContextMessage.Item("File tree", "File tree", (String)this.fileTree.unwrap(), 0)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public ContextMessage provideDiagnosticMessage-LRDsOJo(long l) {
        return new ContextMessage(l, (String)this.commandPrefix.unwrap(), "", "", this.getTerminalContextItems(), null);
    }

    @NotNull
    public final PSString component1() {
        return this.commandHistory;
    }

    @NotNull
    public final PSString component2() {
        return this.commandWithOutputHistory;
    }

    @NotNull
    public final PSString component3() {
        return this.commandPrefix;
    }

    @NotNull
    public final PSString component4() {
        return this.clipboardContent;
    }

    @NotNull
    public final PSString component5() {
        return this.fileTree;
    }

    @NotNull
    public final CloudCompletionRequest.Snapshot component6() {
        return this.requestSnapshot;
    }

    @NotNull
    public final TerminalCloudCompletionContext copy(@NotNull PSString commandHistory, @NotNull PSString commandWithOutputHistory, @NotNull PSString commandPrefix, @NotNull PSString clipboardContent, @NotNull PSString fileTree, @NotNull CloudCompletionRequest.Snapshot requestSnapshot) {
        Intrinsics.checkNotNullParameter((Object)commandHistory, (String)"commandHistory");
        Intrinsics.checkNotNullParameter((Object)commandWithOutputHistory, (String)"commandWithOutputHistory");
        Intrinsics.checkNotNullParameter((Object)commandPrefix, (String)"commandPrefix");
        Intrinsics.checkNotNullParameter((Object)clipboardContent, (String)"clipboardContent");
        Intrinsics.checkNotNullParameter((Object)fileTree, (String)"fileTree");
        Intrinsics.checkNotNullParameter((Object)requestSnapshot, (String)"requestSnapshot");
        return new TerminalCloudCompletionContext(commandHistory, commandWithOutputHistory, commandPrefix, clipboardContent, fileTree, requestSnapshot);
    }

    public static /* synthetic */ TerminalCloudCompletionContext copy$default(TerminalCloudCompletionContext terminalCloudCompletionContext, PSString pSString, PSString pSString2, PSString pSString3, PSString pSString4, PSString pSString5, CloudCompletionRequest.Snapshot snapshot2, int n, Object object) {
        if ((n & 1) != 0) {
            pSString = terminalCloudCompletionContext.commandHistory;
        }
        if ((n & 2) != 0) {
            pSString2 = terminalCloudCompletionContext.commandWithOutputHistory;
        }
        if ((n & 4) != 0) {
            pSString3 = terminalCloudCompletionContext.commandPrefix;
        }
        if ((n & 8) != 0) {
            pSString4 = terminalCloudCompletionContext.clipboardContent;
        }
        if ((n & 0x10) != 0) {
            pSString5 = terminalCloudCompletionContext.fileTree;
        }
        if ((n & 0x20) != 0) {
            snapshot2 = terminalCloudCompletionContext.requestSnapshot;
        }
        return terminalCloudCompletionContext.copy(pSString, pSString2, pSString3, pSString4, pSString5, snapshot2);
    }

    @NotNull
    public String toString() {
        return "TerminalCloudCompletionContext(commandHistory=" + this.commandHistory + ", commandWithOutputHistory=" + this.commandWithOutputHistory + ", commandPrefix=" + this.commandPrefix + ", clipboardContent=" + this.clipboardContent + ", fileTree=" + this.fileTree + ", requestSnapshot=" + this.requestSnapshot + ")";
    }

    public int hashCode() {
        int result2 = this.commandHistory.hashCode();
        result2 = result2 * 31 + this.commandWithOutputHistory.hashCode();
        result2 = result2 * 31 + this.commandPrefix.hashCode();
        result2 = result2 * 31 + this.clipboardContent.hashCode();
        result2 = result2 * 31 + this.fileTree.hashCode();
        result2 = result2 * 31 + this.requestSnapshot.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalCloudCompletionContext)) {
            return false;
        }
        TerminalCloudCompletionContext terminalCloudCompletionContext = (TerminalCloudCompletionContext)other;
        if (!Intrinsics.areEqual((Object)this.commandHistory, (Object)terminalCloudCompletionContext.commandHistory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.commandWithOutputHistory, (Object)terminalCloudCompletionContext.commandWithOutputHistory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.commandPrefix, (Object)terminalCloudCompletionContext.commandPrefix)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clipboardContent, (Object)terminalCloudCompletionContext.clipboardContent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileTree, (Object)terminalCloudCompletionContext.fileTree)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestSnapshot, (Object)terminalCloudCompletionContext.requestSnapshot);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJA\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001aJ5\u0010\u001b\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext$Companion;", "", "<init>", "()V", "TOTAL_CHAR_LIMIT", "", "CLIPBOARD_LIMIT", "FILE_TREE_LIMIT", "COMMAND_PREFIX_LIMIT", "DETAILED_HISTORY_LIMIT", "DETAILED_HISTORY_OUTPUT_LIMIT", "composeFrom", "Lcom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext;", "request", "Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;", "(Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildDetailedHistory", "Lkotlin/Pair;", "", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "blocks", "", "Lorg/jetbrains/plugins/terminal/session/TerminalOutputBlock;", "text", "limit", "buildDetailedHistory$intellij_ml_llm_terminal_completion", "buildCommandHistory", "buildCommandHistory$intellij_ml_llm_terminal_completion", "generateFileTree", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "generateFileTree$intellij_ml_llm_terminal_completion", "intellij.ml.llm.terminal.completion"})
    @SourceDebugExtension(value={"SMAP\nTerminalCloudCompletionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCloudCompletionContext.kt\ncom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,187:1\n967#2,7:188\n1563#2:195\n1634#2,3:196\n1#3:199\n6572#4:200\n*S KotlinDebug\n*F\n+ 1 TerminalCloudCompletionContext.kt\ncom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext$Companion\n*L\n63#1:188,7\n67#1:195\n67#1:196,3\n179#1:200\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Object composeFrom(@NotNull CloudCompletionRequest request, @NotNull Continuation<? super TerminalCloudCompletionContext> $completion) {
            if (!($completion instanceof composeFrom.1)) ** GOTO lbl-1000
            var29_3 = $completion;
            if ((var29_3.label & -2147483648) != 0) {
                var29_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    Object L$13;
                    Object L$14;
                    Object L$15;
                    Object L$16;
                    Object L$17;
                    Object L$18;
                    Object L$19;
                    Object L$20;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.composeFrom(null, (Continuation<? super TerminalCloudCompletionContext>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var36_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    outputModel = (TerminalOutputModel)request.getParameters().getEditor().getUserData(TerminalOutputModel.Companion.getKEY());
                    v0 = outputModel;
                    requestOffset = v0 != null && (v0 = v0.getStartOffset()) != null ? v0.plus((long)request.getParameters().getOffset()) : null;
                    v1 = request.getParameters().getFile().getViewProvider().getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDocument(...)");
                    documentContent = ExtensionsKtKt.privacySafe((Document)v1, (Project)request.getProject());
                    text = documentContent.getText();
                    blocksModel = (TerminalBlocksModel)request.getParameters().getEditor().getUserData(TerminalBlocksModel.Companion.getKEY());
                    v2 /* !! */  = blocksModel;
                    if (v2 /* !! */  != null && (v2 /* !! */  = v2 /* !! */ .getBlocks()) != null) {
                        $this$takeWhile$iv = (Iterable)v2 /* !! */ ;
                        $i$f$takeWhile = false;
                        list$iv = new ArrayList<E>();
                        for (T item$iv : $this$takeWhile$iv) {
                            it = (TerminalOutputBlock)item$iv;
                            $i$a$-takeWhile-TerminalCloudCompletionContext$Companion$composeFrom$blocks$1 = false;
                            if (!(requestOffset != null && it.getStartOffset().compareTo((Object)requestOffset) < 0)) break;
                            list$iv.add(item$iv);
                        }
                        v3 = (List)list$iv;
                    } else {
                        v3 = CollectionsKt.emptyList();
                    }
                    blocks = v3;
                    lastBlock = (TerminalOutputBlock)CollectionsKt.lastOrNull((List)blocks);
                    if (((Collection)blocks).isEmpty() == false) {
                        $this$map$iv = blocks.subList(0, blocks.size() - 1);
                        $i$f$map = false;
                        list$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var18_26 = (TerminalOutputBlock)item$iv$iv;
                            var21_31 = destination$iv$iv;
                            $i$a$-map-TerminalCloudCompletionContext$Companion$composeFrom$historyBlocks$1 = false;
                            v4 = it.getId();
                            v5 = it.getStartOffset();
                            v6 = it.getCommandStartOffset();
                            if (v6 == null) {
                                v6 = it.getStartOffset();
                            }
                            if ((v7 = it.getOutputStartOffset()) == null) {
                                v7 = it.getEndOffset();
                            }
                            var21_31.add(new TerminalOutputBlock(v4, v5, v6, v7, it.getEndOffset(), it.getExitCode()));
                        }
                        v8 = (List)destination$iv$iv;
                    } else {
                        v8 = CollectionsKt.emptyList();
                    }
                    historyBlocks = v8;
                    v9 = lastBlock;
                    lastCommandStartOffset = v9 != null ? v9.getCommandStartOffset() : null;
                    commandPrefix = lastCommandStartOffset != null && outputModel != null ? (CharSequence)text.substring((int)lastCommandStartOffset.minus(outputModel.getStartOffset()), request.getParameters().getOffset()).takeLast(500).removeSuffix("\n") : (CharSequence)"";
                    try {
                        v10 = TerminalUiUtilsKt.getClipboardText((boolean)true);
                        if (v10 == null || (v10 = StringsKt.take((String)v10, (int)500)) == null) {
                            v10 = "";
                        }
                        destination$iv$iv = v10;
                    }
                    catch (Exception <unused var>) {
                        destination$iv$iv = "";
                    }
                    clipboard = destination$iv$iv;
                    projectDir = ProjectUtil.guessProjectDir((Project)request.getProject());
                    v11 = projectDir;
                    if (v11 == null) ** GOTO lbl90
                    it = v11;
                    $i$a$-let-TerminalCloudCompletionContext$Companion$composeFrom$fileTree$1 = false;
                    v12 = TerminalCloudCompletionContext.Companion.generateFileTree$intellij_ml_llm_terminal_completion(it);
                    v11 = v12;
                    if (v12 == null) ** GOTO lbl90
                    tree = v11;
                    $i$a$-let-TerminalCloudCompletionContext$Companion$composeFrom$fileTree$2 = false;
                    v13 = tree.length() > 2000 ? StringsKt.take((String)tree, (int)2000) + "..." : tree;
                    v11 = v13;
                    if (v13 != null) ** GOTO lbl91
lbl90:
                    // 3 sources

                    v11 = "";
lbl91:
                    // 2 sources

                    fileTree = v11;
                    var16_20 = this.buildDetailedHistory$intellij_ml_llm_terminal_completion(outputModel, historyBlocks, text.toString(), 3000);
                    commandWithOutputHistory = (String)var16_20.component1();
                    includedCommandCount = ((Number)var16_20.component2()).intValue();
                    remainingChars = 8000 - commandPrefix.length() - clipboard.length() - fileTree.length() - commandWithOutputHistory.length();
                    commandHistory = this.buildCommandHistory$intellij_ml_llm_terminal_completion(outputModel, historyBlocks.subList(0, historyBlocks.size() - includedCommandCount), text.toString(), remainingChars);
                    var26_35 = ConstantsKt.getPrivacyConst((String)fileTree);
                    var25_36 = ConstantsKt.getPrivacyConst((String)clipboard);
                    var24_37 = ConstantsKt.getPrivacyConst((String)commandPrefix.toString());
                    var23_38 = ConstantsKt.getPrivacyConst((String)commandWithOutputHistory);
                    var22_39 = ConstantsKt.getPrivacyConst((String)commandHistory);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)outputModel);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)requestOffset);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)documentContent);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)text);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)blocksModel);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)blocks);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)lastBlock);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)historyBlocks);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)lastCommandStartOffset);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)commandPrefix);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)clipboard);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)projectDir);
                    $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)fileTree);
                    $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)commandWithOutputHistory);
                    $continuation.L$15 = SpillingKt.nullOutSpilledVariable((Object)commandHistory);
                    $continuation.L$16 = var22_39;
                    $continuation.L$17 = var23_38;
                    $continuation.L$18 = var24_37;
                    $continuation.L$19 = var25_36;
                    $continuation.L$20 = var26_35;
                    $continuation.I$0 = includedCommandCount;
                    $continuation.I$1 = remainingChars;
                    $continuation.label = 1;
                    v14 = request.snapshot((Continuation<? super CloudCompletionRequest.Snapshot>)$continuation);
                    if (v14 == var36_5) {
                        return var36_5;
                    }
                    ** GOTO lbl156
                }
                case 1: {
                    remainingChars = $continuation.I$1;
                    includedCommandCount = $continuation.I$0;
                    var26_35 = (PSString)$continuation.L$20;
                    var25_36 = (PSString)$continuation.L$19;
                    var24_37 = (PSString)$continuation.L$18;
                    var23_38 = (PSString)$continuation.L$17;
                    var22_39 = (PSString)$continuation.L$16;
                    commandHistory = (String)$continuation.L$15;
                    commandWithOutputHistory = (String)$continuation.L$14;
                    fileTree = (String)$continuation.L$13;
                    projectDir = (VirtualFile)$continuation.L$12;
                    clipboard = (String)$continuation.L$11;
                    commandPrefix = (CharSequence)$continuation.L$10;
                    lastCommandStartOffset = (TerminalOffset)$continuation.L$9;
                    historyBlocks = (List)$continuation.L$8;
                    lastBlock = (TerminalOutputBlock)$continuation.L$7;
                    blocks = (List)$continuation.L$6;
                    blocksModel = (TerminalBlocksModel)$continuation.L$5;
                    text = (PSString)$continuation.L$4;
                    documentContent = (DocumentPrivacyWrapper)$continuation.L$3;
                    requestOffset = (TerminalOffset)$continuation.L$2;
                    outputModel = (TerminalOutputModel)$continuation.L$1;
                    request = (CloudCompletionRequest)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v14 = $result;
lbl156:
                    // 2 sources

                    var27_40 = v14;
                    var30_41 = (CloudCompletionRequest.Snapshot)var27_40;
                    var31_42 = var26_35;
                    var32_43 = var25_36;
                    var33_44 = var24_37;
                    var34_45 = var23_38;
                    var35_46 = var22_39;
                    return new TerminalCloudCompletionContext(var35_46, var34_45, var33_44, var32_43, var31_42, var30_41);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final Pair<String, Integer> buildDetailedHistory$intellij_ml_llm_terminal_completion(@Nullable TerminalOutputModel outputModel, @NotNull List<TerminalOutputBlock> blocks, @NotNull String text2, int limit) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (outputModel == null || blocks.isEmpty() || limit <= 0) {
                return new Pair((Object)"", (Object)0);
            }
            StringBuilder result2 = new StringBuilder();
            int usedChars = 0;
            int includedBlocks = 0;
            int n = ((Collection)blocks).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    TerminalOutputBlock block = blocks.get(i);
                    int blockStartOffset = TerminalCloudCompletionContextKt.access$toRelative(block.getStartOffset(), outputModel);
                    TerminalOffset terminalOffset = block.getOutputStartOffset();
                    int blockOutputStartOffset = terminalOffset != null ? TerminalCloudCompletionContextKt.access$toRelative(terminalOffset, outputModel) : -1;
                    int blockEndOffset = TerminalCloudCompletionContextKt.access$toRelative(block.getEndOffset(), outputModel);
                    String string = text2.substring(blockStartOffset, blockOutputStartOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String command = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
                    String string2 = text2.substring(blockOutputStartOffset, blockEndOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    Object output = StringsKt.removeSuffix((String)string2, (CharSequence)"\n");
                    int commandLen = command.length();
                    int remainingLimit = limit - usedChars;
                    if (Math.min(commandLen + ((String)output).length() + 1, commandLen + 1 + 1000) > remainingLimit) break;
                    ++includedBlocks;
                    if (((String)output).length() > 1000) {
                        String trimmedMarker = "\n...[trimmed]...\n";
                        int availableForOutput = 1000 - trimmedMarker.length();
                        int prefixLen = availableForOutput / 2;
                        int suffixLen = availableForOutput - prefixLen;
                        output = StringsKt.take((String)output, (int)prefixLen) + trimmedMarker + StringsKt.takeLast((String)output, (int)suffixLen);
                    }
                    String toAdd = ((CharSequence)output).length() == 0 ? command + "\n" : command + "\n" + (String)output + "\n";
                    result2.insert(0, toAdd);
                    usedChars += toAdd.length();
                } while (0 <= n);
            }
            return new Pair((Object)result2.toString(), (Object)includedBlocks);
        }

        @NotNull
        public final String buildCommandHistory$intellij_ml_llm_terminal_completion(@Nullable TerminalOutputModel outputModel, @NotNull List<TerminalOutputBlock> blocks, @NotNull String text2, int limit) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (outputModel == null || blocks.isEmpty() || limit <= 0) {
                return "";
            }
            List result2 = new ArrayList();
            int usedChars = 0;
            int n = ((Collection)blocks).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    TerminalOutputBlock block = blocks.get(i);
                    int blockStartOffset = TerminalCloudCompletionContextKt.access$toRelative(block.getStartOffset(), outputModel);
                    TerminalOffset terminalOffset = block.getOutputStartOffset();
                    int blockOutputStartOffset = terminalOffset != null ? TerminalCloudCompletionContextKt.access$toRelative(terminalOffset, outputModel) : -1;
                    String string = text2.substring(blockStartOffset, blockOutputStartOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String command = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
                    int commandLen = command.length() + 1;
                    if (usedChars + commandLen > limit) break;
                    result2.add(command);
                    usedChars += commandLen;
                } while (0 <= n);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String generateFileTree$intellij_ml_llm_terminal_completion(@NotNull VirtualFile root) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                    object = root.getChildren();
                    if (object == null) break block2;
                    Object[] $this$sortedBy$iv = object;
                    boolean $i$f$sortedBy = false;
                    object = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            VirtualFile it = (VirtualFile)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (VirtualFile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                        }
                    });
                    if (object != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, Companion::generateFileTree$lambda$1, (int)30, null)) != null) break block3;
                }
                object = "";
            }
            return object;
        }

        private static final CharSequence generateFileTree$lambda$1(VirtualFile child) {
            return child.getName() + (child.isDirectory() ? "/" : "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

