/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.mssql.generator.MsScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0002H\u0014J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0013*\u00020\u0002H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/mssql/generator/producers/MsCreateSequence;", "Lcom/intellij/database/dialects/base/generator/producers/CreateSequence;", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/mssql/model/MsSequence;)V", "produceComment", "", "exists", "", "comment", "", "gatherSequenceIdentityParameters", "sequence", "parameters", "", "minimumDefault", "Ljava/math/BigInteger;", "maximumDefault", "intellij.database.dialects.mssql"})
public final class MsCreateSequence
extends CreateSequence<MsSequence> {
    public MsCreateSequence(@NotNull ScriptingContext context, @NotNull MsSequence element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(context, (BasicSequence)element);
    }

    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptGeneratorHelperKt.msAlterComment((ElementProducer<? extends BasicElement>)((ElementProducer)this), exists, comment);
    }

    public void gatherSequenceIdentityParameters(@NotNull MsSequence sequence, @NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        DasType dasType = sequence.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (!Intrinsics.areEqual((Object)dasType2, (Object)DasTypeSystemBase.UNKNOWN) && !StringsKt.equals((String)DasTypeUtilsKt.getTypeName((DasType)dasType2), (String)"bigint", (boolean)true)) {
            Collection collection = parameters;
            DasType dasType3 = sequence.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
            collection.add("as " + this.script(dasType3));
        }
        super.gatherSequenceIdentityParameters((BasicSequence)sequence, parameters);
        if (sequence.isCycled()) {
            parameters.add("cycle");
        }
        if (sequence.getCacheSize() < 0L) {
            parameters.add("no cache");
        } else if (sequence.getCacheSize() > 0L) {
            parameters.add("cache " + sequence.getCacheSize());
        }
    }

    @Nullable
    protected BigInteger minimumDefault(@NotNull MsSequence $this$minimumDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumDefault, (String)"<this>");
        DasType dasType = $this$minimumDefault.getUnderlyingType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getUnderlyingType(...)");
        return DasTypeUtilsKt.getMinValue((DasType)dasType);
    }

    @Nullable
    protected BigInteger maximumDefault(@NotNull MsSequence $this$maximumDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$maximumDefault, (String)"<this>");
        DasType dasType = $this$maximumDefault.getUnderlyingType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getUnderlyingType(...)");
        return DasTypeUtilsKt.getMaxValue((DasType)dasType);
    }
}

