/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.ClusterLogPublisher;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesLogHandler;
import com.intellij.kubernetes.api.ProcessFlowEvent;
import com.intellij.kubernetes.view.ui.KubernetesUIUtilitiesKt;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096B\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/api/LogHandlerPublisher;", "Lcom/intellij/kubernetes/api/ClusterLogPublisher;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "allowFocusInterception", "", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Z)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "_logHandler", "Lcom/intellij/kubernetes/api/KubernetesLogHandler;", "logHandler", "getLogHandler", "()Lcom/intellij/kubernetes/api/KubernetesLogHandler;", "invoke", "", "value", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "(Lcom/intellij/kubernetes/api/ProcessFlowEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishIdeProcessLog", "message", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishConsoleProcessLog", "printErr", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nFlowProcessExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowProcessExecutor.kt\ncom/intellij/kubernetes/api/LogHandlerPublisher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n13#2:262\n13#2:263\n*S KotlinDebug\n*F\n+ 1 FlowProcessExecutor.kt\ncom/intellij/kubernetes/api/LogHandlerPublisher\n*L\n239#1:262\n244#1:263\n*E\n"})
public final class LogHandlerPublisher
extends ClusterLogPublisher {
    @NotNull
    private final KubernetesApiModelInterface apiModel;
    private final boolean allowFocusInterception;
    @NotNull
    private final KubernetesLogHandler _logHandler;

    public LogHandlerPublisher(@NotNull KubernetesApiModelInterface apiModel2, boolean allowFocusInterception) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        this.apiModel = apiModel2;
        this.allowFocusInterception = allowFocusInterception;
        this._logHandler = (KubernetesLogHandler)this.apiModel.getProject().getMessageBus().syncPublisher(KubernetesLogHandler.TOPIC);
    }

    @NotNull
    public final KubernetesApiModelInterface getApiModel() {
        return this.apiModel;
    }

    private final KubernetesLogHandler getLogHandler() {
        return !this.apiModel.isDisposed() ? this._logHandler : null;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull ProcessFlowEvent value2, @NotNull Continuation<? super Unit> $completion) {
        ProcessFlowEvent processFlowEvent = value2;
        if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput.OnStdOut) {
            KubernetesLogHandler kubernetesLogHandler = this.getLogHandler();
            if (kubernetesLogHandler != null) {
                String string = ((ProcessFlowEvent.OnProcessOutput.OnStdOut)value2).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                kubernetesLogHandler.printNormal(this.apiModel, string);
            }
        } else if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput.OnStdError) {
            KubernetesLogHandler kubernetesLogHandler = this.getLogHandler();
            if (kubernetesLogHandler != null) {
                String string = ((ProcessFlowEvent.OnProcessOutput.OnStdError)value2).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                kubernetesLogHandler.printError(this.apiModel, string);
            }
        } else if (processFlowEvent instanceof ProcessFlowEvent.OnCommandLine) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LogHandlerPublisher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Publishing command line: " + ((ProcessFlowEvent.OnCommandLine)value2).getCommandLine() + " allowFocusInterception = " + this.allowFocusInterception);
            if (this.allowFocusInterception) {
                KubernetesUIUtilitiesKt.selectContextInServicesView(this.apiModel);
            }
            KubernetesLogHandler kubernetesLogHandler = this.getLogHandler();
            if (kubernetesLogHandler != null) {
                kubernetesLogHandler.printSystem(this.apiModel, "\n" + ((ProcessFlowEvent.OnCommandLine)value2).getCommandLine() + "\n\n");
            }
            $i$f$logger = false;
            Logger logger2 = Logger.getInstance(LogHandlerPublisher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("Publishing command line: " + ((ProcessFlowEvent.OnCommandLine)value2).getCommandLine() + " done");
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object publishIdeProcessLog(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        block0: {
            KubernetesLogHandler kubernetesLogHandler = this.getLogHandler();
            if (kubernetesLogHandler == null) break block0;
            kubernetesLogHandler.printSystem(this.apiModel, message2 + "\n");
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object publishConsoleProcessLog(@NotNull String message2, boolean printErr, @NotNull Continuation<? super Unit> $completion) {
        block1: {
            block0: {
                if (!printErr) break block0;
                KubernetesLogHandler kubernetesLogHandler = this.getLogHandler();
                if (kubernetesLogHandler == null) break block1;
                kubernetesLogHandler.printError(this.apiModel, message2 + "\n");
                break block1;
            }
            KubernetesLogHandler kubernetesLogHandler = this.getLogHandler();
            if (kubernetesLogHandler == null) break block1;
            kubernetesLogHandler.printNormal(this.apiModel, message2 + "\n");
        }
        return Unit.INSTANCE;
    }
}

