/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.execution.rpc.ProcessHandlerId;
import com.intellij.kubernetes.api.ProcessFlowEvent;
import com.intellij.kubernetes.api.ProcessHandlerValueIdType;
import com.intellij.kubernetes.api.SerialisedProcessFlowEvent;
import com.intellij.platform.kernel.ids.BackendGlobalIdsKt;
import com.intellij.platform.kernel.ids.BackendValueIdType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/api/SingleProcessStatefulSerializer;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "processHandlerId", "Lcom/intellij/execution/rpc/ProcessHandlerId;", "serialize", "Lcom/intellij/kubernetes/api/SerialisedProcessFlowEvent;", "event", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "intellij.clouds.kubernetes"})
@ApiStatus.Internal
final class SingleProcessStatefulSerializer {
    @NotNull
    private final CoroutineScope coroutineScope;
    private ProcessHandlerId processHandlerId;

    public SingleProcessStatefulSerializer(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final SerialisedProcessFlowEvent serialize(@NotNull ProcessFlowEvent event2) {
        SerialisedProcessFlowEvent serialisedProcessFlowEvent;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ProcessFlowEvent processFlowEvent = event2;
        if (processFlowEvent instanceof ProcessFlowEvent.OnCommandLine) {
            serialisedProcessFlowEvent = new SerialisedProcessFlowEvent.OnCommandLine(((ProcessFlowEvent.OnCommandLine)event2).getCommandLine());
        } else if (processFlowEvent instanceof ProcessFlowEvent.StartNotified) {
            ProcessHandlerId processHandlerId = this.processHandlerId;
            if (processHandlerId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                processHandlerId = null;
            }
            serialisedProcessFlowEvent = new SerialisedProcessFlowEvent.StartNotified(processHandlerId);
        } else if (processFlowEvent instanceof ProcessFlowEvent.ProcessTerminated) {
            ProcessHandlerId processHandlerId = this.processHandlerId;
            if (processHandlerId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                processHandlerId = null;
            }
            serialisedProcessFlowEvent = new SerialisedProcessFlowEvent.ProcessTerminated(processHandlerId);
        } else if (processFlowEvent instanceof ProcessFlowEvent.ProcessWillTerminate) {
            ProcessHandlerId processHandlerId = this.processHandlerId;
            if (processHandlerId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                processHandlerId = null;
            }
            serialisedProcessFlowEvent = new SerialisedProcessFlowEvent.ProcessWillTerminate(processHandlerId, ((ProcessFlowEvent.ProcessWillTerminate)event2).getWillBeDestroyed());
        } else if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput) {
            SerialisedProcessFlowEvent.OnProcessOutput onProcessOutput;
            ProcessFlowEvent.OnProcessOutput onProcessOutput2 = (ProcessFlowEvent.OnProcessOutput)event2;
            if (onProcessOutput2 instanceof ProcessFlowEvent.OnProcessOutput.OnSystem) {
                ProcessHandlerId processHandlerId = this.processHandlerId;
                if (processHandlerId == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                    processHandlerId = null;
                }
                String string = ((ProcessFlowEvent.OnProcessOutput.OnSystem)event2).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                onProcessOutput = new SerialisedProcessFlowEvent.OnProcessOutput(processHandlerId, string, "SYSTEM");
            } else if (onProcessOutput2 instanceof ProcessFlowEvent.OnProcessOutput.OnStdOut) {
                ProcessHandlerId processHandlerId = this.processHandlerId;
                if (processHandlerId == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                    processHandlerId = null;
                }
                String string = ((ProcessFlowEvent.OnProcessOutput.OnStdOut)event2).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                onProcessOutput = new SerialisedProcessFlowEvent.OnProcessOutput(processHandlerId, string, "STDOUT");
            } else if (onProcessOutput2 instanceof ProcessFlowEvent.OnProcessOutput.OnStdError) {
                ProcessHandlerId processHandlerId = this.processHandlerId;
                if (processHandlerId == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                    processHandlerId = null;
                }
                String string = ((ProcessFlowEvent.OnProcessOutput.OnStdError)event2).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                onProcessOutput = new SerialisedProcessFlowEvent.OnProcessOutput(processHandlerId, string, "STDERR");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            serialisedProcessFlowEvent = onProcessOutput;
        } else if (processFlowEvent instanceof ProcessFlowEvent.ProcessNotStarted) {
            ProcessHandlerId processHandlerId = this.processHandlerId;
            if (processHandlerId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                processHandlerId = null;
            }
            String string = ((ProcessFlowEvent.ProcessNotStarted)event2).getException().getCommandLine().getCommandLineString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
            String string2 = ((ProcessFlowEvent.ProcessNotStarted)event2).getException().getMessage();
            if (string2 == null) {
                string2 = "";
            }
            serialisedProcessFlowEvent = new SerialisedProcessFlowEvent.ProcessNotStarted(processHandlerId, string, string2);
        } else if (processFlowEvent instanceof ProcessFlowEvent.OnProcessReady) {
            this.processHandlerId = (ProcessHandlerId)BackendGlobalIdsKt.storeValueGlobally((CoroutineScope)this.coroutineScope, (Object)((ProcessFlowEvent.OnProcessReady)event2).getProcessHandle(), (BackendValueIdType)ProcessHandlerValueIdType.INSTANCE);
            ProcessHandlerId processHandlerId = this.processHandlerId;
            if (processHandlerId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandlerId");
                processHandlerId = null;
            }
            serialisedProcessFlowEvent = new SerialisedProcessFlowEvent.OnProcessReady(processHandlerId);
        } else {
            throw new UnsupportedOperationException("unknown event type: " + event2);
        }
        return serialisedProcessFlowEvent;
    }
}

