/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.util.KubernetesPodStateKt;
import com.intellij.kubernetes.util.PodPhase;
import com.intellij.kubernetes.util.PodState;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObjectImpl;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEphemeralContainerObjectImpl;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesInitContainerObjectImpl;
import com.intellij.ui.LayeredIcon;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1EphemeralContainer;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"basicIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "PodSucceeded", "Lcom/intellij/ui/LayeredIcon;", "PodFailed", "PodPending", "PodRunning", "getPodStatusIcon", "resource", "Lio/kubernetes/client/openapi/models/V1Pod;", "getPodContainers", "", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "context", "Lcom/intellij/kubernetes/api/Context;", "value", "getPodBasicContainers", "getPodInitContainers", "getPodEphemeralContainers", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodServiceViewContributorDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodServiceViewContributorDescriptor.kt\ncom/intellij/kubernetes/view/nodes/workloads/KubernetesPodServiceViewContributorDescriptorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1617#2,9:189\n1869#2:198\n1870#2:200\n1626#2:201\n1617#2,9:202\n1869#2:211\n1870#2:213\n1626#2:214\n1617#2,9:215\n1869#2:224\n1870#2:226\n1626#2:227\n1#3:199\n1#3:212\n1#3:225\n*S KotlinDebug\n*F\n+ 1 KubernetesPodServiceViewContributorDescriptor.kt\ncom/intellij/kubernetes/view/nodes/workloads/KubernetesPodServiceViewContributorDescriptorKt\n*L\n177#1:189,9\n177#1:198\n177#1:200\n177#1:201\n181#1:202,9\n181#1:211\n181#1:213\n181#1:214\n185#1:215,9\n185#1:224\n185#1:226\n185#1:227\n177#1:199\n181#1:212\n185#1:225\n*E\n"})
public final class KubernetesPodServiceViewContributorDescriptorKt {
    @NotNull
    private static final Icon basicIcon;
    @NotNull
    private static final LayeredIcon PodSucceeded;
    @NotNull
    private static final LayeredIcon PodFailed;
    @NotNull
    private static final LayeredIcon PodPending;
    @NotNull
    private static final LayeredIcon PodRunning;

    private static final Icon getPodStatusIcon(V1Pod resource) {
        PodState detectPodState = KubernetesPodStateKt.detectPodState(resource);
        return switch (WhenMappings.$EnumSwitchMapping$0[detectPodState.getPodPhase().ordinal()]) {
            case 1 -> (Icon)(detectPodState.haveIssues() ? KubernetesPodServiceViewContributorDescriptorKt.getPodStatusIcon$addBadge(basicIcon) : PodPending);
            case 2 -> (Icon)(detectPodState.haveIssues() ? KubernetesPodServiceViewContributorDescriptorKt.getPodStatusIcon$addBadge(basicIcon) : PodRunning);
            case 3 -> (Icon)PodSucceeded;
            case 4 -> (Icon)PodFailed;
            default -> basicIcon;
        };
    }

    @NotNull
    public static final List<KubernetesContainerObject> getPodContainers(@NotNull Context context, @NotNull V1Pod value2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)KubernetesPodServiceViewContributorDescriptorKt.getPodInitContainers(context, value2), (Iterable)KubernetesPodServiceViewContributorDescriptorKt.getPodBasicContainers(context, value2)), (Iterable)KubernetesPodServiceViewContributorDescriptorKt.getPodEphemeralContainers(context, value2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KubernetesContainerObject> getPodBasicContainers(@NotNull Context context, @NotNull V1Pod value2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        V1PodSpec v1PodSpec = value2.getSpec();
        Intrinsics.checkNotNull((Object)v1PodSpec);
        List list2 = v1PodSpec.getContainers();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContainers(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            V1Container it = (V1Container)element$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            KubernetesContainerObject kubernetesContainerObject = KubernetesContainerObjectImpl.Companion.createContainerObject(context, value2, string);
            if (kubernetesContainerObject == null) {
                kubernetesContainerObject = null;
            }
            if (kubernetesContainerObject == null) continue;
            KubernetesContainerObject it$iv$iv = kubernetesContainerObject;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KubernetesContainerObject> getPodInitContainers(@NotNull Context context, @NotNull V1Pod value2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        V1PodSpec v1PodSpec = value2.getSpec();
        Intrinsics.checkNotNull((Object)v1PodSpec);
        List list3 = v1PodSpec.getInitContainers();
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                V1Container it = (V1Container)element$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                KubernetesContainerObject kubernetesContainerObject = KubernetesInitContainerObjectImpl.Companion.createInitContainerObject(context, value2, string);
                if (kubernetesContainerObject == null) {
                    kubernetesContainerObject = null;
                }
                if (kubernetesContainerObject == null) continue;
                KubernetesContainerObject it$iv$iv = kubernetesContainerObject;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KubernetesContainerObject> getPodEphemeralContainers(@NotNull Context context, @NotNull V1Pod value2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        V1PodSpec v1PodSpec = value2.getSpec();
        Intrinsics.checkNotNull((Object)v1PodSpec);
        List list3 = v1PodSpec.getEphemeralContainers();
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                V1EphemeralContainer it = (V1EphemeralContainer)element$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                KubernetesContainerObject kubernetesContainerObject = KubernetesEphemeralContainerObjectImpl.Companion.createEphemeralContainerObject(context, value2, string);
                if (kubernetesContainerObject == null) {
                    kubernetesContainerObject = null;
                }
                if (kubernetesContainerObject == null) continue;
                KubernetesContainerObject it$iv$iv = kubernetesContainerObject;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final Icon[] PodSucceeded$lambda$0() {
        Icon[] iconArray = new Icon[2];
        iconArray[0] = basicIcon;
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.DoneMark, (String)"DoneMark");
        return iconArray;
    }

    private static final Icon[] PodFailed$lambda$0() {
        Icon[] iconArray = new Icon[2];
        iconArray[0] = basicIcon;
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.ErrorMark, (String)"ErrorMark");
        return iconArray;
    }

    private static final Icon[] PodPending$lambda$0() {
        Icon[] iconArray = new Icon[2];
        iconArray[0] = basicIcon;
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.ProcessMark, (String)"ProcessMark");
        return iconArray;
    }

    private static final Icon[] PodRunning$lambda$0() {
        Icon[] iconArray = new Icon[2];
        iconArray[0] = basicIcon;
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RemoteServers.ResumeScaled, (String)"ResumeScaled");
        return iconArray;
    }

    private static final LayeredIcon getPodStatusIcon$addBadge(Icon icon) {
        return LayeredIcon.Companion.layeredIcon(() -> KubernetesPodServiceViewContributorDescriptorKt.getPodStatusIcon$addBadge$lambda$0(icon));
    }

    private static final Icon[] getPodStatusIcon$addBadge$lambda$0(Icon $icon) {
        Icon[] iconArray = new Icon[2];
        iconArray[0] = $icon;
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Nodes.WarningMark, (String)"WarningMark");
        return iconArray;
    }

    public static final /* synthetic */ Icon access$getPodStatusIcon(V1Pod resource) {
        return KubernetesPodServiceViewContributorDescriptorKt.getPodStatusIcon(resource);
    }

    static {
        Icon icon = KubernetesIcons.Pod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Pod");
        basicIcon = icon;
        PodSucceeded = LayeredIcon.Companion.layeredIcon(KubernetesPodServiceViewContributorDescriptorKt::PodSucceeded$lambda$0);
        PodFailed = LayeredIcon.Companion.layeredIcon(KubernetesPodServiceViewContributorDescriptorKt::PodFailed$lambda$0);
        PodPending = LayeredIcon.Companion.layeredIcon(KubernetesPodServiceViewContributorDescriptorKt::PodPending$lambda$0);
        PodRunning = LayeredIcon.Companion.layeredIcon(KubernetesPodServiceViewContributorDescriptorKt::PodRunning$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PodPhase.values().length];
            try {
                nArray[PodPhase.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PodPhase.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PodPhase.SUCCEEDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PodPhase.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

