/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesPodService;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerServiceViewDescriptor;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesCreateActionsUtilKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import io.kubernetes.client.openapi.models.V1Container;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesContainerOpenConsoleAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareAction;", "<init>", "()V", "update", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodOpenConsoleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodOpenConsoleAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesContainerOpenConsoleAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n13#2:93\n*S KotlinDebug\n*F\n+ 1 KubernetesPodOpenConsoleAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesContainerOpenConsoleAction\n*L\n74#1:93\n*E\n"})
public final class KubernetesContainerOpenConsoleAction
extends KubernetesModelBasedDumbAwareAction {
    @Override
    protected void update(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        KubernetesApiModel kubernetesApiModel = ActionUtilsKt.getBackendApiModel(event2);
        event2.getPresentation().setEnabled((kubernetesApiModel != null ? kubernetesApiModel.isConnected() : false) && ActionUtilsKt.canGetServiceContainer(event2));
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, "pod-open-console");
        Project project3 = apiModel2.getProject();
        String string = KubernetesBundle.message("k8s.logs.progress.title.processing.selected.resource", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        List containers2 = (List)TasksKt.runWithModalProgressBlocking((Project)project3, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KubernetesContainerObject>>, Object>(event2, null){
            int label;
            final /* synthetic */ AnActionEvent $event;
            {
                this.$event = $event;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ActionUtilsKt.getServiceContainers(this.$event, (Continuation<? super List<? extends KubernetesContainerObject>>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends KubernetesContainerObject>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (containers2.size() != 1) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KubernetesContainerOpenConsoleAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unexpected number of containers: " + containers2.size());
            event2.getPresentation().setEnabled(false);
            return;
        }
        KubernetesContainerObject container = (KubernetesContainerObject)CollectionsKt.single((List)containers2);
        KubernetesContainerServiceViewDescriptor kubernetesContainerServiceViewDescriptor = KubernetesCreateActionsUtilKt.getSelectedContainerDescriptor(event2);
        Intrinsics.checkNotNull((Object)kubernetesContainerServiceViewDescriptor);
        KubernetesContainerServiceViewDescriptor containerDescriptor = kubernetesContainerServiceViewDescriptor;
        V1Container v1Container = container.getContainerSpec();
        V1Container v1Container2 = container.getContainerSpec();
        KubernetesPodService.Companion.getInstance(project2).attachPodConsole(apiModel2, container.getParentPod(), container, containerDescriptor.getContent().createConsolePanel(container), v1Container != null ? Intrinsics.areEqual((Object)v1Container.getStdin(), (Object)true) : false, v1Container2 != null ? Intrinsics.areEqual((Object)v1Container2.getTty(), (Object)true) : false);
    }
}

