/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.common.browser;

import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.javascript.debugger.common.JavascriptDebuggerSharedBundle;
import com.intellij.javascript.debugger.common.browser.BrowserDetectionKt;
import com.intellij.javascript.debugger.common.browser.CdpTransportType;
import com.intellij.javascript.debugger.common.browser.FailedToStartSessionException;
import com.intellij.javascript.debugger.common.browser.ProcessUtils;
import com.intellij.javascript.debugger.common.browser.ProcessUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.OS;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000fH\u0000\u001a\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0080@\u00a2\u0006\u0002\u0010\u001a\u001a \u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0004\b \u0010!\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010#\u001a\u0014\u0010$\u001a\u00020%*\u00020\u001d2\u0006\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u001a\u0010&\u001a\u00020%*\u00020\u001d2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0(H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DEV_TOOLS_URI_PATTERN", "Ljava/util/regex/Pattern;", "getDEV_TOOLS_URI_PATTERN", "()Ljava/util/regex/Pattern;", "EMPTY_PAGE_URL", "", "lockFileExists", "", "userDataDir", "Ljava/nio/file/Path;", "getTransportType", "Lcom/intellij/javascript/debugger/common/browser/CdpTransportType;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getUserDataDir", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "transport", "url", "chromeSettingsOrFail", "Lcom/intellij/ide/browsers/chrome/ChromeSettings;", "spinAndReadPortFile", "Ljava/net/URI;", "devToolsActivePortFile", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "terminateGracefully", "", "Lcom/intellij/execution/process/KillableProcessHandler;", "gracefulTerminationPeriod", "Lkotlin/time/Duration;", "terminateGracefully-8Mi8wO0", "(Lcom/intellij/execution/process/KillableProcessHandler;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitTermination", "(Lcom/intellij/execution/process/KillableProcessHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logProcessOutput", "", "onTermination", "callback", "Lkotlin/Function0;", "intellij.javascript.debugger.common"})
@SourceDebugExtension(value={"SMAP\nprocessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 processUtils.kt\ncom/intellij/javascript/debugger/common/browser/ProcessUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,264:1\n1#2:265\n13#3:266\n*S KotlinDebug\n*F\n+ 1 processUtils.kt\ncom/intellij/javascript/debugger/common/browser/ProcessUtilsKt\n*L\n32#1:266\n*E\n"})
public final class ProcessUtilsKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Pattern DEV_TOOLS_URI_PATTERN;
    @NotNull
    public static final String EMPTY_PAGE_URL = "about:blank";

    @NotNull
    public static final Pattern getDEV_TOOLS_URI_PATTERN() {
        return DEV_TOOLS_URI_PATTERN;
    }

    public static final boolean lockFileExists(@NotNull Path userDataDir) {
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Path lockFilePath = switch (WhenMappings.$EnumSwitchMapping$0[OS.CURRENT.getPlatform().ordinal()]) {
            case 1 -> userDataDir.resolve("lockfile");
            case 2 -> userDataDir.resolve("SingletonLock");
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)lockFilePath);
        Path path = lockFilePath;
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        return Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @Nullable
    public static final CdpTransportType getTransportType(@NotNull WebBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Object object = browser.getSpecificSettings();
        if (object == null || (object = object.getAdditionalParameters()) == null) {
            return null;
        }
        Object parameters = object;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            String param = (String)iterator.next();
            Intrinsics.checkNotNull((Object)param);
            if (StringsKt.startsWith$default((String)param, (String)"--remote-debugging-pipe", (boolean)false, (int)2, null)) {
                return CdpTransportType.Pipe.INSTANCE;
            }
            if (!StringsKt.startsWith$default((String)param, (String)"--remote-debugging-port=", (boolean)false, (int)2, null)) continue;
            Integer n = StringsKt.toIntOrNull((String)StringsKt.substringAfter$default((String)param, (String)"--remote-debugging-port=", null, (int)2, null));
            if (n == null) {
                Object[] objectArray = new Object[]{param};
                throw new FailedToStartSessionException(JavascriptDebuggerSharedBundle.message("dialog.message.invalid.port.number.in.browser.command.line", objectArray), null, 2, null);
            }
            int port = n;
            return new CdpTransportType.TcpSocket(port);
        }
        return null;
    }

    @NotNull
    public static final Path getUserDataDir(@NotNull WebBrowser browser) {
        String string;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        ChromeSettings settings = ProcessUtilsKt.chromeSettingsOrFail(browser);
        if (settings.isUseCustomProfile()) {
            logger.info("Using custom user data directory: " + settings.getUserDataDirectoryPath());
            string = settings.getUserDataDirectoryPath();
            if (string == null) {
                throw new FailedToStartSessionException(JavascriptDebuggerSharedBundle.message("dialog.message.please.specify.path.to.chrome.user.data.directory", new Object[0]), null, 2, null);
            }
        } else {
            String string2;
            String it = string2 = ChromeSettingsConfigurable.getDefaultUserDataPath();
            boolean bl = false;
            logger.info("Using default user data directory: " + it);
            string = string2;
        }
        String rawUserDataDir = string;
        Path path = NioFiles.toPath((String)rawUserDataDir);
        if (path == null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemDependentName((String)rawUserDataDir), (String)"toSystemDependentName(...)");
            throw new FailedToStartSessionException(JavascriptDebuggerSharedBundle.message("dialog.message.invalid.user.data.directory", objectArray), null, 2, null);
        }
        Path userDataDir = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(userDataDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        return userDataDir;
    }

    @NotNull
    public static final GeneralCommandLine buildCommandLine(@NotNull WebBrowser browser, @NotNull Path userDataDir, @NotNull CdpTransportType transport, @Nullable String url) {
        List list;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Map map = new GeneralCommandLine().getParentEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParentEnvironment(...)");
        Object object = BrowserDetectionKt.detectBrowserBinary$default(browser, path, map, null, null, 24, null);
        ResultKt.throwOnFailure((Object)object);
        Path browserPath = (Path)object;
        ChromeSettings chromeSettings = ProcessUtilsKt.chromeSettingsOrFail(browser);
        List $this$buildCommandLine_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String param : chromeSettings.getAdditionalParameters()) {
            Intrinsics.checkNotNull((Object)param);
            if (StringsKt.startsWith$default((String)param, (String)"--user-data-dir=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)param, (String)"--remote-debugging-pipe", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)param, (String)"--remote-debugging-port=", (boolean)false, (int)2, null)) continue;
            $this$buildCommandLine_u24lambda_u240.add(param);
        }
        $this$buildCommandLine_u24lambda_u240.add("--user-data-dir=" + userDataDir);
        $this$buildCommandLine_u24lambda_u240.add("--no-first-run");
        $this$buildCommandLine_u24lambda_u240.add("--disable-fre");
        $this$buildCommandLine_u24lambda_u240.add("--no-default-browser-check");
        CdpTransportType cdpTransportType = transport;
        if (cdpTransportType instanceof CdpTransportType.Pipe) {
            v3 = $this$buildCommandLine_u24lambda_u240.add("--remote-debugging-pipe");
        } else if (cdpTransportType instanceof CdpTransportType.TcpSocket) {
            v3 = $this$buildCommandLine_u24lambda_u240.add("--remote-debugging-port=" + ((CdpTransportType.TcpSocket)transport).getPort());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (url != null) {
            $this$buildCommandLine_u24lambda_u240.add(url);
        }
        List additionalParameters = CollectionsKt.build((List)list);
        String[] stringArray = new String[]{((Object)browserPath).toString()};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray).withParameters(additionalParameters);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        return commandLine;
    }

    public static /* synthetic */ GeneralCommandLine buildCommandLine$default(WebBrowser webBrowser, Path path, CdpTransportType cdpTransportType, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = EMPTY_PAGE_URL;
        }
        return ProcessUtilsKt.buildCommandLine(webBrowser, path, cdpTransportType, string);
    }

    @NotNull
    public static final ChromeSettings chromeSettingsOrFail(@NotNull WebBrowser $this$chromeSettingsOrFail) {
        Intrinsics.checkNotNullParameter((Object)$this$chromeSettingsOrFail, (String)"<this>");
        BrowserSpecificSettings browserSpecificSettings = $this$chromeSettingsOrFail.getSpecificSettings();
        ChromeSettings chromeSettings = browserSpecificSettings instanceof ChromeSettings ? (ChromeSettings)browserSpecificSettings : null;
        if (chromeSettings == null) {
            throw new AssertionError((Object)"Browser is not Chrome. Must be checked in Run configuration.");
        }
        return chromeSettings;
    }

    @Nullable
    public static final Object spinAndReadPortFile(@NotNull Path devToolsActivePortFile, @NotNull Continuation<? super URI> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super URI>, Object>(devToolsActivePortFile, null){
            int label;
            final /* synthetic */ Path $devToolsActivePortFile;
            {
                this.$devToolsActivePortFile = $devToolsActivePortFile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            v0 = new LinkOption[]{};
                            if (Files.exists(this.$devToolsActivePortFile, Arrays.copyOf(v0, v0.length))) {
                                var3_3 = this.$devToolsActivePortFile;
                                v1 = Files.readAllLines(var3_3, Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue(v1, (String)"readAllLines(...)");
                                portFileContent = v1;
                                devToolsPort = Integer.parseInt((String)CollectionsKt.first(portFileContent));
                                devToolsPath = (String)CollectionsKt.last(portFileContent);
                                return new URI("https://localhost:" + devToolsPort + devToolsPath);
                            }
                            this.label = 1;
                            v2 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)150, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                            if (v2 != var5_2) continue;
                            return var5_2;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super URI> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public static final Object terminateGracefully-8Mi8wO0(@NotNull KillableProcessHandler $this$terminateGracefully_u2d8Mi8wO0, long l, @NotNull Continuation<? super Integer> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>($this$terminateGracefully_u2d8Mi8wO0, l, null){
            Object L$0;
            int label;
            final /* synthetic */ KillableProcessHandler $this_terminateGracefully;
            final /* synthetic */ long $$v$c$kotlin-time-Duration$-gracefulTerminationPeriod$0;
            {
                this.$this_terminateGracefully = $receiver;
                this.$$v$c$kotlin-time-Duration$-gracefulTerminationPeriod$0 = l;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$this_terminateGracefully.isStartNotified()) {
                            this.$this_terminateGracefully.startNotify();
                        }
                        this.$this_terminateGracefully.destroyProcess();
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout-KLykuaI((long)this.$$v$c$kotlin-time-Duration$-gracefulTerminationPeriod$0, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this.$this_terminateGracefully, null){
                            int label;
                            final /* synthetic */ KillableProcessHandler $this_terminateGracefully;
                            {
                                this.$this_terminateGracefully = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = ProcessUtilsKt.awaitTermination(this.$this_terminateGracefully, (Continuation<? super Integer>)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        Object object3 = object2;
                        if (object2 != object) return (Integer)object3;
                        return object;
                    }
                    case 1: {
                        Object object4;
                        Object object3;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return (Integer)object3;
                        }
                        catch (TimeoutCancellationException e) {
                            ProcessUtilsKt.access$getLogger$p().warn("Failed to terminate process gracefully within " + Duration.toString-impl((long)this.$$v$c$kotlin-time-Duration$-gracefulTerminationPeriod$0) + ". Killing...", (Throwable)e);
                            this.$this_terminateGracefully.killProcess();
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)((Object)e));
                            this.label = 2;
                            Object object5 = ProcessUtilsKt.awaitTermination(this.$this_terminateGracefully, (Continuation<? super Integer>)((Continuation)this));
                            object4 = object5;
                            if (object5 != object) return (Integer)object4;
                            return object;
                        }
                    }
                    case 2: {
                        TimeoutCancellationException e = (TimeoutCancellationException)((Object)this.L$0);
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return (Integer)object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object terminateGracefully-8Mi8wO0$default(KillableProcessHandler killableProcessHandler, long l, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        }
        return ProcessUtilsKt.terminateGracefully-8Mi8wO0(killableProcessHandler, l, (Continuation<? super Integer>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static final Object awaitTermination(@NotNull KillableProcessHandler $this$awaitTermination, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof awaitTermination.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProcessUtilsKt.awaitTermination(null, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                listener = new ProcessListener((CompletableDeferred<Integer>)result){
                    final /* synthetic */ CompletableDeferred<Integer> $result;
                    {
                        this.$result = $result;
                    }

                    public void processTerminated(ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$result.complete((Object)event.getExitCode());
                    }
                };
                $this$awaitTermination.addProcessListener((ProcessListener)listener);
                if (!$this$awaitTermination.isProcessTerminated()) ** GOTO lbl22
                var4_7 = $this$awaitTermination.getExitCode();
                $this$awaitTermination.removeProcessListener((ProcessListener)listener);
                return var4_7;
lbl22:
                // 2 sources

                $continuation.L$0 = $this$awaitTermination;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)result);
                $continuation.L$2 = listener;
                $continuation.label = 1;
                v0 = result.await((Continuation)$continuation);
                ** if (v0 != var8_4) goto lbl29
lbl28:
                // 1 sources

                return var8_4;
lbl29:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                listener = $continuation.L$2;
                result = (CompletableDeferred)$continuation.L$1;
                $this$awaitTermination = (KillableProcessHandler)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    var4_8 = v0;
                    return var4_8;
                }
                catch (Throwable var5_9) {
                    throw var5_9;
                }
                finally {
                    $this$awaitTermination.removeProcessListener((ProcessListener)listener);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void logProcessOutput(@NotNull KillableProcessHandler $this$logProcessOutput, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)$this$logProcessOutput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        $this$logProcessOutput.addProcessListener((ProcessListener)new ProcessAdapter(logger, $this$logProcessOutput){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ KillableProcessHandler $this_logProcessOutput;
            {
                this.$logger = $logger;
                this.$this_logProcessOutput = $receiver;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                    this.$logger.debug(event.getText());
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$logger.info("Process finished with exit code " + event.getExitCode());
                this.$this_logProcessOutput.removeProcessListener((ProcessListener)this);
            }
        });
    }

    public static final void onTermination(@NotNull KillableProcessHandler $this$onTermination, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$onTermination, (String)"<this>");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if ($this$onTermination.isProcessTerminated()) {
            ProcessUtilsKt.onTermination$runCallback($this$onTermination, callback);
            return;
        }
        $this$onTermination.addProcessListener(new ProcessListener($this$onTermination, callback){
            final /* synthetic */ KillableProcessHandler $this_onTermination;
            final /* synthetic */ Function0<Unit> $callback;
            {
                this.$this_onTermination = $receiver;
                this.$callback = $callback;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ProcessUtilsKt.access$onTermination$runCallback(this.$this_onTermination, this.$callback);
                this.$this_onTermination.removeProcessListener((ProcessListener)this);
            }
        });
    }

    private static final void onTermination$runCallback(KillableProcessHandler $this_onTermination, Function0<Unit> $callback) {
        Object object;
        KillableProcessHandler killableProcessHandler = $this_onTermination;
        try {
            KillableProcessHandler $this$onTermination_u24runCallback_u24lambda_u240 = killableProcessHandler;
            boolean bl = false;
            $callback.invoke();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)logger);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ void access$onTermination$runCallback(KillableProcessHandler $this_onTermination, Function0 $callback) {
        ProcessUtilsKt.onTermination$runCallback($this_onTermination, (Function0<Unit>)$callback);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProcessUtilsKt.logger = logger;
        Pattern pattern = Pattern.compile("^\\s*DevTools listening on (?<url>.*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        DEV_TOOLS_URI_PATTERN = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.UNIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

