/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions;

import com.goide.GoNotifications;
import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.util.GoUtil;
import com.intellij.CommonBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoShareInPlaygroundAction
extends DumbAwareAction {
    public GoShareInPlaygroundAction() {
    }

    protected GoShareInPlaygroundAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoShareInPlaygroundAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoShareInPlaygroundAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(GoShareInPlaygroundAction.getFile(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GoShareInPlaygroundAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        GoFile file2 = GoShareInPlaygroundAction.getFile(e);
        if (project != null && file2 != null) {
            if (!GoShareInPlaygroundAction.confirmShare(file2.getName())) {
                return;
            }
            String text = file2.getText();
            boolean go2 = GoUtil.isGo2File(file2.getName());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String url = go2 ? "https://go2goplay.golang.org/share" : "https://go.dev/_/share";
                try {
                    RequestBuilder post = HttpRequests.post((String)url, (String)"text/plain");
                    String shareId = (String)post.connect(request -> {
                        request.write(text);
                        return request.readString();
                    });
                    if (StringUtil.isEmptyOrSpaces((String)shareId)) {
                        String message = GoBundle.message((String)"action.GoShareInPlaygroundAction.empty.id", (Object[])new Object[0]);
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)GoBundle.message((String)"action.GoShareInPlaygroundAction.error", (Object[])new Object[]{message}), (String)CommonBundle.getErrorTitle()));
                        return;
                    }
                    String sharedUrl = (go2 ? "https://go2goplay.golang.org/p/" : "https://go.dev/play/p/") + shareId;
                    String version = this.getGoBackendVersion();
                    boolean versioned = version != null;
                    String versionedSharedUrl = versioned ? sharedUrl + "?v=" + version : sharedUrl;
                    GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"action.GoShareInPlaygroundAction.notification.text", (Object[])new Object[]{versionedSharedUrl}), NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER).addAction((AnAction)NotificationAction.createSimple((String)GoBundle.message((String)"action.GoShareInPlaygroundAction.notification.copyUrl", (Object[])new Object[0]), () -> CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(versionedSharedUrl)))).notify(project);
                }
                catch (IOException exception) {
                    String message = exception.getMessage();
                    if (message == null) {
                        message = exception.getClass().getName();
                    }
                    String finalMessage = message;
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)GoBundle.message((String)"action.GoShareInPlaygroundAction.error", (Object[])new Object[]{finalMessage}), (String)CommonBundle.getErrorTitle()));
                }
            });
        }
    }

    @Nullable
    private static GoFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            GoShareInPlaygroundAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        PsiManager psiManager = project != null ? PsiManager.getInstance((Project)project) : null;
        return (GoFile)((Object)ObjectUtils.tryCast(psiManager != null && file2 != null ? psiManager.findFile(file2) : null, GoFile.class));
    }

    public static boolean confirmShare(@NotNull String fileName) {
        boolean showConfirmation;
        if (fileName == null) {
            GoShareInPlaygroundAction.$$$reportNull$$$0(4);
        }
        if (!(showConfirmation = GoCodeInsightSettings.getInstance().isAskConfirmationForShareInPlayground())) {
            return true;
        }
        DoNotAskOption.Adapter doNotAskOption = new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    GoCodeInsightSettings.getInstance().setAskConfirmationForShareInPlayground(false);
                }
            }
        };
        return Messages.showOkCancelDialog((String)GoBundle.message((String)"action.GoShareInPlaygroundAction.confirmation", (Object[])new Object[]{fileName}), (String)GoBundle.message((String)"action.GoShareInPlaygroundAction.text", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon(), (DoNotAskOption)doNotAskOption) == 0;
    }

    @Nullable
    protected String getGoBackendVersion() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/GoShareInPlaygroundAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/GoShareInPlaygroundAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "confirmShare";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

