/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.tool;

import com.goide.GoNotifications;
import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.sdk.GoSdkUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GoGetPackageClipboardListener
extends ClipboardAnalyzeListener {
    private static final Pattern ISSUES_PATTERN = Pattern.compile(".*/(issues|pull)/\\d+$");
    private static final Pattern VCS_PATH_PATTERN = Pattern.compile("^((github.com|bitbucket.org|hub.jazz.net/git|git.apache.org)(/[A-Za-z0-9_.\\-]+){2})(/[\\p{L}0-9_.\\-]+)*$");

    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(0);
        }
        if (GoCodeInsightSettings.getInstance().isDetectGoPackageFromClipboard()) {
            super.applicationActivated(ideFrame);
        }
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(1);
        }
        if (GoCodeInsightSettings.getInstance().isDetectGoPackageFromClipboard()) {
            super.applicationDeactivated(ideFrame);
        }
    }

    protected void handle(@NotNull Project project, @NotNull String value2) {
        if (project == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(2);
        }
        if (value2 == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(3);
        }
        if (GoGetPackageClipboardListener.isDisabledIn(project)) {
            return;
        }
        String importPath = GoGetPackageClipboardListener.extractPackageName(value2);
        String title = GoBundle.message((String)"go.notification.install.package.action.text", (Object[])new Object[]{importPath});
        Notification notification = GoNotifications.getGeneralGroup().createNotification(title, NotificationType.INFORMATION);
        for (GoImportResolver resolver : GoImportResolver.EP_NAME.getExtensionList()) {
            List<NotificationAction> actions = resolver.getInstallPackageActions(importPath, project, notification);
            if (actions == null) continue;
            for (NotificationAction action : actions) {
                notification.addAction((AnAction)action);
            }
        }
        notification.addAction((AnAction)NotificationAction.createSimple((String)GoBundle.message((String)"go.notification.do.not.show.action.text", (Object[])new Object[0]), () -> {
            notification.expire();
            GoCodeInsightSettings.getInstance().setDetectGoPackageFromClipboard(false);
        }));
        notification.notify(project);
    }

    public boolean canHandle(@NotNull String value2) {
        if (value2 == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(4);
        }
        if (StringUtil.countNewLines((CharSequence)value2) > 0) {
            return false;
        }
        String packageName = GoGetPackageClipboardListener.extractPackageName(value2);
        return VCS_PATH_PATTERN.matcher(packageName).matches() && !ISSUES_PATTERN.matcher(packageName).matches();
    }

    @NotNull
    private static String extractPackageName(@NotNull String url) {
        if (url == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(5);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimTrailing((String)GoGetPackageClipboardListener.removeProtocolPrefix(url), (char)'/'), (String)".git");
        if (string == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String removeProtocolPrefix(String url) {
        int index = url.indexOf(64);
        if (index != -1) {
            String string = url.substring(index + 1).replace(':', '/');
            if (string == null) {
                GoGetPackageClipboardListener.$$$reportNull$$$0(7);
            }
            return string;
        }
        index = url.indexOf("://");
        if (index != -1) {
            String string = url.substring(index + 3);
            if (string == null) {
                GoGetPackageClipboardListener.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isDisabledIn(@NotNull Project project) {
        if (project == null) {
            GoGetPackageClipboardListener.$$$reportNull$$$0(10);
        }
        return project.isDefault() || GoSdkUtil.getGoModules(project).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideFrame";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/tool/GoGetPackageClipboardListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/tool/GoGetPackageClipboardListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPackageName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeProtocolPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applicationActivated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applicationDeactivated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canHandle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractPackageName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDisabledIn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

