/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.editorActions;

import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoJoinStatementsHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        if (document == null) {
            GoJoinStatementsHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GoJoinStatementsHandler.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof GoFile)) {
            return -1;
        }
        PsiElement first = GoJoinStatementsHandler.findDeclaration(document, document.getLineNumber(start), file2.findElementAt(start), true);
        PsiElement second = GoJoinStatementsHandler.findDeclaration(document, document.getLineNumber(end), file2.findElementAt(end), false);
        if (first == null || second == null || first == second || first instanceof GoStatement && !(second instanceof GoStatement) || second instanceof GoStatement && !(first instanceof GoStatement) || second.getTextRange().getStartOffset() < first.getTextRange().getEndOffset()) {
            return -1;
        }
        PsiElement semi = GoPsiUtil.findTrailingSemicolon(first);
        boolean insertSemi = semi == null;
        String text = document.getText(TextRange.create((int)start, (int)end));
        if (insertSemi) {
            document.insertString(first.getTextRange().getEndOffset(), (CharSequence)";");
        }
        int result = start + (insertSemi ? 2 : 1);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            document.replaceString(insertSemi ? start + 1 : start, insertSemi ? end + 1 : end, (CharSequence)" ");
            return result;
        }
        if (StringUtil.countNewLines((CharSequence)text) == 1) {
            int o = end;
            while (StringUtil.isEmptyOrSpaces((String)String.valueOf(document.getCharsSequence().charAt(o)))) {
                --o;
            }
            document.replaceString(o + 1, end + 1, (CharSequence)" ");
            return o + 2;
        }
        return result;
    }

    @Nullable
    private static PsiElement findDeclaration(@NotNull Document document, int lineNumber, @Nullable PsiElement e, boolean prev) {
        GoStatement statement;
        PsiElement sibling;
        if (document == null) {
            GoJoinStatementsHandler.$$$reportNull$$$0(2);
        }
        if ((sibling = GoJoinStatementsHandler.prevOrNextVisible(e, prev)) != null) {
            int offset;
            int n = offset = prev ? sibling.getTextRange().getEndOffset() : sibling.getTextRange().getStartOffset();
            if (document.getLineNumber(offset) != lineNumber) {
                return null;
            }
        }
        if ((statement = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)sibling, GoStatement.class)) != null) {
            return statement;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)sibling, (Class[])new Class[]{GoTopLevelDeclaration.class, GoPackageClause.class, GoImportDeclaration.class});
    }

    @Nullable
    private static PsiElement prevOrNextVisible(@Nullable PsiElement e, boolean prev) {
        if (e == null || !GoPsiUtil.isWhiteSpaceOrCommentOrEmpty(e)) {
            return e;
        }
        while (e != null) {
            e = prev ? PsiTreeUtil.prevVisibleLeaf((PsiElement)e) : PsiTreeUtil.nextVisibleLeaf((PsiElement)e);
            if (GoPsiUtil.isWhiteSpaceOrCommentOrEmpty(e)) continue;
            return e;
        }
        return null;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        if (document == null) {
            GoJoinStatementsHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GoJoinStatementsHandler.$$$reportNull$$$0(4);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/codeInsight/editorActions/GoJoinStatementsHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinRawLines";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findDeclaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

