/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImport;
import com.goide.codeInsight.imports.GoManualImportDetector;
import com.goide.codeInsight.imports.GoOptimizedImportsTracker;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoImportsSorter;
import com.goide.util.GoUtil;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GoImportOptimizer
implements ImportOptimizer {
    public static final Task EMPTY_TASK = new Task();
    public static final Task RESET_MANUAL_IMPORTS_TASK = new Task();
    private static final AtomicBoolean ourOptimizerEnabled = new AtomicBoolean(true);

    public boolean supports(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(0);
        }
        return file2 instanceof GoFile;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(1);
        }
        return GoImportOptimizer.processFile(file2, false);
    }

    @NotNull
    public static Task processFileForHighlightingPass(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(2);
        }
        return GoImportOptimizer.processFile(file2, true);
    }

    public static void disableImportOptimization() {
        ourOptimizerEnabled.set(false);
    }

    public static void enableImportOptimization() {
        ourOptimizerEnabled.set(true);
    }

    @NotNull
    private static Task processFile(final @NotNull PsiFile file2, boolean highlightingPass) {
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(3);
        }
        if (!ourOptimizerEnabled.get()) {
            Task task2 = EMPTY_TASK;
            if (task2 == null) {
                GoImportOptimizer.$$$reportNull$$$0(4);
            }
            return task2;
        }
        if (!(file2 instanceof GoFile)) {
            Task task3 = EMPTY_TASK;
            if (task3 == null) {
                GoImportOptimizer.$$$reportNull$$$0(5);
            }
            return task3;
        }
        final GoFile goFile = (GoFile)file2;
        if (highlightingPass && goFile.isGenerated()) {
            Task task4 = EMPTY_TASK;
            if (task4 == null) {
                GoImportOptimizer.$$$reportNull$$$0(6);
            }
            return task4;
        }
        MultiMap<String, GoImportSpec> importMap = goFile.getImportMap();
        Collection<GoImportDeclaration> emptyImportDeclarations = GoImportOptimizer.findEmptyImportDeclarations(goFile);
        final LinkedHashSet<GoImportSpec> importEntriesToDelete = new LinkedHashSet<GoImportSpec>();
        final Set<Object> importIdentifiersToDelete = GoImportOptimizer.shouldRemoveRedundantAliases(file2) ? GoImportOptimizer.findRedundantImportIdentifiers(importMap) : Collections.emptySet();
        GoImportOptimizer.resolveDotImportReferences(goFile);
        importEntriesToDelete.addAll(GoImportOptimizer.findDuplicatedEntries(importMap));
        importEntriesToDelete.addAll(GoImportOptimizer.filterUnusedImports(goFile, importMap).values());
        final GoImportsSorter importsSorter = GoImportsSorter.forFile(goFile);
        if (emptyImportDeclarations.isEmpty() && importEntriesToDelete.isEmpty() && importIdentifiersToDelete.isEmpty() && importsSorter.getUnsortedElements().isEmpty()) {
            return highlightingPass ? RESET_MANUAL_IMPORTS_TASK : new Task(){

                @Override
                public void run() {
                    GoManualImportDetector.resetManualImport((PsiFile)goFile);
                }
            };
        }
        if (highlightingPass && GoManualImportDetector.hasManualImport(file2)) {
            Task task5 = EMPTY_TASK;
            if (task5 == null) {
                GoImportOptimizer.$$$reportNull$$$0(7);
            }
            return task5;
        }
        return new Task(){

            @Override
            @Nullable
            public String getUserNotificationInfo() {
                int entriesToDelete = importEntriesToDelete.size();
                int identifiersToDelete = importIdentifiersToDelete.size();
                String result = "";
                if (entriesToDelete > 0 && identifiersToDelete > 0) {
                    result = GoBundle.message((String)"go.import.optimizer.removed.imports.and.aliases", (Object[])new Object[]{entriesToDelete, identifiersToDelete});
                } else if (entriesToDelete > 0) {
                    result = GoBundle.message((String)"go.import.optimizer.removed.imports", (Object[])new Object[]{entriesToDelete});
                } else if (identifiersToDelete > 0) {
                    result = GoBundle.message((String)"go.import.optimizer.removed.aliases", (Object[])new Object[]{identifiersToDelete});
                }
                return StringUtil.nullize((String)result);
            }

            @Override
            public void run() {
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
                Document document = manager.getDocument(file2);
                if (document != null) {
                    manager.commitDocument(document);
                }
                HashSet<GoImport> optimizedImports = new HashSet<GoImport>();
                HashSet modified = new HashSet();
                for (PsiElement importEntry : importEntriesToDelete) {
                    if (importEntry == null || !importEntry.isValid()) continue;
                    GoImportDeclaration declaration = (GoImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)importEntry, GoImportDeclaration.class);
                    ContainerUtil.addIfNotNull(modified, (Object)declaration);
                    GoImportSpec spec = GoImportOptimizer.getImportSpec(importEntry);
                    GoImportOptimizer.deleteImportSpec(declaration, spec);
                    if (spec == null) continue;
                    optimizedImports.add(new GoImport(spec.getPath(), spec.getAlias()));
                }
                GoOptimizedImportsTracker.addOptimizedImports(file2, optimizedImports);
                for (PsiElement identifier : importIdentifiersToDelete) {
                    if (identifier == null || !identifier.isValid()) continue;
                    ContainerUtil.addIfNotNull(modified, (Object)((GoImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)identifier, GoImportDeclaration.class)));
                    identifier.delete();
                }
                modified.removeAll(GoImportOptimizer.deleteEmptyDeclarations(goFile));
                if (!importsSorter.getUnsortedElements().isEmpty()) {
                    importsSorter.sortImports();
                }
                modified.forEach(it -> CodeEditUtil.markToReformat((ASTNode)it.getNode(), (boolean)true));
                GoManualImportDetector.resetManualImport((PsiFile)goFile);
            }
        };
    }

    private static boolean shouldRemoveRedundantAliases(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(8);
        }
        return ((GoCodeStyleSettings)CodeStyle.getSettings((Project)file2.getProject()).getCustomSettings(GoCodeStyleSettings.class)).REMOVE_REDUNDANT_IMPORT_ALIASES;
    }

    @NotNull
    public static Set<GoImportDeclaration> deleteEmptyDeclarations(@NotNull GoFile goFile) {
        if (goFile == null) {
            GoImportOptimizer.$$$reportNull$$$0(9);
        }
        HashSet<GoImportDeclaration> deleted = new HashSet<GoImportDeclaration>();
        for (GoImportDeclaration declaration : GoImportOptimizer.findEmptyImportDeclarations(goFile)) {
            PsiElement nextSibling = declaration.getNextSibling();
            if (!declaration.isValid()) continue;
            deleted.add(declaration);
            declaration.delete();
            if (nextSibling == null || nextSibling.getNode().getElementType() != GoTypes.SEMICOLON) continue;
            nextSibling.delete();
        }
        HashSet<GoImportDeclaration> hashSet = deleted;
        if (hashSet == null) {
            GoImportOptimizer.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static @Unmodifiable Collection<GoImportDeclaration> findEmptyImportDeclarations(@NotNull GoFile file2) {
        GoImportList list;
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(11);
        }
        if ((list = file2.getImportList()) != null) {
            return ContainerUtil.filter(list.getImportDeclarationList(), declaration -> declaration.getImportSpecList().isEmpty());
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Set<PsiElement> findRedundantImportIdentifiers(@NotNull MultiMap<String, GoImportSpec> importMap) {
        if (importMap == null) {
            GoImportOptimizer.$$$reportNull$$$0(12);
        }
        LinkedHashSet<PsiElement> importIdentifiersToDelete = new LinkedHashSet<PsiElement>();
        for (PsiElement importEntry : importMap.values()) {
            GoImportSpec importSpec = GoImportOptimizer.getImportSpec(importEntry);
            String alias = importSpec != null ? importSpec.getAlias() : null;
            if (alias == null) continue;
            String importPath = importSpec.getPath();
            Set<String> qualifiers = GoPsiImplUtil.getImportQualifiersToUseInFile(importSpec.resolve(ResolveState.initial()), importPath);
            if (qualifiers.size() != 1 || !qualifiers.contains(alias) || !alias.equals(GoImportOptimizer.getAssumedPackageName(importPath))) continue;
            ContainerUtil.addIfNotNull(importIdentifiersToDelete, (Object)importSpec.getIdentifier());
        }
        LinkedHashSet<PsiElement> linkedHashSet = importIdentifiersToDelete;
        if (linkedHashSet == null) {
            GoImportOptimizer.$$$reportNull$$$0(13);
        }
        return linkedHashSet;
    }

    @NotNull
    public static String getAssumedPackageName(@NotNull String importPath) {
        int firstInvalid;
        String path;
        int lastSlash;
        if (importPath == null) {
            GoImportOptimizer.$$$reportNull$$$0(14);
        }
        if ((lastSlash = (path = StringUtil.trimEnd((String)importPath, (char)'/')).lastIndexOf(47)) == -1) {
            String string = path;
            if (string == null) {
                GoImportOptimizer.$$$reportNull$$$0(15);
            }
            return string;
        }
        String lastSegment = path.substring(lastSlash + 1);
        if (GoImportOptimizer.isVersionSuffix(lastSegment)) {
            int prevSlash = path.lastIndexOf(47, lastSlash - 1);
            lastSegment = path.substring(prevSlash + 1, lastSlash);
        }
        String string = (firstInvalid = StringUtil.findFirst((CharSequence)(lastSegment = StringUtil.trimStart((String)lastSegment, (String)"go-")), c -> !GoUtil.isValidGoIdentifierCharacter(c))) != -1 ? lastSegment.substring(0, firstInvalid) : lastSegment;
        if (string == null) {
            GoImportOptimizer.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean isVersionSuffix(@NotNull String str) {
        if (str == null) {
            GoImportOptimizer.$$$reportNull$$$0(17);
        }
        return str.length() >= 2 && str.charAt(0) == 'v' && StringUtil.findFirst((CharSequence)str.substring(1), c -> !Character.isDigit(c)) == -1;
    }

    public static MultiMap<String, GoImportSpec> filterUnusedImports(@NotNull GoFile file2, @NotNull MultiMap<String, GoImportSpec> importMap) {
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(18);
        }
        if (importMap == null) {
            GoImportOptimizer.$$$reportNull$$$0(19);
        }
        final MultiMap result = MultiMap.create();
        if (importMap.isEmpty()) {
            return result;
        }
        result.putAllValues(importMap);
        result.remove((Object)"_");
        for (GoImportSpec spec : GoImportOptimizer.getUsedCImports(importMap.get((Object)"C"))) {
            result.remove((Object)"C", (Object)spec);
        }
        ArrayList implicitImports = new ArrayList(result.get((Object)"."));
        for (GoImportSpec spec : implicitImports) {
            if (spec == null || !spec.isDot() || !GoImportOptimizer.hasImportUsers(spec)) continue;
            result.remove((Object)".", (Object)spec);
        }
        file2.accept(new GoRecursiveVisitor(){

            @Override
            public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression o) {
                if (o == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitTypeReferenceExpression(o);
                this.checkReferenceExpression(o);
            }

            @Override
            public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
                if (o == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(o);
                this.checkReferenceExpression(o);
            }

            private void checkReferenceExpression(@NotNull GoReferenceExpressionBase o) {
                GoReferenceExpressionBase lastQualifier;
                if (o == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((lastQualifier = (GoReferenceExpressionBase)o.getQualifierAs(GoReferenceExpressionBase.class)) != null) {
                    GoReferenceExpressionBase previousQualifier;
                    while ((previousQualifier = (GoReferenceExpressionBase)lastQualifier.getQualifierAs(GoReferenceExpressionBase.class)) != null) {
                        lastQualifier = previousQualifier;
                    }
                    this.markAsUsed(lastQualifier.getIdentifier(), lastQualifier.getReference());
                }
            }

            private void markAsUsed(@NotNull PsiElement qualifier, @Nullable PsiReference reference) {
                PsiElement resolve;
                String qualifierText;
                if (qualifier == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (!result.containsKey((Object)(qualifierText = qualifier.getText()))) {
                    return;
                }
                PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                if (!GoPackageUtil.isGoPackage(resolve) && !(resolve instanceof GoImportSpec)) {
                    return;
                }
                HashSet<String> qualifiersToDelete = new HashSet<String>();
                for (GoImportSpec spec : result.get((Object)qualifierText)) {
                    for (Map.Entry entry : result.entrySet()) {
                        for (GoImportSpec importSpec : (Collection)entry.getValue()) {
                            if (importSpec != spec) continue;
                            qualifiersToDelete.add((String)entry.getKey());
                        }
                    }
                }
                for (String qualifierToDelete : qualifiersToDelete) {
                    result.remove((Object)qualifierToDelete);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualifier";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/codeInsight/imports/GoImportOptimizer$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "markAsUsed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result;
    }

    @NotNull
    private static List<GoImportSpec> getUsedCImports(@NotNull Collection<GoImportSpec> importSpecs) {
        if (importSpecs == null) {
            GoImportOptimizer.$$$reportNull$$$0(20);
        }
        ArrayList<GoImportSpec> result = new ArrayList<GoImportSpec>();
        for (GoImportSpec spec : importSpecs) {
            if (!spec.isCImport() || GoDocumentationProvider.getUpperComments(spec).isEmpty()) continue;
            result.add(spec);
        }
        List<GoImportSpec> list = result.isEmpty() ? ContainerUtil.createMaybeSingletonList((Object)((GoImportSpec)ContainerUtil.getFirstItem(importSpecs))) : result;
        if (list == null) {
            GoImportOptimizer.$$$reportNull$$$0(21);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasImportUsers(@NotNull GoImportSpec spec) {
        if (spec == null) {
            GoImportOptimizer.$$$reportNull$$$0(22);
        }
        GoImportSpec goImportSpec = spec;
        synchronized (goImportSpec) {
            Set list = (Set)spec.getUserData(GoReferenceBase.IMPORT_USERS);
            if (list != null) {
                for (PsiElement e : list) {
                    if (e.isValid()) {
                        return true;
                    }
                    ProgressManager.checkCanceled();
                }
            }
        }
        return false;
    }

    @NotNull
    private static Set<GoImportSpec> findDuplicatedEntries(@NotNull MultiMap<String, GoImportSpec> importMap) {
        if (importMap == null) {
            GoImportOptimizer.$$$reportNull$$$0(23);
        }
        LinkedHashSet<GoImportSpec> duplicatedEntries = new LinkedHashSet<GoImportSpec>();
        for (Map.Entry imports : importMap.entrySet()) {
            Collection importsWithSameName = (Collection)imports.getValue();
            if (importsWithSameName.size() <= 1) continue;
            MultiMap<String, GoImportSpec> importsWithSameString = GoImportOptimizer.collectImportsWithSameString(importsWithSameName);
            for (Map.Entry importWithSameString : importsWithSameString.entrySet()) {
                ArrayList duplicates = new ArrayList((Collection)importWithSameString.getValue());
                if (duplicates.size() <= 1) continue;
                duplicatedEntries.addAll(duplicates.subList(1, duplicates.size()));
            }
        }
        LinkedHashSet<GoImportSpec> linkedHashSet = duplicatedEntries;
        if (linkedHashSet == null) {
            GoImportOptimizer.$$$reportNull$$$0(24);
        }
        return linkedHashSet;
    }

    public static void deleteImportSpec(@Nullable GoImportDeclaration importDeclaration, @Nullable GoImportSpec importSpec) {
        if (importSpec != null && importDeclaration != null) {
            for (PsiComment comment : GoDocumentationProvider.getCommentsForElement(importSpec)) {
                if (!comment.isValid()) continue;
                comment.delete();
            }
            GoImportSpec endElementToDelete = importSpec;
            PsiElement nextSibling = endElementToDelete.getNextSibling();
            if (nextSibling != null && nextSibling.getNode().getElementType() == GoTypes.SEMICOLON) {
                endElementToDelete = nextSibling;
            }
            if ((nextSibling = endElementToDelete.getNextSibling()) instanceof PsiWhiteSpace && nextSibling.textContains('\n')) {
                endElementToDelete = nextSibling;
            }
            importSpec.getParent().deleteChildRange((PsiElement)importSpec, (PsiElement)endElementToDelete);
        }
    }

    @NotNull
    private static MultiMap<String, GoImportSpec> collectImportsWithSameString(@NotNull Collection<GoImportSpec> importsWithSameName) {
        if (importsWithSameName == null) {
            GoImportOptimizer.$$$reportNull$$$0(25);
        }
        MultiMap importsWithSameString = MultiMap.create();
        for (PsiElement psiElement : importsWithSameName) {
            GoImportSpec importSpec = GoImportOptimizer.getImportSpec(psiElement);
            if (importSpec == null || importSpec.isCImport()) continue;
            importsWithSameString.putValue((Object)importSpec.getPath(), (Object)importSpec);
        }
        MultiMap multiMap = importsWithSameString;
        if (multiMap == null) {
            GoImportOptimizer.$$$reportNull$$$0(26);
        }
        return multiMap;
    }

    @Nullable
    private static GoImportSpec getImportSpec(@NotNull PsiElement importEntry) {
        if (importEntry == null) {
            GoImportOptimizer.$$$reportNull$$$0(27);
        }
        return (GoImportSpec)PsiTreeUtil.getNonStrictParentOfType((PsiElement)importEntry, (Class[])new Class[]{GoImportSpec.class});
    }

    public static void resolveDotImportReferences(@NotNull GoFile file2) {
        MultiMap<String, GoImportSpec> importMap;
        ArrayList implicitImports;
        if (file2 == null) {
            GoImportOptimizer.$$$reportNull$$$0(28);
        }
        if ((implicitImports = new ArrayList((importMap = file2.getImportMap()).get((Object)"."))).isEmpty()) {
            return;
        }
        final int[] i = new int[]{0};
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            protected void elementFinished(PsiElement element) {
                if (element instanceof GoReferenceExpressionBase && ((GoReferenceExpressionBase)element).getQualifier() == null) {
                    i[0] = i[0] + 1;
                    for (PsiReference reference : element.getReferences()) {
                        reference.resolve();
                    }
                    if (this.stop()) {
                        this.stopWalking();
                    }
                }
            }

            private boolean stop() {
                if (i[0] % 20 == 1) {
                    implicitImports.removeIf(spec -> spec != null && spec.isDot() && GoImportOptimizer.hasImportUsers(spec));
                }
                return implicitImports.isEmpty();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 13, 15, 16, 21, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/codeInsight/imports/GoImportOptimizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goFile";
                break;
            }
            case 12: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpecs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsWithSameName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/codeInsight/imports/GoImportOptimizer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteEmptyDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findRedundantImportIdentifiers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssumedPackageName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedCImports";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicatedEntries";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImportsWithSameString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFileForHighlightingPass";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 24: 
            case 26: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveRedundantAliases";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteEmptyDeclarations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEmptyImportDeclarations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRedundantImportIdentifiers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAssumedPackageName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isVersionSuffix";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterUnusedImports";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUsedCImports";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasImportUsers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicatedEntries";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectImportsWithSameString";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImportSpec";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveDotImportReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 13, 15, 16, 21, 24, 26 -> new IllegalStateException(string);
        };
    }

    public static class Task
    implements ImportOptimizer.CollectingInfoRunnable {
        @Nullable
        public String getUserNotificationInfo() {
            return null;
        }

        public void run() {
        }
    }
}

