/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoManualImportDetector
implements DocumentListener,
FileEditorManagerListener {
    private static final Logger LOG = Logger.getInstance(GoManualImportDetector.class);
    private static final int OPTIMIZE_IMPORTS_TIMEOUT_SECONDS = 10;
    private static final Key<Boolean> GO_HAS_MANUAL_IMPORT = Key.create((String)"GO_HAS_MANUAL_IMPORT");
    @NotNull
    private static final ExecutorService myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"GoManualImportDetector sequential pool");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^import([ (])");

    private static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            GoManualImportDetector.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || project.isDisposed()) {
            return false;
        }
        return Registry.is((String)"go.manual.import.detector.enabled") && GoImportsSettings.getInstance(project).isOptimizeImportsOnTheFly();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void optimizeUnusedManualImports(@NotNull Project project) {
        if (project == null) {
            GoManualImportDetector.$$$reportNull$$$0(1);
        }
        if (GoManualImportDetector.isEnabled(project)) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            Object[] openFiles = FileEditorManager.getInstance((Project)project).getOpenFiles();
            @NotNull List filesWithManualImports = ContainerUtil.mapNotNull((Object[])openFiles, virtualFile -> {
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                GoFile file2 = document != null ? (GoFile)((Object)((Object)ObjectUtils.tryCast((Object)psiDocumentManager.getPsiFile(document), GoFile.class))) : null;
                return file2 != null && GoManualImportDetector.hasManualImport((PsiFile)file2) ? file2 : null;
            });
            CountDownLatch processed = new CountDownLatch(filesWithManualImports.size());
            for (GoFile file2 : filesWithManualImports) {
                GoManualImportDetector.resetManualImport((PsiFile)file2);
                WriteCommandAction.runWriteCommandAction((Project)project, (String)OptimizeImportsProcessor.getCommandName(), null, () -> {
                    try {
                        new GoImportOptimizer().processFile((PsiFile)file2).run();
                    }
                    finally {
                        processed.countDown();
                    }
                }, (PsiFile[])new PsiFile[]{file2});
            }
            try {
                processed.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Imports optimization takes longer than 10 seconds, number of files: " + filesWithManualImports.size());
            }
        }
    }

    public static boolean hasManualImport(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoManualImportDetector.$$$reportNull$$$0(2);
        }
        return GoManualImportDetector.isEnabled(file2.getProject()) && Boolean.TRUE.equals(file2.getUserData(GO_HAS_MANUAL_IMPORT));
    }

    public static void resetManualImport(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoManualImportDetector.$$$reportNull$$$0(3);
        }
        file2.putUserData(GO_HAS_MANUAL_IMPORT, null);
    }

    private static void setHasManualImport(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoManualImportDetector.$$$reportNull$$$0(4);
        }
        file2.putUserData(GO_HAS_MANUAL_IMPORT, (Object)true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        CommandType commandType;
        if (event == null) {
            GoManualImportDetector.$$$reportNull$$$0(5);
        }
        if ((commandType = CommandType.of(CommandProcessor.getInstance().getCurrentCommandName())) == null) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || file2 instanceof LightVirtualFile) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
            if (project == null || !GoManualImportDetector.isEnabled(project)) {
                return null;
            }
            return GoManualImportDetector.documentChanged(event, project, commandType);
        }).coalesceBy(new Object[]{this, document}).expireWhen(() -> !file2.isValid()).submit((Executor)myExecutor).onSuccess(goFile -> {
            if (goFile != null) {
                GoManualImportDetector.setHasManualImport((PsiFile)goFile);
            }
        });
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    private static GoFile documentChanged(@NotNull DocumentEvent event, @NotNull Project project, @NotNull CommandType commandType) {
        boolean isPaste;
        if (event == null) {
            GoManualImportDetector.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GoManualImportDetector.$$$reportNull$$$0(7);
        }
        if (commandType == null) {
            GoManualImportDetector.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertBackgroundThread();
        GoFile file2 = (GoFile)((Object)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)project).getPsiFile(event.getDocument()), GoFile.class));
        if (file2 == null) {
            return null;
        }
        if (commandType == CommandType.UNDO_OPTIMIZE_IMPORT) {
            return file2;
        }
        boolean isTyping = commandType == CommandType.TYPING;
        boolean bl = isPaste = commandType == CommandType.PASTE;
        if (isTyping || isPaste) {
            List<GoImportDeclaration> imports;
            GoImportList importList = file2.getImportList();
            List<GoImportDeclaration> list = imports = importList != null ? importList.getImportDeclarationList() : null;
            if (imports == null) {
                return null;
            }
            int eventOffset = event.getOffset();
            if (!ContainerUtil.process(imports, it -> !it.getTextRange().contains(eventOffset))) {
                return file2;
            }
            if (isPaste) {
                CharSequence fragment;
                int importAreaUpperBound;
                PsiElement firstNonImport = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)importList);
                int n = importAreaUpperBound = firstNonImport != null ? firstNonImport.getTextRange().getStartOffset() : file2.getTextLength();
                if (eventOffset < importAreaUpperBound && IMPORT_PATTERN.matcher(fragment = event.getNewFragment()).find()) {
                    return file2;
                }
            }
        }
        return null;
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            GoManualImportDetector.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            GoManualImportDetector.$$$reportNull$$$0(10);
        }
        ReadAction.nonBlocking(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            return document != null ? PsiDocumentManager.getInstance((Project)source.getProject()).getPsiFile(document) : null;
        }).coalesceBy(new Object[]{this, file2}).expireWhen(() -> source.getProject().isDisposed() || !file2.isValid()).submit((Executor)myExecutor).onSuccess(psiFile -> {
            if (psiFile != null) {
                GoManualImportDetector.resetManualImport(psiFile);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/goide/codeInsight/imports/GoManualImportDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "optimizeUnusedManualImports";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasManualImport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetManualImport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setHasManualImport";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum CommandType {
        TYPING,
        PASTE,
        UNDO_OPTIMIZE_IMPORT;


        @Nullable
        static CommandType of(@Nullable String commandName) {
            if (EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]).equals(commandName)) {
                return TYPING;
            }
            if (EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]).equals(commandName)) {
                return PASTE;
            }
            if (ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{OptimizeImportsProcessor.getCommandName()}).equals(commandName)) {
                return UNDO_OPTIMIZE_IMPORT;
            }
            return null;
        }
    }
}

