/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.comments.GoCommentLexer;
import com.goide.comments.GoCommentToken;
import com.goide.comments.GoCommentTokenType;
import com.goide.comments.GoDocLinkToken;
import com.goide.comments.GoLinkDefinition;
import com.goide.comments.GoTextLinkToken;
import com.goide.comments.GoWordChainCommentToken;
import com.goide.util.GoUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCommentParser {
    private static final IntArraySet PUNCTUATION_TYPES = new IntArraySet(new int[]{21, 22, 24, 23, 20, 29, 30});
    static final Set<String> URL_PREFIXES = Set.of("mailto", "http", "https", "ftp", "ftps", "news", "www");
    private final String myText;
    private final GoCommentLexer myLexer;
    private final Map<String, GoLinkDefinition> myLinkDefs;

    public GoCommentParser(@NotNull String text, @NotNull Map<String, GoLinkDefinition> linkDefs) {
        if (text == null) {
            GoCommentParser.$$$reportNull$$$0(0);
        }
        if (linkDefs == null) {
            GoCommentParser.$$$reportNull$$$0(1);
        }
        this.myText = text;
        this.myLexer = new GoCommentLexer(this.myText);
        this.myLinkDefs = linkDefs;
    }

    public boolean isStrongWordBoundary(@Nullable GoCommentToken token) {
        if (token == null) {
            return true;
        }
        if (token.getType() == GoCommentTokenType.SPACE) {
            return true;
        }
        if (token.getType() == GoCommentTokenType.PUNCTUATION) {
            CharSequence prevTokenText = token.getRange().subSequence((CharSequence)this.myText);
            return StringUtil.equals((CharSequence)prevTokenText, (CharSequence)"(") || StringUtil.equals((CharSequence)prevTokenText, (CharSequence)"*") || StringUtil.equals((CharSequence)prevTokenText, (CharSequence)"&");
        }
        return false;
    }

    public boolean isLeftBracket(@Nullable GoCommentToken token) {
        return token != null && token.getType() == GoCommentTokenType.PUNCTUATION && StringUtil.equals((CharSequence)token.getRange().subSequence((CharSequence)this.myText), (CharSequence)"[");
    }

    @Nullable
    public GoCommentToken getNext() {
        GoCommentToken link;
        GoCommentToken token = this.myLexer.getNext();
        if (token == null) {
            return null;
        }
        if (token.getType() == GoCommentTokenType.SPACE) {
            return token;
        }
        int tokenStart = token.getRange().getStartOffset();
        String tokenText = token.getRange().substring(this.myText);
        if (token.getType() == GoCommentTokenType.WORD) {
            String url = this.getUrl(tokenText, tokenStart);
            if (url != null) {
                this.myLexer.setOffset(tokenStart + url.length());
                return new GoCommentToken(GoCommentTokenType.URL, TextRange.from((int)tokenStart, (int)url.length()));
            }
            List<TextRange> wordRanges = this.consumeWordChain(token);
            if (wordRanges.size() > 1) {
                int chainEndOffset = ((TextRange)ContainerUtil.getLastItem(wordRanges)).shiftRight(token.getRange().getStartOffset()).getEndOffset();
                return new GoWordChainCommentToken(new TextRange(tokenStart, chainEndOffset), wordRanges);
            }
            return token;
        }
        assert (token.getType() == GoCommentTokenType.PUNCTUATION);
        if ("[".equals(tokenText) && (link = this.tryParseLink(tokenStart)) != null) {
            this.myLexer.setOffset(link.getRange().getEndOffset());
            return link;
        }
        if ("`".equals(tokenText) || "'".equals(tokenText)) {
            int offset = this.myLexer.getOffset();
            GoCommentToken next = this.myLexer.getNext();
            if (next != null && next.getType() == GoCommentTokenType.PUNCTUATION && tokenText.equals(next.getRange().substring(this.myText))) {
                return new GoCommentToken(GoCommentTokenType.PUNCTUATION, new TextRange(tokenStart, this.myLexer.getOffset()));
            }
            this.myLexer.setOffset(offset);
            return token;
        }
        return token;
    }

    @Nullable
    private GoCommentToken tryParseLink(int lbrack) {
        char afterBracket;
        char beforeBracket;
        char c = beforeBracket = lbrack == 0 ? (char)' ' : this.myText.charAt(lbrack - 1);
        if (!Character.isWhitespace(beforeBracket) && !GoCommentParser.isPunctuation(beforeBracket)) {
            return null;
        }
        int rbrack = this.myText.indexOf(93, lbrack + 1);
        if (rbrack == -1) {
            return null;
        }
        char c2 = afterBracket = rbrack == this.myText.length() - 1 ? (char)' ' : this.myText.charAt(rbrack + 1);
        if (!Character.isWhitespace(afterBracket) && !GoCommentParser.isPunctuation(afterBracket)) {
            return null;
        }
        int docLinkStart = lbrack + 1;
        String linkText = this.myText.substring(docLinkStart, rbrack);
        GoLinkDefinition linkDef = this.myLinkDefs.get(linkText);
        if (linkDef != null) {
            return new GoTextLinkToken(TextRange.create((int)lbrack, (int)(rbrack + 1)), linkDef);
        }
        if (this.myText.charAt(docLinkStart) == '*') {
            linkText = this.myText.substring(++docLinkStart, rbrack);
        }
        String pkg = null;
        String recv = null;
        String symbolName = null;
        Pair<String, String> pkgAndSymbol = GoCommentParser.splitDocName(linkText);
        if (pkgAndSymbol != null) {
            pkg = (String)pkgAndSymbol.first;
            symbolName = (String)pkgAndSymbol.second;
            Pair<String, String> pkgAndRecv = GoCommentParser.splitDocName(pkg);
            if (pkgAndRecv != null) {
                pkg = (String)pkgAndRecv.first;
                recv = (String)pkgAndRecv.second;
            }
        }
        if (pkg == null && symbolName == null) {
            return null;
        }
        if (!GoCommentParser.isValidImportPath(pkg)) {
            return null;
        }
        TextRange nameRange = symbolName != null ? TextRange.from((int)(rbrack - symbolName.length() - lbrack), (int)symbolName.length()) : null;
        TextRange recvRange = recv != null && symbolName != null ? TextRange.from((int)(rbrack - symbolName.length() - 1 - recv.length() - lbrack), (int)recv.length()) : null;
        TextRange pkgRange = pkg != null ? TextRange.from((int)(docLinkStart - lbrack), (int)pkg.length()) : null;
        TextRange docLinkRange = TextRange.create((int)lbrack, (int)(rbrack + 1));
        String docLinkText = docLinkRange.substring(this.myText);
        return new GoDocLinkToken(docLinkRange, docLinkText, pkgRange, recvRange, nameRange);
    }

    @Nullable
    private String getUrl(@NotNull String tokenText, int tokenStart) {
        Matcher matcher;
        if (tokenText == null) {
            GoCommentParser.$$$reportNull$$$0(2);
        }
        if (URL_PREFIXES.contains(tokenText) && (matcher = URLUtil.URL_PATTERN.matcher(this.myText.substring(tokenStart))).lookingAt()) {
            return matcher.group();
        }
        return null;
    }

    @NotNull
    private List<TextRange> consumeWordChain(@NotNull GoCommentToken firstWord) {
        int lastWordEnd;
        GoCommentToken dot;
        if (firstWord == null) {
            GoCommentParser.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> wordRanges = new ArrayList<TextRange>();
        int chainStartOffset = firstWord.getRange().getStartOffset();
        GoCommentToken word = firstWord;
        do {
            wordRanges.add(word.getRange().shiftLeft(chainStartOffset));
            lastWordEnd = this.myLexer.getOffset();
        } while (this.isDotWord(dot = this.myLexer.getNext(), word = this.myLexer.getNext()));
        this.myLexer.setOffset(lastWordEnd);
        ArrayList<TextRange> arrayList = wordRanges;
        if (arrayList == null) {
            GoCommentParser.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Contract(value="null,_->false; _,null->false")
    private boolean isDotWord(@Nullable GoCommentToken token1, @Nullable GoCommentToken token2) {
        return token1 != null && token1.getType() == GoCommentTokenType.PUNCTUATION && ".".equals(token1.getRange().substring(this.myText)) && token2 != null && token2.getType() == GoCommentTokenType.WORD;
    }

    private static boolean isPunctuation(char c) {
        int unicodeType = Character.getType(c);
        return PUNCTUATION_TYPES.contains(unicodeType);
    }

    @Nullable
    private static Pair<String, String> splitDocName(@Nullable String text) {
        if (text == null) {
            return null;
        }
        int dot = text.lastIndexOf(46);
        String name = text.substring(dot + 1);
        if (!GoUtil.isValidGoIdentifier(name) || !name.isEmpty() && !Character.isUpperCase(name.charAt(0))) {
            return Pair.create((Object)text, null);
        }
        String before = dot > 0 ? text.substring(0, dot) : "";
        return Pair.create((Object)StringUtil.nullize((String)before), (Object)name);
    }

    private static boolean isValidImportPath(@Nullable String importPath) {
        if (importPath == null) {
            return true;
        }
        if (StringUtil.isEmpty((String)importPath)) {
            return false;
        }
        if (importPath.endsWith("/")) {
            return false;
        }
        if (importPath.contains("//")) {
            return false;
        }
        int pathElementStart = 0;
        for (int i = 0; i < importPath.length(); ++i) {
            char c = importPath.charAt(i);
            if (c != '/') continue;
            if (!GoCommentParser.isValidImportPathElem(importPath.substring(pathElementStart, i))) {
                return false;
            }
            pathElementStart = i + 1;
        }
        return GoCommentParser.isValidImportPathElem(importPath.substring(pathElementStart));
    }

    private static boolean isValidImportPathElem(@NotNull String importPathElem) {
        if (importPathElem == null) {
            GoCommentParser.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)importPathElem) || importPathElem.startsWith(".") || importPathElem.endsWith(".")) {
            return false;
        }
        for (int i = 0; i < importPathElem.length(); ++i) {
            char c = importPathElem.charAt(i);
            if (GoCommentParser.importPathOK(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean importPathOK(char c) {
        switch (c) {
            case '+': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkDefs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstWord";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoCommentParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathElem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoCommentParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "consumeWordChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUrl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consumeWordChain";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidImportPathElem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

