/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.comments.GoCommentReferenceResolveContext;
import com.goide.comments.GoDocLinkToken;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.GoMethodDeclarationStub;
import com.goide.stubs.index.GoAllPrivateNamesIndex;
import com.goide.stubs.index.GoAllPublicNamesIndex;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCommentReferenceResolver {
    private final GoPackage myPackage;
    private final GoFile myFile;
    private final GlobalSearchScope myPackageScope;
    private final ConcurrentMap<String, Ref<PsiElement>> myFieldOrMethodResolveCache;
    private final ConcurrentMap<String, Ref<PsiElement>> myUniqueNameCache;
    private final ConcurrentMap<String, Ref<PsiNamedElement>> myTypesResolveCache;
    private final ConcurrentMap<String, Ref<PsiElement>> myQualifiedResolveCache;
    private final ConcurrentMap<String, Ref<GoPackage>> myPackageCache;

    private GoCommentReferenceResolver(@NotNull GoPackage goPackage, @NotNull GoFile file2) {
        if (goPackage == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(1);
        }
        this.myFieldOrMethodResolveCache = new ConcurrentHashMap<String, Ref<PsiElement>>();
        this.myUniqueNameCache = new ConcurrentHashMap<String, Ref<PsiElement>>();
        this.myTypesResolveCache = new ConcurrentHashMap<String, Ref<PsiNamedElement>>();
        this.myQualifiedResolveCache = new ConcurrentHashMap<String, Ref<PsiElement>>();
        this.myPackageCache = new ConcurrentHashMap<String, Ref<GoPackage>>();
        this.myPackage = goPackage;
        this.myFile = file2;
        this.myPackageScope = this.myPackage.getScope((PsiFile)this.myFile);
    }

    @Nullable
    public static GoCommentReferenceResolver getResolver(@Nullable PsiElement element) {
        GoFile file2 = element != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class)) : null;
        return file2 != null ? GoCommentReferenceResolver.getResolverForFile(file2) : null;
    }

    @Nullable
    public static GoCommentReferenceResolver getResolverForFile(@NotNull GoFile file2) {
        if (file2 == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(2);
        }
        return (GoCommentReferenceResolver)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            GoPackage pkg = GoPackage.of(file2);
            GoCommentReferenceResolver resolver = pkg != null ? new GoCommentReferenceResolver(pkg, file2) : null;
            return GoCacheUtilKt.createResolveDependentResult(file2.getProject(), resolver, new Object[0]);
        });
    }

    @NotNull
    public static GoCommentReferenceResolveContext createResolveContext(@Nullable PsiElement commentedElement) {
        boolean resolvePrivateElements = GoCommentReferenceResolver.isResolvePrivateElements(commentedElement);
        String typeName = GoCommentReferenceResolver.getTypeName(commentedElement);
        boolean preferTypeMembers = commentedElement instanceof GoFieldDeclaration || GoPsiImplUtil.isFieldDefinition(commentedElement);
        return new GoCommentReferenceResolveContext(commentedElement != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)commentedElement.getContainingFile(), GoFile.class)) : null, resolvePrivateElements, typeName, preferTypeMembers);
    }

    @Nullable
    public PsiElement resolveWord(@Nullable PsiElement commentedElement, @NotNull String word) {
        if (word == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(3);
        }
        return this.resolveWord(GoCommentReferenceResolver.createResolveContext(commentedElement), word);
    }

    @Nullable
    public PsiElement resolveWord(@NotNull GoCommentReferenceResolveContext context, @NotNull String word) {
        PsiElement result;
        if (context == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(4);
        }
        if (word == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(5);
        }
        if (DumbService.isDumb((Project)this.myPackage.getProject())) {
            return null;
        }
        if (GoCommentReferenceResolver.startsWithLowerCase(word) && !context.isResolvePrivateElements()) {
            return null;
        }
        result = context.isPreferTypeMembers() ? ((result = this.findFieldOrMethodForTargetType(context.getTypeName(), word)) == null ? this.findUniquePackageElement(word) : result) : ((result = this.findUniquePackageElement(word)) == null ? this.findFieldOrMethodForTargetType(context.getTypeName(), word) : result);
        return result;
    }

    @NotNull
    public List<PsiElement> resolveWordChain(@NotNull GoCommentReferenceResolveContext context, @NotNull String text, @NotNull TextRange wordChainRange, @NotNull List<TextRange> wordRanges) {
        if (context == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(6);
        }
        if (text == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(7);
        }
        if (wordChainRange == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(8);
        }
        if (wordRanges == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(9);
        }
        ArrayList<String> words = new ArrayList<String>(wordRanges.size());
        for (TextRange range : wordRanges) {
            words.add(range.shiftRight(wordChainRange.getStartOffset()).substring(text));
        }
        List<PsiElement> list = this.resolveWordChain(context, words);
        if (list == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> resolveWordChain(@Nullable PsiElement commentedElement, @NotNull List<String> wordChainParts) {
        if (wordChainParts == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(11);
        }
        List<PsiElement> list = this.resolveWordChain(GoCommentReferenceResolver.createResolveContext(commentedElement), wordChainParts);
        if (list == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> resolveWordChain(@NotNull GoCommentReferenceResolveContext context, @NotNull List<String> wordChainParts) {
        if (context == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(13);
        }
        if (wordChainParts == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(14);
        }
        if (wordChainParts.size() != 2) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoCommentReferenceResolver.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (DumbService.isDumb((Project)this.myPackage.getProject())) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoCommentReferenceResolver.$$$reportNull$$$0(16);
            }
            return list;
        }
        String word0 = wordChainParts.get(0);
        String word1 = wordChainParts.get(1);
        List<PsiElement> result = null;
        if (GoCommentReferenceResolver.startsWithUpperCase(word0) && GoCommentReferenceResolver.startsWithUpperCase(word1) || context.isResolvePrivateElements()) {
            result = this.findTypeFieldOrMethodInPackage(word0, word1);
        }
        if (result == null && GoCommentReferenceResolver.startsWithLowerCase(word0) && (GoCommentReferenceResolver.startsWithUpperCase(word1) || context.isResolvePrivateElements())) {
            result = this.findQualifiedElement(word0, word1);
        }
        List<Object> list = result != null ? result : Collections.emptyList();
        if (list == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public List<Pair<TextRange, PsiElement>> resolveDocLink(@NotNull GoCommentReferenceResolveContext context, @NotNull GoDocLinkToken docLink) {
        if (context == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(18);
        }
        if (docLink == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(19);
        }
        if (DumbService.isDumb((Project)this.myFile.getProject())) {
            List<Pair<TextRange, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                GoCommentReferenceResolver.$$$reportNull$$$0(20);
            }
            return list;
        }
        String pkg = docLink.getPkg();
        String recv = docLink.getRecv();
        String name = docLink.getName();
        ArrayList<Pair<TextRange, PsiElement>> result = new ArrayList<Pair<TextRange, PsiElement>>();
        GoFile containingFile = context.getContainingFile();
        if (pkg != null) {
            GoPackage goPkg = this.findPackage(pkg, containingFile);
            if (goPkg == null) {
                List<Pair<TextRange, PsiElement>> list = Collections.emptyList();
                if (list == null) {
                    GoCommentReferenceResolver.$$$reportNull$$$0(21);
                }
                return list;
            }
            String pkgName = goPkg.getName();
            if (recv != null) {
                PsiNamedElement recvResolve = this.findUniqueElement(pkgName, recv, goPkg.getScope(), it -> true);
                if (recvResolve instanceof GoTypeSpec) {
                    GoNamedElement nameElem = GoPsiImplUtil.findFieldOrMethod((GoTypeSpec)recvResolve, it -> true);
                    PsiDirectory directory = GoCommentReferenceResolver.getDirectory((PsiElement)recvResolve);
                    if (nameElem != null && directory != null) {
                        result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getPkgRange(), (Object)directory));
                        result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getRecvRange(), (Object)recvResolve));
                        result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getNameRange(), (Object)nameElem));
                    }
                }
            } else if (name != null) {
                PsiDirectory directory;
                PsiNamedElement element = this.findUniqueElement(pkgName, name, goPkg.getScope(), it -> true);
                PsiDirectory psiDirectory = directory = element != null ? GoCommentReferenceResolver.getDirectory((PsiElement)element) : null;
                if (element != null && directory != null) {
                    result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getPkgRange(), (Object)directory));
                    result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getNameRange(), (Object)element));
                }
            } else {
                PsiDirectory pkgDir = (PsiDirectory)ContainerUtil.getFirstItem((List)goPkg.getPsiDirectories().toList());
                if (pkgDir != null) {
                    result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getPkgRange(), (Object)pkgDir));
                }
            }
        } else if (recv != null) {
            List<PsiElement> targets;
            List<PsiElement> list = targets = name != null ? this.findTypeFieldOrMethodInPackage(recv, name) : null;
            if (targets != null && targets.size() == 2) {
                result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getRecvRange(), (Object)targets.get(0)));
                result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getNameRange(), (Object)targets.get(1)));
            }
        } else {
            PsiElement element;
            PsiElement psiElement = element = name != null ? this.findUniquePackageElement(name) : null;
            if (element != null) {
                result.add((Pair<TextRange, PsiElement>)Pair.create((Object)docLink.getNameRange(), (Object)element));
            }
        }
        ArrayList<Pair<TextRange, PsiElement>> arrayList = result;
        if (arrayList == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Nullable
    private GoPackage findPackage(@NotNull String pkg, @Nullable GoFile commentFile) {
        if (pkg == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(23);
        }
        if (commentFile == null) {
            return null;
        }
        Ref ref = (Ref)this.myPackageCache.get(pkg);
        if (ref != null) {
            return (GoPackage)ref.get();
        }
        GoPackage goPkg = GoCommentReferenceResolver.findUniquePackage(pkg, commentFile);
        this.myPackageCache.put(pkg, (Ref<GoPackage>)Ref.create((Object)goPkg));
        return goPkg;
    }

    @Nullable
    private static GoPackage findUniquePackage(@NotNull String pkg, @NotNull GoFile commentFile) {
        if (pkg == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(24);
        }
        if (commentFile == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(25);
        }
        Project project = commentFile.getProject();
        if (pkg.contains("/")) {
            return (GoPackage)ContainerUtil.getOnlyItem(GoPackageUtil.findByImportPath(pkg, project, null, ResolveState.initial()));
        }
        GoImportSpec spec = (GoImportSpec)ContainerUtil.getOnlyItem((Collection)commentFile.getImportMap().get((Object)pkg));
        if (spec != null) {
            return (GoPackage)ContainerUtil.getOnlyItem(spec.resolve(ResolveState.initial()));
        }
        if (pkg.equals(commentFile.getPackageName())) {
            return GoPackage.of(commentFile);
        }
        return (GoPackage)ContainerUtil.getOnlyItem(GoPackageUtil.findByImportPath(pkg, project, null, ResolveState.initial()));
    }

    @Nullable
    private List<PsiElement> findTypeFieldOrMethodInPackage(@NotNull String typeName, @NotNull String methodName) {
        PsiNamedElement type;
        if (typeName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(26);
        }
        if (methodName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(27);
        }
        PsiElement fieldOrMethod = (type = this.findTypeInPackage(typeName)) != null ? this.findFieldOrMethodForTargetType(type.getName(), methodName) : null;
        return fieldOrMethod != null ? Arrays.asList(type, fieldOrMethod) : null;
    }

    @Nullable
    private PsiNamedElement findTypeInPackage(@NotNull String typeName) {
        Ref cached;
        if (typeName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(28);
        }
        if ((cached = (Ref)this.myTypesResolveCache.get(typeName)) != null) {
            return (PsiNamedElement)cached.get();
        }
        PsiNamedElement type = this.findUniqueElement(this.myPackage.getName(), typeName, this.myPackageScope, it -> it instanceof GoTypeSpec);
        this.myTypesResolveCache.put(typeName, (Ref<PsiNamedElement>)Ref.create((Object)type));
        return type;
    }

    @Nullable
    private List<PsiElement> findQualifiedElement(@NotNull String packageName, @NotNull String elementName) {
        PsiElement element;
        if (packageName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(29);
        }
        if (elementName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(30);
        }
        if (this.myPackage.getName().equals(packageName)) {
            element = this.findUniquePackageElement(elementName);
        } else {
            String qualifiedName = packageName + "." + elementName;
            Ref cached = (Ref)this.myQualifiedResolveCache.get(qualifiedName);
            if (cached != null) {
                element = (PsiElement)cached.get();
            } else {
                GlobalSearchScope scope = new GoUtil.ExceptTestsScope(GoUtil.goPathResolveScope((PsiElement)this.myFile)).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myPackageScope));
                element = this.findUniqueElement(packageName, elementName, scope, it -> !GoCommentReferenceResolver.isFieldOrMethod((PsiElement)it));
                this.myQualifiedResolveCache.put(qualifiedName, (Ref<PsiElement>)Ref.create((Object)element));
            }
        }
        return element != null ? Arrays.asList(GoCommentReferenceResolver.getDirectory(element), element) : null;
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(31);
        }
        return (file2 = element.getContainingFile()) != null ? file2.getOriginalFile().getContainingDirectory() : null;
    }

    @Nullable
    private PsiElement findUniquePackageElement(@NotNull String name) {
        Ref cached;
        if (name == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(32);
        }
        if ((cached = (Ref)this.myUniqueNameCache.get(name)) != null) {
            return (PsiElement)cached.get();
        }
        PsiNamedElement result = this.findUniqueElement(this.myPackage.getName(), name, this.myPackageScope, it -> !GoCommentReferenceResolver.isFieldOrMethod((PsiElement)it));
        this.myUniqueNameCache.put(name, (Ref<PsiElement>)Ref.create((Object)result));
        return result;
    }

    @Nullable
    private PsiElement findFieldOrMethodForTargetType(@Nullable String targetTypeName, @NotNull String fieldOrMethodName) {
        if (fieldOrMethodName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(33);
        }
        if (targetTypeName == null) {
            return null;
        }
        String key = targetTypeName + "." + fieldOrMethodName;
        Ref cached = (Ref)this.myFieldOrMethodResolveCache.get(key);
        if (cached != null) {
            return (PsiElement)cached.get();
        }
        List<PsiElement> elements2 = this.findQualifiedElement(this.myPackage.getName(), targetTypeName);
        List typeSpecs = elements2 != null ? ContainerUtil.filter(elements2, it -> it instanceof GoTypeSpec) : null;
        GoTypeSpec uniqueTypeSpec = typeSpecs != null ? (GoTypeSpec)ContainerUtil.getOnlyItem((Collection)typeSpecs) : null;
        GoNamedElement result = GoPsiImplUtil.findFieldOrMethod(uniqueTypeSpec, it -> fieldOrMethodName.equals(it.getName()));
        this.myFieldOrMethodResolveCache.put(key, (Ref<PsiElement>)Ref.create((Object)result));
        return result;
    }

    @Nullable
    public static String getTypeText(@NotNull PsiElement element) {
        if (element == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(34);
        }
        if (element instanceof GoMethodSpec || element instanceof GoFieldDeclaration || element instanceof GoFieldDefinition) {
            GoTypeSpec type = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
            return type != null ? type.getName() : null;
        }
        GoMethodDeclaration method = (GoMethodDeclaration)ObjectUtils.tryCast((Object)element, GoMethodDeclaration.class);
        if (method == null) {
            return null;
        }
        GoMethodDeclarationStub stub = (GoMethodDeclarationStub)method.getStub();
        if (stub != null) {
            return stub.getTypeName();
        }
        GoTypeReferenceExpression reference = GoPsiImplUtil.findTypeReference(method.getReceiverType());
        return reference != null ? reference.getIdentifier().getText() : null;
    }

    private static boolean startsWithUpperCase(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    private static boolean startsWithLowerCase(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isLowerCase(s.charAt(0));
    }

    @Nullable
    private PsiNamedElement findUniqueElement(@NotNull String pkgName, @NotNull String symbolName, @NotNull GlobalSearchScope scope, @NotNull Predicate<PsiNamedElement> predicate) {
        if (pkgName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(35);
        }
        if (symbolName == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(36);
        }
        if (scope == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(37);
        }
        if (predicate == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(38);
        }
        GoNamedElement result = null;
        StubIndexKey<String, GoNamedElement> index = GoCommentReferenceResolver.startsWithUpperCase(symbolName) ? GoAllPublicNamesIndex.ALL_PUBLIC_NAMES : GoAllPrivateNamesIndex.ALL_PRIVATE_NAMES;
        Collection elements2 = StubIndex.getElements(index, (Object)(pkgName + "." + symbolName), (Project)this.myPackage.getProject(), (GlobalSearchScope)scope, GoNamedElement.class);
        for (GoNamedElement element : elements2) {
            if (!predicate.test((PsiNamedElement)element)) continue;
            if (result == null) {
                result = element;
                continue;
            }
            return null;
        }
        return result;
    }

    private static boolean isFieldOrMethod(@Nullable PsiElement element) {
        return element instanceof GoMethodDeclaration || element instanceof GoMethodSpec || GoPsiImplUtil.isFieldDefinition(element);
    }

    @Nullable
    private static String getTypeName(@Nullable PsiElement element) {
        if (element instanceof GoTypeDeclaration) {
            GoTypeSpec typeSpec = (GoTypeSpec)ContainerUtil.getOnlyItem(((GoTypeDeclaration)element).getTypeSpecList());
            return typeSpec != null ? typeSpec.getName() : null;
        }
        if (element instanceof GoTypeSpec) {
            return ((GoTypeSpec)element).getName();
        }
        return element != null ? GoCommentReferenceResolver.getTypeText(element) : null;
    }

    private static boolean isResolvePrivateElements(@Nullable PsiElement commentedElement) {
        if (commentedElement instanceof GoTypeDeclaration) {
            return !GoCommentReferenceResolver.hasPublicTypeSpecs((GoTypeDeclaration)commentedElement);
        }
        if (commentedElement instanceof GoVarOrConstDeclaration) {
            return !GoCommentReferenceResolver.hasPublicDefinitions((GoVarOrConstDeclaration)commentedElement);
        }
        if (commentedElement instanceof GoVarOrConstSpec) {
            return !GoCommentReferenceResolver.hasPublicDefinitions((GoVarOrConstSpec)commentedElement);
        }
        if (commentedElement instanceof GoFieldDeclaration) {
            return !GoCommentReferenceResolver.hasPublicDefinitions((GoFieldDeclaration)commentedElement);
        }
        GoNamedElement namedElement = (GoNamedElement)ObjectUtils.tryCast((Object)commentedElement, GoNamedElement.class);
        return namedElement != null && !namedElement.isPublic();
    }

    private static boolean hasPublicDefinitions(@NotNull GoVarOrConstDeclaration<?> declaration) {
        if (declaration == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(39);
        }
        return !GoPsiUtil.processDefinitions(declaration, (Processor<GoNamedElement>)((Processor)it -> !it.isPublic()));
    }

    private static boolean hasPublicDefinitions(@NotNull GoVarOrConstSpec<?> spec) {
        if (spec == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(40);
        }
        return ContainerUtil.exists(spec.getDefinitionList(), it -> it.isPublic());
    }

    private static boolean hasPublicDefinitions(@NotNull GoFieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(41);
        }
        return ContainerUtil.exists(fieldDeclaration.getFieldDefinitionList(), it -> it.isPublic());
    }

    private static boolean hasPublicTypeSpecs(@NotNull GoTypeDeclaration typeDeclaration) {
        if (typeDeclaration == null) {
            GoCommentReferenceResolver.$$$reportNull$$$0(42);
        }
        return ContainerUtil.exists(typeDeclaration.getTypeSpecList(), it -> it.isPublic());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 15, 16, 17, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordChainRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordRanges";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoCommentReferenceResolver";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordChainParts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docLink";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentFile";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethodName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDeclaration";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoCommentReferenceResolver";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWordChain";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDocLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolverForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveWord";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveWordChain";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveDocLink";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findUniquePackage";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findTypeFieldOrMethodInPackage";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findTypeInPackage";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findQualifiedElement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findUniquePackageElement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findFieldOrMethodForTargetType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueElement";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasPublicDefinitions";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasPublicTypeSpecs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 15, 16, 17, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

