/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoLinkDefinition
extends FakePsiElement
implements Navigatable {
    private final SmartPsiElementPointer<PsiComment> myComment;
    private final int myOffsetInComment;
    private final String myLinkText;
    private final String myUrl;

    GoLinkDefinition(@NotNull PsiComment comment, int offsetInComment, @NotNull String linkText, @NotNull String url) {
        if (comment == null) {
            GoLinkDefinition.$$$reportNull$$$0(0);
        }
        if (linkText == null) {
            GoLinkDefinition.$$$reportNull$$$0(1);
        }
        if (url == null) {
            GoLinkDefinition.$$$reportNull$$$0(2);
        }
        this.myComment = SmartPointerManager.createPointer((PsiElement)comment);
        this.myOffsetInComment = offsetInComment;
        this.myLinkText = linkText;
        this.myUrl = url;
    }

    public PsiElement getParent() {
        return this.myComment.getElement();
    }

    @NotNull
    public String getLinkText() {
        String string = this.myLinkText;
        if (string == null) {
            GoLinkDefinition.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            GoLinkDefinition.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getOffsetInComment() {
        return this.myOffsetInComment;
    }

    @Nullable
    public TextRange getTextRange() {
        Segment commentRange = this.myComment.getRange();
        return commentRange != null ? TextRange.from((int)(commentRange.getStartOffset() + this.myOffsetInComment), (int)this.myLinkText.length()) : null;
    }

    @Nullable
    public PsiComment getComment() {
        return (PsiComment)this.myComment.getElement();
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        PsiComment c = (PsiComment)this.myComment.getElement();
        PsiFile file2 = c != null ? c.getContainingFile() : null;
        VirtualFile vfile = file2 != null ? file2.getVirtualFile() : null;
        return vfile != null ? NavigationRequest.sourceNavigationRequest((Project)file2.getProject(), (VirtualFile)vfile, (int)(c.getTextRange().getStartOffset() + this.myOffsetInComment)) : null;
    }

    public ItemPresentation getPresentation() {
        return new PresentationData(this.myLinkText, null, AllIcons.Ide.External_link_arrow, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoLinkDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoLinkDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

