/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoIcons;
import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImport;
import com.goide.codeInsight.imports.GoImportPackageQuickFix;
import com.goide.completion.AddBracketsInsertHandler;
import com.goide.completion.BracesInsertHandler;
import com.goide.completion.FieldColonSpaceInsertHandler;
import com.goide.completion.GoLookupElementOptions;
import com.goide.completion.GoPackageInsertHandler;
import com.goide.completion.SingleCharInsertHandler;
import com.goide.completion.testify.GoTestifyCompletionInsertHandler;
import com.goide.editor.template.GoLiveTemplateContextType;
import com.goide.inspections.GoRedundantTypeDeclInCompositeLit;
import com.goide.intentions.GoMigrationUtil;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoIotaUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.presentation.GoPresentationUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.GoFieldDefinitionStub;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCompletionUtil {
    private static final int DEFAULT_SYMBOL_PRIORITY = 5;
    private static final int CONTEXT_SYMBOL_PRIORITY = 35;
    public static final int KEYWORD_PRIORITY = 5;
    public static final int CONTEXT_KEYWORD_PRIORITY = 35;
    public static final int FIELD_PRIORITY = 45;
    public static final int FILL_ALL_FIELDS_PRIORITY = 47;
    public static final int FILL_FIELDS_PRIORITY = 46;
    public static final int INITIALIZE_WITH_ZERO_VALUE_FOR_TYPE_PRIORITY = 41;
    private static final int LABEL_PRIORITY = 45;
    public static final int PACKAGE_PRIORITY = 39;
    public static final int NOT_IMPORTED_FUNCTION_PRIORITY = 5;
    public static final int FUNCTION_PRIORITY = 35;
    public static final int NOT_IMPORTED_VAR_PRIORITY = 5;
    public static final int VAR_PRIORITY = 35;
    public static final int NOT_IMPORTED_TYPE_PRIORITY = 5;
    public static final int TYPE_PRIORITY = 35;
    public static final int NOT_IMPORTED_TYPE_CONVERSION = 5;
    public static final int TYPE_CONVERSION = 35;
    public static final int MATCHED_TYPE_SYMBOL_PRIORITY_DELTA = 5;
    public static final int MATCHED_ANONYMOUS_TYPE_DELTA = 4;
    public static final int MATCHED_TYPE_CONVERSION_PRIORITY_DELTA = 4;
    public static final int MATCHED_COMPOSITE_LITERAL_TYPE_PRIORITY_DELTA = 5;
    public static final int MATCHED_TYPE_NIL_PRIORITY_DELTA = 4;
    public static final int RETURN_NOT_NIL_ERROR_DELTA = 5;
    public static final int COMMENT_OWNER_NAME_PRIORITY = 15;
    public static final int COMMENT_OWNER_DETAILS_PRIORITY = 10;
    public static final int COMMENT_PACKAGE_SYMBOLS_PRIORITY = 5;
    public static final int STRUCT_ADD_KEY_TO_ALL_FIELDS_PRIORITY = 5;
    private static final int MAX_INDEXABLE_CONST_VALUE_LENGTH = 50;
    public static final Key<Boolean> HIDE_TYPE_INFO_IN_TESTS = Key.create((String)"GO_HIDE_TYPE_INFO_IN_TESTS");
    public static final Key<GoImport> GO_IMPORT_KEY = Key.create((String)"GO_IMPORT_COMPLETION_KEY");
    private static final Key<ResolveState> COMPLETION_STATE_CONTEXT = Key.create((String)"COMPLETION_STATE_CONTEXT_KEY");
    private static final Key<Boolean> TAKE_ADDRESS = Key.create((String)"TAKE_ADDRESS");
    private static final Key<Boolean> DEREFERENCE = Key.create((String)"DEREFERENCE");
    private static final Key<Boolean> IS_METHOD_EXPRESSION_QUALIFIER = Key.create((String)"IS_METHOD_EXPRESSION_QUALIFIER");

    @Nullable
    public static PsiElement commitAndGetElementAtCaret(@NotNull InsertionContext context) {
        if (context == null) {
            GoCompletionUtil.$$$reportNull$$$0(0);
        }
        context.commitDocument();
        return context.getFile().findElementAt(context.getStartOffset());
    }

    private static boolean isTypesEnabled() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return !TestModeFlags.is(HIDE_TYPE_INFO_IN_TESTS);
        }
        return true;
    }

    private GoCompletionUtil() {
    }

    @NotNull
    public static <T extends PsiElement> T getPhysicalOriginalOrSelf(@NotNull T psi) {
        if (psi == null) {
            GoCompletionUtil.$$$reportNull$$$0(1);
        }
        Object object = psi.isPhysical() ? psi : CompletionUtil.getOriginalOrSelf(psi);
        if (object == null) {
            GoCompletionUtil.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NotNull
    public static CompletionResultSet withCamelHumpPrefixMatcher(@NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            GoCompletionUtil.$$$reportNull$$$0(3);
        }
        CompletionResultSet completionResultSet = resultSet.withPrefixMatcher(GoCompletionUtil.createPrefixMatcher(resultSet.getPrefixMatcher().getPrefix()));
        if (completionResultSet == null) {
            GoCompletionUtil.$$$reportNull$$$0(4);
        }
        return completionResultSet;
    }

    @NotNull
    public static PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            GoCompletionUtil.$$$reportNull$$$0(5);
        }
        return new CamelHumpMatcher(prefix, false);
    }

    @NotNull
    public static LookupElement createFunctionOrMethodLookupElement(@NotNull GoNamedElement f, @NotNull GoLookupElementOptions options) {
        String qualifierType;
        if (f == null) {
            GoCompletionUtil.$$$reportNull$$$0(6);
        }
        if (options == null) {
            GoCompletionUtil.$$$reportNull$$$0(7);
        }
        String lookupString = StringUtil.notNullize((String)options.getLookupString());
        LookupElementBuilder element = LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)f).withRenderer(Lazy.FUNCTION_RENDERER).withExpensiveRenderer((LookupElementRenderer)new ExpensiveLookupElementRenderer(Lazy.FUNCTION_RENDERER, f)).withInsertHandler((InsertHandler)ObjectUtils.notNull(options.getInsertHandler(), Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER));
        PsiElement context = GoPsiImplUtil.getContextElement(options.getResolveState());
        GoReferenceExpression referenceExpression = (GoReferenceExpression)ObjectUtils.tryCast((Object)context, GoReferenceExpression.class);
        if (referenceExpression != null && (qualifierType = GoPsiImplUtil.getMethodExpressionQualifierTypeName(referenceExpression, options.getResolveState())) != null) {
            element.putUserData(IS_METHOD_EXPRESSION_QUALIFIER, (Object)true);
        }
        element.putUserData(GO_IMPORT_KEY, (Object)options.getImport());
        double priority = options.getPriority(35.0);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)GoCompletionUtil.withAfterDotLookupString(element), (double)priority);
        if (lookupElement == null) {
            GoCompletionUtil.$$$reportNull$$$0(8);
        }
        return lookupElement;
    }

    @Nullable
    private static String calcTailText(@Nullable GoSignatureOwner m, @Nullable GoImport goImport) {
        String result = null;
        if (GoCompletionUtil.isTypesEnabled()) {
            String text = GoCompletionUtil.calcRawTailText(m);
            String string = result = StringUtil.isNotEmpty((String)text) ? " " + GoCompletionUtil.rightArrow() + " " + text : null;
        }
        if (goImport != null) {
            result = StringUtil.notNullize(result) + " " + GoImportPackageQuickFix.getImportPresentation(goImport);
        }
        return result;
    }

    private static String rightArrow() {
        try {
            Font font = EditorFontType.getGlobalPlainFont();
            return FontUtil.rightArrow((Font)font);
        }
        catch (Exception e) {
            return "->";
        }
    }

    @Nullable
    private static String calcRawTailText(@Nullable GoSignatureOwner m) {
        PsiElement parent;
        if (m instanceof GoMethodDeclaration) {
            GoType type = ((GoMethodDeclaration)m).getReceiverType();
            return type != null ? type.getPresentationText() : null;
        }
        if (m instanceof GoMethodSpec && (parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)m)) instanceof GoInterfaceType) {
            return ((GoInterfaceType)parent).getPresentationText();
        }
        return "";
    }

    @NotNull
    public static LookupElement createTypeLookupElement(@NotNull GoTypeSpec t, @NotNull GoLookupElementOptions options) {
        if (t == null) {
            GoCompletionUtil.$$$reportNull$$$0(9);
        }
        if (options == null) {
            GoCompletionUtil.$$$reportNull$$$0(10);
        }
        String lookupString = StringUtil.notNullize((String)options.getLookupString());
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)t).withRenderer(Lazy.TYPE_RENDERER).withExpensiveRenderer((LookupElementRenderer)new ExpensiveLookupElementRenderer(Lazy.TYPE_RENDERER, t)).withInsertHandler((InsertHandler)ObjectUtils.notNull(options.getInsertHandler(), Lazy.TYPE_INSERT_HANDLER));
        Set<String> otherLookupStrings = options.getOtherLookupStrings();
        if (otherLookupStrings != null) {
            builder = builder.withLookupStrings(otherLookupStrings);
        }
        if (options.isTakeAddress()) {
            builder.putUserData(TAKE_ADDRESS, (Object)true);
        }
        builder.putUserData(GO_IMPORT_KEY, (Object)options.getImport());
        double priority = options.getPriority(35.0);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)GoCompletionUtil.withAfterDotLookupString(builder), (double)priority);
        if (lookupElement == null) {
            GoCompletionUtil.$$$reportNull$$$0(11);
        }
        return lookupElement;
    }

    @NotNull
    private static LookupElementBuilder withAfterDotLookupString(@NotNull LookupElementBuilder builder) {
        String lookupString;
        String substringAfterDot;
        if (builder == null) {
            GoCompletionUtil.$$$reportNull$$$0(12);
        }
        if (!(substringAfterDot = GoUtil.substringAfter(lookupString = builder.getLookupString(), '.')).isEmpty()) {
            String decapitalizedAfterDot = StringUtil.decapitalize((String)substringAfterDot);
            String extraLookupString = !lookupString.startsWith(decapitalizedAfterDot) ? decapitalizedAfterDot : substringAfterDot;
            LookupElementBuilder lookupElementBuilder = builder.withLookupString("_" + extraLookupString);
            if (lookupElementBuilder == null) {
                GoCompletionUtil.$$$reportNull$$$0(13);
            }
            return lookupElementBuilder;
        }
        LookupElementBuilder lookupElementBuilder = builder;
        if (lookupElementBuilder == null) {
            GoCompletionUtil.$$$reportNull$$$0(14);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement createLabelLookupElement(@NotNull GoLabelDefinition l, @NotNull String lookupString, int priorityDif) {
        if (l == null) {
            GoCompletionUtil.$$$reportNull$$$0(15);
        }
        if (lookupString == null) {
            GoCompletionUtil.$$$reportNull$$$0(16);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)l).withIcon(GoIcons.LABEL), (double)(45 + priorityDif));
        if (lookupElement == null) {
            GoCompletionUtil.$$$reportNull$$$0(17);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createTypedExpressionLookupElement(@NotNull GoTypeSpec t, @NotNull GoLookupElementOptions options) {
        if (t == null) {
            GoCompletionUtil.$$$reportNull$$$0(18);
        }
        if (options == null) {
            GoCompletionUtil.$$$reportNull$$$0(19);
        }
        if (options.getInsertHandler() == null) {
            options.setInsertHandler(Lazy.TYPED_EXPRESSION_INSERT_HANDLER);
        }
        return GoCompletionUtil.createTypeLookupElement(t, options);
    }

    @NotNull
    public static LookupElement createFieldLookupElement(@NotNull GoFieldDefinition field, @NotNull GoLookupElementOptions options) {
        if (field == null) {
            GoCompletionUtil.$$$reportNull$$$0(20);
        }
        if (options == null) {
            GoCompletionUtil.$$$reportNull$$$0(21);
        }
        if (StringUtil.isEmpty((String)options.getLookupString())) {
            options.setLookupString(field.getName());
        }
        if (options.getInsertHandler() == null) {
            options.setInsertHandler((InsertHandler<LookupElement>)Lazy.FIELD_DEFINITION_INSERT_HANDLER);
        }
        if (options.getPriority() == null) {
            options.setPriority(45.0 + options.getPriorityDelta());
        }
        return GoCompletionUtil.createVariableLikeLookupElement(field, options);
    }

    @NotNull
    public static LookupElement createVariableLikeLookupElement(@NotNull GoNamedElement element, @NotNull GoLookupElementOptions options) {
        if (element == null) {
            GoCompletionUtil.$$$reportNull$$$0(22);
        }
        if (options == null) {
            GoCompletionUtil.$$$reportNull$$$0(23);
        }
        String lookupString = StringUtil.notNullize((String)options.getLookupString());
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)element).withRenderer(Lazy.VARIABLE_RENDERER).withExpensiveRenderer((LookupElementRenderer)new ExpensiveLookupElementRenderer(Lazy.VARIABLE_RENDERER, element)).withInsertHandler(options.getInsertHandler());
        builder.putUserData(GO_IMPORT_KEY, (Object)options.getImport());
        ResolveState state = options.getResolveState();
        if (state != null) {
            builder.putUserData(COMPLETION_STATE_CONTEXT, (Object)state);
        }
        if (options.isTakeAddress()) {
            builder.putUserData(TAKE_ADDRESS, (Object)true);
        }
        if (options.isDereference()) {
            builder.putUserData(DEREFERENCE, (Object)true);
        }
        if (element instanceof GoConstDefinition) {
            GoConstDefinition constDefinition = (GoConstDefinition)element;
            builder = GoCompletionUtil.withConstantValueLookupString(constDefinition, builder);
        }
        if (lookupString.contains(".")) {
            builder = GoCompletionUtil.withAfterDotLookupString(builder);
        }
        LookupElement result = PrioritizedLookupElement.withPriority((LookupElement)builder, (double)options.getPriority(35.0));
        return new LookupElementDecorator<LookupElement>(result){

            public boolean isWorthShowingInAutoPopup() {
                return false;
            }
        };
    }

    private static LookupElementBuilder withConstantValueLookupString(GoConstDefinition constDefinition, LookupElementBuilder builder) {
        boolean isLiteral;
        GoExpression constExpression = GoPsiImplUtil.findVarOrConstExpression(constDefinition);
        if (constExpression == null) {
            return builder;
        }
        boolean bl = isLiteral = constExpression instanceof GoLiteral || constExpression instanceof GoStringLiteral;
        if (!isLiteral) {
            return builder;
        }
        if (GoIotaUtil.containsIota(constExpression)) {
            return builder;
        }
        String constValue = constExpression.getText();
        String constName = builder.getLookupString();
        int constValueLength = Math.min(constValue.length(), 50);
        String result = constName + "_" + constValue.substring(0, constValueLength);
        return builder.withLookupString(result);
    }

    @Nullable
    private static String calcTailTextForVariables(@NotNull GoNamedElement v, @Nullable GoImport goImport) {
        if (v == null) {
            GoCompletionUtil.$$$reportNull$$$0(24);
        }
        if (v instanceof GoFieldDefinition) {
            GoFieldDefinitionStub stub = (GoFieldDefinitionStub)((GoFieldDefinition)v).getStub();
            GoTypeSpec spec = stub != null ? (GoTypeSpec)stub.getParentStubOfType(GoTypeSpec.class) : (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)v, GoTypeSpec.class);
            String typeName = spec != null ? spec.getName() : null;
            return StringUtil.isNotEmpty((String)typeName) ? " " + GoCompletionUtil.rightArrow() + " " + typeName : null;
        }
        if (v instanceof GoConstDefinition) {
            String text;
            GoExpression e = GoPsiImplUtil.findVarOrConstExpression((GoConstDefinition)v);
            String string = text = e == null ? null : e.getText();
            if (text != null) {
                return " = " + text + (String)(goImport != null ? " " + GoImportPackageQuickFix.getImportPresentation(goImport) : "");
            }
        }
        return goImport != null ? " " + GoImportPackageQuickFix.getImportPresentation(goImport) : null;
    }

    @NotNull
    public static LookupElement createPackageLookupElement(@NotNull String importPath, @Nullable String contextImportPath, @Nullable PsiElement navigable, boolean forType) {
        if (importPath == null) {
            GoCompletionUtil.$$$reportNull$$$0(25);
        }
        LookupElementBuilder builder = navigable != null && navigable.isValid() ? LookupElementBuilder.create((Object)navigable, (String)importPath) : LookupElementBuilder.create((String)importPath);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withLookupString(importPath.substring(Math.max(0, importPath.lastIndexOf(47)))).withIcon(GoIcons.PACKAGE).withInsertHandler((InsertHandler)(forType ? Lazy.PACKAGE_INSERT_HANDLER : null)), (double)GoCompletionUtil.calculatePackagePriority(importPath, contextImportPath));
        if (lookupElement == null) {
            GoCompletionUtil.$$$reportNull$$$0(26);
        }
        return lookupElement;
    }

    public static int calculatePackagePriority(@NotNull String importPath, @Nullable String currentPath) {
        if (importPath == null) {
            GoCompletionUtil.$$$reportNull$$$0(27);
        }
        int priority = 39;
        if (StringUtil.isNotEmpty((String)currentPath)) {
            String[] givenSplit = importPath.split("/");
            String[] contextSplit = currentPath.split("/");
            for (int i = 0; i < contextSplit.length && i < givenSplit.length && contextSplit[i].equals(givenSplit[i]); ++i) {
                ++priority;
            }
        }
        return priority - StringUtil.countChars((CharSequence)importPath, (char)'/') - StringUtil.countChars((CharSequence)importPath, (char)'.');
    }

    @Nullable
    public static String getContextImportPath(@Nullable PsiElement context, boolean vendoringEnabled) {
        if (context == null) {
            return null;
        }
        if (context instanceof PsiDirectory) {
            return GoPackageUtil.findFirstImportPath((PsiDirectory)context, vendoringEnabled);
        }
        PsiFile file2 = context.getContainingFile();
        if (file2 instanceof GoFile) {
            return ((GoFile)file2).getImportPath(vendoringEnabled);
        }
        return null;
    }

    @NotNull
    public static LookupElementBuilder createDirectoryLookupElement(@NotNull PsiDirectory dir) {
        if (dir == null) {
            GoCompletionUtil.$$$reportNull$$$0(28);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.createWithSmartPointer((String)dir.getName(), (PsiElement)dir).withIcon(GoIcons.DIRECTORY).withInsertHandler((InsertHandler)(dir.getFiles().length == 0 ? Lazy.DIR_INSERT_HANDLER : null));
        if (lookupElementBuilder == null) {
            GoCompletionUtil.$$$reportNull$$$0(29);
        }
        return lookupElementBuilder;
    }

    private static boolean isTakeAddress(@NotNull LookupElement item) {
        if (item == null) {
            GoCompletionUtil.$$$reportNull$$$0(30);
        }
        return item.getUserData(TAKE_ADDRESS) == Boolean.TRUE;
    }

    private static boolean isDereference(@NotNull LookupElement item) {
        if (item == null) {
            GoCompletionUtil.$$$reportNull$$$0(31);
        }
        return item.getUserData(DEREFERENCE) == Boolean.TRUE;
    }

    public static boolean isAtElementValueWithNewLineCheap(@NotNull InsertionContext context) {
        if (context == null) {
            GoCompletionUtil.$$$reportNull$$$0(32);
        }
        return GoCompletionUtil.isAtElementValueWithNewLineCheap(context.getFile(), context.getDocument(), context.getStartOffset());
    }

    public static boolean isAtElementValueWithNewLineCheap(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        PsiElement element;
        if (file2 == null) {
            GoCompletionUtil.$$$reportNull$$$0(33);
        }
        if (document == null) {
            GoCompletionUtil.$$$reportNull$$$0(34);
        }
        if (GoPsiUtil.isCompositeLiteralElementValue(element = file2.findElementAt(offset))) {
            int endOffset = element.getTextRange().getEndOffset();
            CharSequence text = document.getImmutableCharSequence();
            return GoUtil.isBeforeNewLine(text, endOffset);
        }
        return false;
    }

    @NotNull
    public static String getCompositeLiteralElementTail(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        PsiElement position;
        GoValue value2;
        GoElement element;
        if (file2 == null) {
            GoCompletionUtil.$$$reportNull$$$0(35);
        }
        if (document == null) {
            GoCompletionUtil.$$$reportNull$$$0(36);
        }
        GoElement goElement = element = (value2 = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)(position = file2.findElementAt(offset)), GoValue.class)) != null ? (GoElement)ObjectUtils.tryCast((Object)value2.getParent(), GoElement.class) : null;
        if (element == null) {
            return "";
        }
        int endOffset = value2.getTextRange().getEndOffset();
        if (!GoUtil.isBeforeNewLine(document.getImmutableCharSequence(), endOffset)) {
            return "";
        }
        if (element.getTextRange().getStartOffset() != value2.getTextRange().getStartOffset()) {
            return ",";
        }
        return GoTypeUtil.isMapCompositeLiteralElement(element) ? ": " : ",";
    }

    private static void insertCompositeLiteralElementTail(@NotNull InsertionContext context, @NotNull String tail) {
        if (context == null) {
            GoCompletionUtil.$$$reportNull$$$0(37);
        }
        if (tail == null) {
            GoCompletionUtil.$$$reportNull$$$0(38);
        }
        if (context.shouldAddCompletionChar() && tail.equals(String.valueOf(context.getCompletionChar()))) {
            return;
        }
        int oldTail = context.getTailOffset();
        for (int i = 0; i < tail.length(); ++i) {
            TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)tail.charAt(i));
        }
        if (!tail.isEmpty() && context.shouldAddCompletionChar()) {
            context.setTailOffset(oldTail);
        }
    }

    @NotNull
    public static <T> PatternCondition<T> condition(@NotNull String debugName, final @NotNull Predicate<T> predicate) {
        if (debugName == null) {
            GoCompletionUtil.$$$reportNull$$$0(39);
        }
        if (predicate == null) {
            GoCompletionUtil.$$$reportNull$$$0(40);
        }
        return new PatternCondition<T>(debugName){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                return predicate.test(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/goide/completion/GoCompletionUtil$2", "accepts"));
            }
        };
    }

    static ElementPattern<? extends PsiElement> insideSwitchStatement() {
        return PlatformPatterns.psiElement().with((PatternCondition)new GoExprCaseClauseKeyword());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 11, 13, 14, 17, 26, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoCompletionUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 7: 
            case 10: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoCompletionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalOriginalOrSelf";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withCamelHumpPrefixMatcher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionOrMethodLookupElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeLookupElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withAfterDotLookupString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelLookupElement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageLookupElement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitAndGetElementAtCaret";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalOriginalOrSelf";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 26: 
            case 29: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCamelHumpPrefixMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixMatcher";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionOrMethodLookupElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTypeLookupElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withAfterDotLookupString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createLabelLookupElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTypedExpressionLookupElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFieldLookupElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createVariableLikeLookupElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcTailTextForVariables";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPackageLookupElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calculatePackagePriority";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryLookupElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isTakeAddress";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDereference";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAtElementValueWithNewLineCheap";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeLiteralElementTail";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "insertCompositeLiteralElementTail";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "condition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 11, 13, 14, 17, 26, 29 -> new IllegalStateException(string);
        };
    }

    public static final class Lazy {
        private static final SingleCharInsertHandler DIR_INSERT_HANDLER = new SingleCharInsertHandler('/');
        private static final SingleCharInsertHandler PACKAGE_INSERT_HANDLER = new GoPackageInsertHandler();
        private static final List<InsertHandler<LookupElement>> ADDITIONAL_VARIABLE_OR_FUNCTION_INSERT_HANDLERS = Collections.singletonList(new GoTestifyCompletionInsertHandler());
        public static final InsertHandler<LookupElement> VARIABLE_OR_FUNCTION_INSERT_HANDLER = new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                String tail = GoCompletionUtil.getCompositeLiteralElementTail(context.getFile(), context.getDocument(), context.getStartOffset());
                PsiElement e = item.getPsiElement();
                if (e instanceof GoSignatureOwner) {
                    1.doInsert(context, item, ((GoSignatureOwner)e).getSignature());
                    Lazy.handleNegate(context, ((GoSignatureOwner)e).getResultType());
                } else if (e instanceof GoNamedElement) {
                    GoType type = ((GoNamedElement)e).getGoType(null);
                    if (type instanceof GoFunctionType && !GoCompletionUtil.isTakeAddress(item)) {
                        1.doInsert(context, item, ((GoFunctionType)type).getSignature());
                        Lazy.handleNegate(context, ((GoFunctionType)type).getResultType());
                    } else {
                        Lazy.handleNegate(context, type);
                    }
                }
                Lazy.addAddressOfOrDereferenceIfNeeded(context, item);
                GoCompletionUtil.insertCompositeLiteralElementTail(context, tail);
                for (InsertHandler<LookupElement> handler : ADDITIONAL_VARIABLE_OR_FUNCTION_INSERT_HANDLERS) {
                    handler.handleInsert(context, item);
                }
            }

            private static void doInsert(InsertionContext context, @NotNull LookupElement item, @Nullable GoSignature signature) {
                if (item == null) {
                    1.$$$reportNull$$$0(2);
                }
                int paramsCount = signature != null ? signature.getParameters().getParameterDeclarationList().size() : 0;
                ParenthesesInsertHandler handler = paramsCount == 0 ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS;
                handler.handleInsert(context, item);
                if (signature != null) {
                    AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/completion/GoCompletionUtil$Lazy$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doInsert";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final InsertHandler<LookupElement> TYPE_INSERT_HANDLER = (context, item) -> {
            GoTypeParameters typeParams;
            Editor editor = context.getEditor();
            int offset = editor.getCaretModel().getOffset();
            PsiFile file2 = context.getFile().getOriginalFile();
            PsiElement at = file2.findElementAt(offset);
            PsiElement type = item.getPsiElement();
            GoTypeParameters goTypeParameters = typeParams = type instanceof GoTypeSpec ? ((GoTypeSpec)type).getSpecType().getTypeParameters() : null;
            if (typeParams != null) {
                List<GoTypeParamDefinition> typeParamDefinitions = GoPsiImplUtil.getTypeParamDefinitions(typeParams);
                if (!typeParamDefinitions.isEmpty() && at != null && at.getParent() instanceof GoReceiver) {
                    List typeParamNames = ContainerUtil.map(typeParamDefinitions, it -> it.getName());
                    int tailOffset = context.getTailOffset();
                    String receiverParams = "[" + StringUtil.join((Collection)typeParamNames, (String)", ") + "]";
                    context.getEditor().getDocument().insertString(tailOffset, (CharSequence)receiverParams);
                    int endOffset = tailOffset + receiverParams.length();
                    editor.getCaretModel().moveToOffset(endOffset);
                    return;
                }
                AddBracketsInsertHandler.INSTANCE.handleInsert(context, item);
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
            } else {
                GoMapType mapType = (GoMapType)ObjectUtils.tryCast((Object)(at != null ? at.getParent() : null), GoMapType.class);
                if (mapType != null && at.getNode().getElementType() == GoTypes.RBRACK) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                    if (mapType.getValueType() == null) {
                        AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
                    }
                }
            }
        };
        public static final InsertHandler<LookupElement> TYPED_EXPRESSION_INSERT_HANDLER = (context, item) -> {
            PsiElement element = item.getPsiElement();
            if (element instanceof GoTypeSpec) {
                GoSpecType specType = ((GoTypeSpec)element).getSpecType();
                GoType type = specType.getType();
                if (type != null && GoPsiImplUtil.isValidLiteralType(type.getUnderlyingType(element))) {
                    boolean insertTypeArguments;
                    Lazy.addAddressOfOrDereferenceIfNeeded(context, item);
                    int typeStart = context.getStartOffset();
                    int typeEnd = context.getTailOffset();
                    BracesInsertHandler.ONE_LINER.handleInsert(context, item);
                    boolean typeDeleted = Lazy.deleteRedundantType(context, typeStart, typeEnd);
                    boolean bl = insertTypeArguments = !typeDeleted && specType.getTypeParameters() != null;
                    if (insertTypeArguments) {
                        int tabOutOffset = type instanceof GoStructType && Lazy.hasAccessibleFields(context.getFile(), (GoStructType)type) ? 2 : 3;
                        context.setTailOffset(typeEnd);
                        new AddBracketsInsertHandler(tabOutOffset).handleInsert(context, item);
                        AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
                    }
                    if (!insertTypeArguments && type instanceof GoStructType) {
                        if (!Lazy.hasAccessibleFields(context.getFile(), (GoStructType)type)) {
                            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
                        } else {
                            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
                        }
                    }
                } else {
                    String tail = GoCompletionUtil.getCompositeLiteralElementTail(context.getFile(), context.getDocument(), context.getStartOffset());
                    ParenthesesInsertHandler.WITH_PARAMETERS.handleInsert(context, item);
                    GoCompletionUtil.insertCompositeLiteralElementTail(context, tail);
                }
            }
        };
        private static final FieldColonSpaceInsertHandler FIELD_DEFINITION_INSERT_HANDLER = new FieldColonSpaceInsertHandler(){

            @Override
            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                PsiFile file2;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!((file2 = context.getFile()) instanceof GoFile)) {
                    return;
                }
                PsiElement at = GoCompletionUtil.commitAndGetElementAtCaret(context);
                GoCompositeElement ref = (GoCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])new Class[]{GoValue.class, GoReferenceExpression.class});
                if (ref instanceof GoReferenceExpression && ((GoReferenceExpression)ref).getQualifier() != null) {
                    PsiElement psiElement = item.getPsiElement();
                    if (psiElement instanceof GoFieldDefinition) {
                        Lazy.handleNegate(context, ((GoFieldDefinition)psiElement).getGoType(null));
                    }
                    Lazy.addAddressOfOrDereferenceIfNeeded(context, item);
                    return;
                }
                GoValue value2 = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)at, GoValue.class);
                if (value2 == null || PsiTreeUtil.getPrevSiblingOfType((PsiElement)value2, GoKey.class) != null) {
                    return;
                }
                super.handleInsert(context, item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/goide/completion/GoCompletionUtil$Lazy$2";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private static final LookupElementRenderer<LookupElement> TYPE_RENDERER = new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation p) {
                PsiElement o;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (p == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!((o = element.getPsiElement()) instanceof GoTypeSpec)) {
                    return;
                }
                GoSpecType type = ((GoTypeSpec)o).getSpecType();
                GoTypeParameters typeParameters = type.getTypeParameters();
                String typeParamsText = typeParameters == null ? "" : GoPresentationUtil.getTypeParameterPresentation(typeParameters);
                p.setItemText((GoCompletionUtil.isTakeAddress(element) ? "&" : "") + element.getLookupString() + typeParamsText);
                GoImport goImport = (GoImport)((Object)element.getUserData(GO_IMPORT_KEY));
                if (goImport != null) {
                    p.setTailText(" " + GoImportPackageQuickFix.getImportPresentation(goImport), true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "p";
                        break;
                    }
                }
                objectArray[1] = "com/goide/completion/GoCompletionUtil$Lazy$3";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private static final LookupElementRenderer<LookupElement> FUNCTION_RENDERER = new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation p) {
                PsiElement o;
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (p == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!((o = element.getPsiElement()) instanceof GoNamedSignatureOwner)) {
                    return;
                }
                GoNamedSignatureOwner f = (GoNamedSignatureOwner)o;
                GoSignature signature = f.getSignature();
                GoTypeParameters typeParameters = signature != null ? signature.getTypeParameters() : null;
                String typeParamsText = typeParameters == null ? "" : GoPresentationUtil.getTypeParameterPresentation(typeParameters);
                GoParameters parameters = signature != null ? signature.getParameters() : null;
                String paramText = Lazy.parametersToText(parameters, element);
                GoResult result = signature != null ? signature.getResult() : null;
                p.setTypeText(GoPresentationUtil.getResultPresentation(result));
                p.setTailText(typeParamsText + paramText);
                String optionalTailText = GoCompletionUtil.calcTailText(f, (GoImport)((Object)element.getUserData(GO_IMPORT_KEY)));
                if (optionalTailText != null) {
                    p.appendTailText(optionalTailText, true);
                }
                p.setItemText(element.getLookupString());
                p.setTypeGrayed(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "p";
                        break;
                    }
                }
                objectArray[1] = "com/goide/completion/GoCompletionUtil$Lazy$4";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private static final LookupElementRenderer<LookupElement> VARIABLE_RENDERER = new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation p) {
                PsiElement o;
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (p == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!((o = element.getPsiElement()) instanceof GoNamedElement)) {
                    return;
                }
                GoNamedElement v = (GoNamedElement)o;
                GoType type = GoCompletionUtil.isTypesEnabled() ? v.getGoType((ResolveState)element.getUserData(COMPLETION_STATE_CONTEXT)) : null;
                Object typeText = type != null ? type.getPresentationText() : "";
                Object itemText = element.getLookupString();
                if (GoCompletionUtil.isTakeAddress(element)) {
                    typeText = StringUtil.isNotEmpty((String)typeText) ? "*" + (String)typeText : "";
                    itemText = "&" + (String)itemText;
                } else if (GoCompletionUtil.isDereference(element)) {
                    typeText = ((String)typeText).startsWith("*") ? ((String)typeText).substring(1) : typeText;
                    itemText = "*" + (String)itemText;
                }
                p.setItemText((String)itemText);
                p.setTailText(GoCompletionUtil.calcTailTextForVariables(v, (GoImport)((Object)element.getUserData(GO_IMPORT_KEY))), true);
                p.setTypeText((String)typeText);
                p.setTypeGrayed(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "p";
                        break;
                    }
                }
                objectArray[1] = "com/goide/completion/GoCompletionUtil$Lazy$5";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private static boolean hasAccessibleFields(@NotNull PsiFile referenceFile, @NotNull GoStructType struct) {
            List<GoNamedElement> fields;
            if (referenceFile == null) {
                Lazy.$$$reportNull$$$0(0);
            }
            if (struct == null) {
                Lazy.$$$reportNull$$$0(1);
            }
            if ((fields = struct.getFieldDefinitions()).isEmpty()) {
                return false;
            }
            return ContainerUtil.find(fields, it -> it.isPublic()) != null || GoUtil.inSamePackage(struct.getContainingFile(), referenceFile);
        }

        private static void addAddressOfOrDereferenceIfNeeded(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                Lazy.$$$reportNull$$$0(2);
            }
            if (item == null) {
                Lazy.$$$reportNull$$$0(3);
            }
            boolean addressOf = GoCompletionUtil.isTakeAddress(item);
            boolean dereference = GoCompletionUtil.isDereference(item);
            if (!addressOf && !dereference) {
                return;
            }
            PsiElement at = GoCompletionUtil.commitAndGetElementAtCaret(context);
            GoExpression expression = (GoExpression)PsiTreeUtil.getParentOfType((PsiElement)at, GoExpression.class);
            if (expression == null) {
                return;
            }
            GoUnaryExpr unary = (GoUnaryExpr)ObjectUtils.tryCast((Object)expression.getParent(), GoUnaryExpr.class);
            if (unary != null && (addressOf && unary.getBitAnd() != null || dereference && unary.getMul() != null)) {
                return;
            }
            int startOffset = context.getStartOffset();
            int tailOffset = context.getTailOffset();
            Document document = context.getEditor().getDocument();
            document.insertString(expression.getTextRange().getStartOffset(), (CharSequence)(addressOf ? "&" : "*"));
            context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
            context.setTailOffset(tailOffset + 1);
        }

        private static boolean deleteRedundantType(@NotNull InsertionContext context, int typeStart, int typeEnd) {
            if (context == null) {
                Lazy.$$$reportNull$$$0(4);
            }
            context.commitDocument();
            PsiElement at = context.getFile().findElementAt(typeStart);
            GoValue value2 = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)at, GoValue.class);
            GoElement compositeElement = (GoElement)PsiTreeUtil.getParentOfType((PsiElement)value2, GoElement.class);
            if (value2 != null && compositeElement != null && value2.getTextRange().getStartOffset() == at.getTextRange().getStartOffset()) {
                GoType elementType;
                GoCompositeLit compositeLit = (GoCompositeLit)PsiTreeUtil.getParentOfType((PsiElement)compositeElement, GoCompositeLit.class);
                GoType compLitType = compositeLit != null ? GoTypeUtil.getExpectedValueType(compositeLit) : null;
                GoExpression valueExpression = value2.getExpression();
                GoType goType = elementType = valueExpression != null ? valueExpression.getGoType(null) : null;
                if (GoRedundantTypeDeclInCompositeLit.canOmitDeclarationType(compLitType, elementType, value2)) {
                    context.getDocument().deleteString(typeStart, typeEnd);
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private static String parametersToText(@Nullable GoParameters parameters, @NotNull LookupElement element) {
            PsiElement psiElement;
            if (element == null) {
                Lazy.$$$reportNull$$$0(5);
            }
            if (parameters == null) {
                return "";
            }
            if (Boolean.TRUE.equals(element.getUserData(IS_METHOD_EXPRESSION_QUALIFIER)) && (psiElement = element.getPsiElement()) instanceof GoMethodDeclaration) {
                GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)psiElement;
                GoReceiver receiver = methodDeclaration.getReceiver();
                GoSignature signature = methodDeclaration.getSignature();
                if (receiver != null && signature != null) {
                    List<String> parameterDeclarations = GoMigrationUtil.getParameterDeclarations(receiver, signature);
                    Project project = methodDeclaration.getProject();
                    GoSignature newSignature = GoElementFactory.createFunctionSignature(project, Collections.emptyList(), parameterDeclarations, "", methodDeclaration);
                    String string = GoPresentationUtil.getParameterPresentation(newSignature.getParameters());
                    if (string == null) {
                        Lazy.$$$reportNull$$$0(6);
                    }
                    return string;
                }
            }
            String string = GoPresentationUtil.getParameterPresentation(parameters);
            if (string == null) {
                Lazy.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static void handleNegate(@NotNull InsertionContext context, @Nullable GoType type) {
            if (context == null) {
                Lazy.$$$reportNull$$$0(8);
            }
            if (context.getCompletionChar() == '!' && GoTypeUtil.isBoolean(type, (PsiElement)context.getFile())) {
                context.setAddCompletionChar(false);
                PsiElement at = GoCompletionUtil.commitAndGetElementAtCaret(context);
                GoReferenceExpression referenceExpression = (GoReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{GoReferenceExpression.class});
                if (referenceExpression != null) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                    context.getDocument().insertString(referenceExpression.getTextRange().getStartOffset(), (CharSequence)"!");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "struct";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoCompletionUtil$Lazy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoCompletionUtil$Lazy";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parametersToText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "hasAccessibleFields";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addAddressOfOrDereferenceIfNeeded";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRedundantType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parametersToText";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleNegate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ExpensiveLookupElementRenderer
    extends LookupElementRenderer<LookupElement> {
        private final LookupElementRenderer<LookupElement> myInexpensiveRenderer;
        private final GoNamedElement myElement;

        private ExpensiveLookupElementRenderer(@NotNull LookupElementRenderer<LookupElement> inexpensiveRenderer, @NotNull GoNamedElement element) {
            if (inexpensiveRenderer == null) {
                ExpensiveLookupElementRenderer.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ExpensiveLookupElementRenderer.$$$reportNull$$$0(1);
            }
            this.myInexpensiveRenderer = inexpensiveRenderer;
            this.myElement = element;
        }

        public void renderElement(LookupElement element, LookupElementPresentation presentation2) {
            this.myInexpensiveRenderer.renderElement(element, presentation2);
            presentation2.setIcon(this.getIcon());
            presentation2.setStrikeout(this.myElement.isDeprecated());
        }

        @Nullable
        private Icon getIcon() {
            if (this.myInexpensiveRenderer == Lazy.TYPE_RENDERER) {
                return this.myElement instanceof GoTypeSpec ? GoPsiImplUtil.getTypeSpecIcon((GoTypeSpec)this.myElement) : null;
            }
            if (this.myInexpensiveRenderer == Lazy.FUNCTION_RENDERER) {
                return this.myElement instanceof GoMethodDeclaration || this.myElement instanceof GoMethodSpec ? GoIcons.METHOD : GoIcons.FUNCTION;
            }
            if (this.myInexpensiveRenderer == Lazy.VARIABLE_RENDERER) {
                return this.myElement instanceof GoVarDefinition ? GoIcons.VARIABLE : (this.myElement instanceof GoParamDefinition ? GoIcons.PARAMETER : (this.myElement instanceof GoReceiver ? GoIcons.RECEIVER : (this.myElement instanceof GoConstDefinition ? GoIcons.CONSTANT : (this.myElement instanceof GoFunctionDeclaration ? GoIcons.VARIABLE : (GoPsiImplUtil.isFieldDefinition(this.myElement) ? GoIcons.FIELD : null)))));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inexpensiveRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoCompletionUtil$ExpensiveLookupElementRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoExprCaseClauseKeyword
    extends PatternCondition<PsiElement> {
        GoExprCaseClauseKeyword() {
            super("case expression clause keyword");
        }

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                GoExprCaseClauseKeyword.$$$reportNull$$$0(0);
            }
            if (!GoLiveTemplateContextType.Statement.onStatementBeginning(element)) {
                return false;
            }
            IElementType type = element.getNode().getElementType();
            if (type != GoTypes.IDENTIFIER && type != GoTypes.CASE && type != GoTypes.DEFAULT) {
                return false;
            }
            GoStatement statement = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GoStatement.class);
            return statement != null && statement.getParent() instanceof GoCaseClause;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/completion/GoCompletionUtil$GoExprCaseClauseKeyword", "accepts"));
        }
    }
}

