/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoTypes;
import com.goide.completion.GoMLCompletionFeatures;
import com.goide.editor.template.GoEverywhereContextType;
import com.goide.editor.template.GoLiveTemplateContextType;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoKeywordCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final InsertHandler<LookupElement> EMPTY_INSERT_HANDLER = (context, element) -> {};
    private final int myPriority;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final AutoCompletionPolicy myCompletionPolicy;
    private final String @NotNull [] myKeywords;

    public GoKeywordCompletionProvider(int priority, String ... keywords) {
        this(priority, (InsertHandler<LookupElement>)null, (AutoCompletionPolicy)null, keywords);
    }

    public GoKeywordCompletionProvider(int priority, @Nullable InsertHandler<LookupElement> insertHandler, String ... keywords) {
        if (keywords == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(0);
        }
        this(priority, insertHandler, (AutoCompletionPolicy)null, keywords);
    }

    public GoKeywordCompletionProvider(int priority, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable AutoCompletionPolicy completionPolicy, String ... keywords) {
        if (keywords == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(1);
        }
        this.myPriority = priority;
        this.myInsertHandler = insertHandler;
        this.myCompletionPolicy = completionPolicy;
        this.myKeywords = keywords;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(4);
        }
        for (String keyword : this.myKeywords) {
            result.addElement(this.createKeywordLookupElement(keyword));
        }
    }

    @NotNull
    private LookupElement createKeywordLookupElement(@NotNull String keyword) {
        if (keyword == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(5);
        }
        InsertHandler insertHandler = this.myInsertHandler != null ? this.myInsertHandler : (context, item) -> GoKeywordCompletionProvider.runTemplateBasedInsertHandler("go_lang_" + keyword, context);
        LookupElementBuilder lookupElement = LookupElementBuilder.create((String)keyword).withInsertHandler(insertHandler);
        lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)this.myPriority);
        if (this.myCompletionPolicy != null) {
            lookupElement = this.myCompletionPolicy.applyPolicy((LookupElement)lookupElement);
        }
        GoMLCompletionFeatures.addKeywordName(lookupElement, keyword);
        LookupElementBuilder lookupElementBuilder = lookupElement;
        if (lookupElementBuilder == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(6);
        }
        return lookupElementBuilder;
    }

    public static void runTemplateBasedInsertHandler(@NotNull String templateId, InsertionContext context) {
        if (templateId == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(7);
        }
        Template template = TemplateSettings.getInstance().getTemplateById(templateId);
        Editor editor = context.getEditor();
        PsiElement at = context.getFile().findElementAt(context.getStartOffset());
        if (template != null && (!GoKeywordCompletionProvider.isStatementTemplate((TemplateImpl)template) || GoKeywordCompletionProvider.onStatementEnd(at))) {
            editor.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
            TemplateManager.getInstance((Project)context.getProject()).startTemplate(editor, template);
        } else {
            int currentOffset = editor.getCaretModel().getOffset();
            CharSequence documentText = editor.getDocument().getImmutableCharSequence();
            if (documentText.length() <= currentOffset || documentText.charAt(currentOffset) != ' ') {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" ");
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor);
            } else {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            }
        }
    }

    private static boolean onStatementEnd(@Nullable PsiElement e) {
        PsiElement nextElement = GoLiveTemplateContextType.nextVisibleLeafOrNewLine(e);
        if (nextElement == null || nextElement instanceof PsiWhiteSpace) {
            return true;
        }
        IElementType type = nextElement.getNode().getElementType();
        return type == GoTypes.SEMICOLON || type == GoTypes.LBRACE || type == GoTypes.RBRACE || type == GoTypes.COLON || type == GoTypes.RPAREN;
    }

    private static boolean isStatementTemplate(@NotNull TemplateImpl template) {
        if (template == null) {
            GoKeywordCompletionProvider.$$$reportNull$$$0(8);
        }
        return template.getTemplateContext().isEnabled(TemplateContextTypes.getByClass(GoLiveTemplateContextType.Statement.class)) && !template.getTemplateContext().isEnabled(TemplateContextTypes.getByClass(GoEverywhereContextType.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoKeywordCompletionProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoKeywordCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runTemplateBasedInsertHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStatementTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

