/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoLookupElementOptions;
import com.goide.completion.GoMLCompletionFeatures;
import com.goide.completion.GoParameterNameDecorator;
import com.goide.intentions.expressions.structLiteral.GoFillFieldsIntentionBase;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoScopeProcessor;
import com.goide.psi.impl.GoTypeReference;
import com.goide.psi.impl.expectedTypes.GoExpectedTypes;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoPackageLevelPublicElementsIndex;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoReferenceCompletionScopeProcessor
extends GoScopeProcessor {
    private static final BasicInsertHandler<LookupElementDecorator<LookupElement>> BASIC_INSERT_HANDLER = new BasicInsertHandler();
    @NotNull
    private final CompletionResultSet myResult;
    private final boolean myForTypes;
    private final boolean myVendoringEnabled;
    private final boolean mySuggestParameterName;
    private final GoExpectedTypes myExpectedTypes;
    private final ConcurrentHashMap<String, Boolean> myProcessedNames;
    private final CompletionParameters myParameters;
    @NotNull
    private final Set<String> myUsedNames;
    private final boolean myIgnoreVisibilityRules;
    private boolean myCollectElementsFromImports;

    GoReferenceCompletionScopeProcessor(@NotNull CompletionResultSet result, @NotNull PsiFile originalFile, @NotNull PsiReference reference, @NotNull GoExpectedTypes expectedTypes, @NotNull CompletionParameters parameters) {
        if (result == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(0);
        }
        if (originalFile == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(2);
        }
        if (expectedTypes == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(4);
        }
        this.myProcessedNames = new ConcurrentHashMap();
        this.myCollectElementsFromImports = true;
        this.myResult = result;
        this.myForTypes = reference instanceof GoTypeReference;
        this.myVendoringEnabled = GoVendoringUtil.isVendoringEnabled((PsiElement)originalFile);
        this.myExpectedTypes = expectedTypes;
        this.myParameters = parameters;
        PsiElement parent = this.myParameters.getPosition().getParent();
        this.mySuggestParameterName = GoParameterNameDecorator.shouldSuggestNamesInParameters(parent);
        this.myIgnoreVisibilityRules = originalFile instanceof GoCodeFragment && ((GoCodeFragment)originalFile).isIgnoreVisibilityRules();
        this.myUsedNames = this.mySuggestParameterName ? GoNameSuggestionProvider.getNamesInContext(PsiTreeUtil.getParentOfType((PsiElement)parent, GoSignature.class)) : Collections.emptySet();
    }

    public boolean execute(@NotNull PsiElement o, @NotNull ResolveState state) {
        if (o == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(5);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(6);
        }
        this.processCompletionCandidate(o, state, null);
        return true;
    }

    void processCompletionCandidate(@NotNull PsiElement o, @NotNull ResolveState state, @Nullable String qualifier) {
        if (o == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(7);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(8);
        }
        if (o instanceof GoNamedElement && this.accept(o)) {
            this.addElement((GoNamedElement)o, state, qualifier);
        }
    }

    void setCollectElementsFromImports(boolean collectElementsFromImports) {
        this.myCollectElementsFromImports = collectElementsFromImports;
    }

    private void addElement(@NotNull GoNamedElement o, @NotNull ResolveState state, @Nullable String qualifier) {
        String lookupString;
        LookupElement lookup;
        if (o == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(9);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(10);
        }
        if ((lookup = this.createLookupElement(o, state, qualifier)) != null && this.myProcessedNames.putIfAbsent(lookupString = lookup.getLookupString(), true) == null) {
            this.myResult.addElement(lookup);
            GoMLCompletionFeatures.addNamedElementKind(lookup, o);
        }
    }

    @Nullable
    private static GoType getPointerType(@NotNull GoNamedElement element, @NotNull ResolveState state, boolean forTypes) {
        GoNamedElement originalElement;
        if (element == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(11);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(12);
        }
        if ((originalElement = (GoNamedElement)CompletionUtil.getOriginalOrSelf((PsiElement)element)) instanceof GoTypeSpec) {
            if (forTypes || ((GoTypeSpec)originalElement).getSpecType().getType() instanceof GoCompositeType) {
                return new GoLightType.LightPointerType(((GoTypeSpec)originalElement).getSpecType());
            }
        } else {
            if (element instanceof GoSignatureOwner) {
                return null;
            }
            GoType type = originalElement.getGoType(state);
            if (type != null) {
                return new GoLightType.LightPointerType(type);
            }
        }
        return null;
    }

    @Nullable
    private LookupElement createLookupElement(@NotNull GoNamedElement element, @NotNull ResolveState state, @Nullable String qualifier) {
        if (element == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(14);
        }
        if (element.isBlank()) {
            return null;
        }
        if (element instanceof GoImportSpec) {
            return this.createLookupElementForImportSpec(element, state);
        }
        String name = element.getName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        if (element instanceof GoFieldDefinition && !this.myParameters.isExtendedCompletion() && GoFillFieldsIntentionBase.isProtobufGeneratedField(element)) {
            return null;
        }
        LookupElement fastLookupElement = this.createLookupElementFast(element, state, qualifier, name);
        if (!this.myResult.getPrefixMatcher().prefixMatches(fastLookupElement)) {
            return null;
        }
        boolean smartCompletion = this.myParameters.getCompletionType() == CompletionType.SMART;
        GoNamedElement original = (GoNamedElement)CompletionUtil.getOriginalOrSelf((PsiElement)element);
        boolean isTypeCompatible = this.isTypeCompatible(original, state);
        boolean isPointerTypeCompatible = false;
        boolean isDerefTypeCompatible = false;
        if (smartCompletion && !isTypeCompatible) {
            GoType type;
            GoType pointerType = GoReferenceCompletionScopeProcessor.getPointerType(element, state, this.myForTypes);
            boolean bl = isPointerTypeCompatible = pointerType != null && this.myExpectedTypes.areCompatibleWith(pointerType, null, true, false, state);
            if (!this.myForTypes && !isPointerTypeCompatible && (type = original.getGoType(state)) instanceof GoPointerType) {
                GoType derefType = ((GoPointerType)type).getType();
                boolean bl2 = isDerefTypeCompatible = derefType != null && this.myExpectedTypes.areCompatibleWith(derefType, null, true, false, state);
            }
            if (!isPointerTypeCompatible && !isDerefTypeCompatible) {
                return null;
            }
        }
        return this.createLookupElement(element, state, qualifier, name, isTypeCompatible, isPointerTypeCompatible, isDerefTypeCompatible, false);
    }

    @NotNull
    private LookupElement createLookupElementFast(@NotNull GoNamedElement element, @NotNull ResolveState state, @Nullable String qualifier, @NotNull String name) {
        if (element == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(15);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(16);
        }
        if (name == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(17);
        }
        return this.createLookupElement(element, state, qualifier, name, false, false, false, true);
    }

    @NotNull
    private LookupElement createLookupElement(@NotNull GoNamedElement element, @NotNull ResolveState state, @Nullable String qualifier, @NotNull String name, boolean isTypeCompatible, boolean isPointerTypeCompatible, boolean isDerefTypeCompatible, boolean fast) {
        if (element == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(18);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(19);
        }
        if (name == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(20);
        }
        int priorityDelta = this.getPriorityDelta(element, isTypeCompatible || isPointerTypeCompatible || isDerefTypeCompatible);
        if (element instanceof GoTypeSpec) {
            GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(GoReferenceCompletionScopeProcessor.prepend(name, qualifier)).setPriorityDelta(priorityDelta);
            if (this.myForTypes) {
                if (isPointerTypeCompatible) {
                    options.setLookupString("*" + options.getLookupString());
                }
            } else {
                options.setTakeAddress(isPointerTypeCompatible);
                options.setPriority(35 + priorityDelta);
            }
            LookupElement origin = this.myForTypes ? GoCompletionUtil.createTypeLookupElement((GoTypeSpec)element, options) : GoCompletionUtil.createTypedExpressionLookupElement((GoTypeSpec)element, options);
            LookupElement lookupElement = this.mySuggestParameterName ? GoParameterNameDecorator.withParameterNameIfNeeded(origin, StringUtil.notNullize((String)element.getQualifiedName()), this.myUsedNames) : origin;
            if (lookupElement == null) {
                GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(21);
            }
            return lookupElement;
        }
        if (element instanceof GoLabelDefinition) {
            LookupElement lookupElement = GoCompletionUtil.createLabelLookupElement((GoLabelDefinition)element, name, priorityDelta);
            if (lookupElement == null) {
                GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(22);
            }
            return lookupElement;
        }
        if (element instanceof GoFieldDefinition) {
            LookupElement lookupElement = GoCompletionUtil.createFieldLookupElement((GoFieldDefinition)element, new GoLookupElementOptions().setTakeAddress(isPointerTypeCompatible).setDereference(isDerefTypeCompatible).setPriorityDelta(priorityDelta));
            if (lookupElement == null) {
                GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(23);
            }
            return lookupElement;
        }
        GoType type = element.getGoType(state);
        if (type instanceof GoFunctionType) {
            return this.createLookupElementForElementOfFunctionType(state, element, name, isPointerTypeCompatible, priorityDelta, qualifier, fast);
        }
        GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(GoReferenceCompletionScopeProcessor.prepend(name, qualifier)).setInsertHandler(GoCompletionUtil.Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER).setResolveState(state).setTakeAddress(isPointerTypeCompatible).setDereference(isDerefTypeCompatible).setPriorityDelta(priorityDelta);
        LookupElement lookupElement = GoCompletionUtil.createVariableLikeLookupElement(element, options);
        if (lookupElement == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(24);
        }
        return lookupElement;
    }

    @Nullable
    private LookupElement createLookupElementForImportSpec(@NotNull GoNamedElement element, @NotNull ResolveState state) {
        boolean smartCompletion;
        String name;
        if (element == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(25);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(26);
        }
        if ((name = (String)state.get(GoReferenceBase.ACTUAL_NAME)) == null) {
            return null;
        }
        Collection<GoPackage> packages = ((GoImportSpec)element).resolve(state);
        boolean bl = smartCompletion = this.myParameters.getCompletionType() == CompletionType.SMART;
        if (smartCompletion) {
            if (this.myCollectElementsFromImports) {
                String alias = ((GoImportSpec)element).getAlias();
                for (GoPackage aPackage : packages) {
                    String packageName = aPackage.getName();
                    Project project = element.getProject();
                    GlobalSearchScope packageScope = aPackage.getScope((PsiFile)element.getContainingFile());
                    String qualifierToUse = alias == null ? packageName : alias;
                    GoPackageLevelPublicElementsIndex.processElements(packageName, project, packageScope, (Processor<? super GoNamedElement>)((Processor)it -> {
                        this.processCompletionCandidate((PsiElement)it, state, qualifierToUse);
                        return true;
                    }));
                }
            }
            return null;
        }
        PsiElement navigableElement = GoPackageUtil.getFirstNavigableDirectory(packages);
        return GoCompletionUtil.createPackageLookupElement(name, GoCompletionUtil.getContextImportPath(element, this.myVendoringEnabled), navigableElement, true);
    }

    @NotNull
    private LookupElement createLookupElementForElementOfFunctionType(@NotNull ResolveState state, @NotNull GoNamedElement o, @NotNull String name, boolean takeAddress, int priorityDelta, @Nullable String qualifier, boolean fast) {
        GoType type;
        LookupElement lookup;
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(27);
        }
        if (o == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(28);
        }
        if (name == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(29);
        }
        if (o instanceof GoNamedSignatureOwner) {
            options = new GoLookupElementOptions().setLookupString(GoReferenceCompletionScopeProcessor.prepend(name, qualifier)).setResolveState(state).setPriorityDelta(priorityDelta);
            lookup = GoCompletionUtil.createFunctionOrMethodLookupElement(o, options);
        } else {
            options = new GoLookupElementOptions().setLookupString(GoReferenceCompletionScopeProcessor.prepend(name, qualifier)).setInsertHandler(GoCompletionUtil.Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER).setResolveState(state).setTakeAddress(takeAddress).setPriorityDelta(priorityDelta);
            lookup = GoCompletionUtil.createVariableLikeLookupElement(o, options);
        }
        if (fast) {
            LookupElement lookupElement = lookup;
            if (lookupElement == null) {
                GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(30);
            }
            return lookupElement;
        }
        if (this.myExpectedTypes.containFunctionType(state) && !this.isFunctionResultTypeCompatible(o.getGoType(state), state)) {
            LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)lookup, BASIC_INSERT_HANDLER);
            if (lookupElementDecorator == null) {
                GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(31);
            }
            return lookupElementDecorator;
        }
        if ((this.myExpectedTypes.containInterfaceType(state) || this.myExpectedTypes.containDocOnlyAnyType(state)) && (type = o.getGoType(state)) instanceof GoFunctionType && ((GoFunctionType)type).getResultType() instanceof GoLightType.LightVoidType) {
            LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)lookup, BASIC_INSERT_HANDLER);
            if (lookupElementDecorator == null) {
                GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(32);
            }
            return lookupElementDecorator;
        }
        LookupElement lookupElement = lookup;
        if (lookupElement == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(33);
        }
        return lookupElement;
    }

    @NotNull
    private static String prepend(@NotNull String name, @Nullable String qualifier) {
        if (name == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(34);
        }
        String string = (String)(qualifier == null ? "" : qualifier + ".") + name;
        if (string == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(35);
        }
        return string;
    }

    private int getPriorityDelta(@NotNull GoNamedElement o, boolean isTypeCompatible) {
        if (o == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(36);
        }
        if (isTypeCompatible && o instanceof GoTypeSpec && !this.myForTypes) {
            GoType type = ((GoTypeSpec)o).getSpecType().getType();
            return type != null && GoPsiImplUtil.isValidLiteralType(type.getUnderlyingType(o)) ? 5 : 4;
        }
        GoFile file2 = ((GoNamedElement)CompletionUtil.getOriginalOrSelf((PsiElement)o)).getContainingFile();
        if (GoPsiImplUtil.isBuiltinFile((PsiFile)file2) && "nil".equals(o.getName())) {
            return isTypeCompatible ? 4 : 0;
        }
        return isTypeCompatible ? 5 : 0;
    }

    private boolean isTypeCompatible(@NotNull GoNamedElement o, @NotNull ResolveState state) {
        if (o == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(37);
        }
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(38);
        }
        if (o instanceof GoTypeSpec) {
            GoSpecType type = ((GoTypeSpec)o).getSpecType();
            return this.myExpectedTypes.areCompatibleWith((GoType)CompletionUtil.getOriginalOrSelf((PsiElement)type), null, true, false, state);
        }
        return this.myExpectedTypes.areCompatibleWith((GoTypeOwner)CompletionUtil.getOriginalOrSelf((PsiElement)o), true, false, state) || this.isFunctionResultTypeCompatible(o.getGoType(state), state);
    }

    private boolean isFunctionResultTypeCompatible(@Nullable GoType type, @NotNull ResolveState state) {
        if (state == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(39);
        }
        GoType resultType = type instanceof GoFunctionType ? ((GoFunctionType)type).getResultType() : null;
        return resultType != null && this.myExpectedTypes.areCompatibleWith((GoType)CompletionUtil.getOriginalOrSelf((PsiElement)resultType), null, true, false, state);
    }

    protected boolean accept(@NotNull PsiElement e) {
        if (e == null) {
            GoReferenceCompletionScopeProcessor.$$$reportNull$$$0(40);
        }
        return !GoPsiUtil.isUnexportedAndFromOtherPackage(e, (PsiElement)this.myParameters.getOriginalFile()) || this.myIgnoreVisibilityRules && (GoPsiImplUtil.isFieldDefinition(e) || e instanceof GoVarOrConstDefinition);
    }

    @Override
    public boolean isCompletion() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 22, 23, 24, 30, 31, 32, 33, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 28: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 20: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoReferenceCompletionScopeProcessor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoReferenceCompletionScopeProcessor";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElementForElementOfFunctionType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCompletionCandidate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPointerType";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementFast";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementForImportSpec";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementForElementOfFunctionType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPriorityDelta";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCompatible";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionResultTypeCompatible";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 22, 23, 24, 30, 31, 32, 33, 35 -> new IllegalStateException(string);
        };
    }
}

