/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.completion.CancellableCollectProcessor;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.generate.GoGenerateTestActionBase;
import com.goide.psi.GoBlock;
import com.goide.psi.GoEmptyStatement;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkService;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GoTestFunctionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(2);
        }
        Project project = parameters.getPosition().getProject();
        PsiFile file2 = parameters.getOriginalFile();
        PsiDirectory containingDirectory = file2.getContainingDirectory();
        if (file2 instanceof GoFile && containingDirectory != null) {
            CompletionResultSet resultSet = result.withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(result.getPrefixMatcher().getPrefix(), false));
            Set<String> allPackageFunctionNames = GoTestFunctionCompletionProvider.collectAllFunctionNames(containingDirectory);
            Set<String> allTestFunctionNames = GoTestFunctionCompletionProvider.collectAllTestNames(allPackageFunctionNames, project, (GoFile)file2);
            String fileNameWithoutTestPrefix = StringUtil.trimEnd((String)file2.getName(), (String)"_test.go") + ".go";
            GoUtil.ExceptTestsScope scope = new GoUtil.ExceptTestsScope(GoPackageUtil.packageScope((GoFile)file2));
            boolean supportsFuzzing = GoSdkService.getInstance(project).getSdk(GoUtil.module((PsiElement)file2)).supportsFuzzing();
            for (String functionName : allPackageFunctionNames) {
                GoFunctionIndex.process(functionName, project, (GlobalSearchScope)scope, null, (Processor<? super GoFunctionDeclaration>)((Processor)declaration -> {
                    GoTestFunctionCompletionProvider.addVariants(declaration, functionName, fileNameWithoutTestPrefix, allTestFunctionNames, resultSet, supportsFuzzing);
                    return false;
                }));
            }
            HashSet methodKeys = new HashSet();
            StubIndex.getInstance().processAllKeys(GoMethodIndex.KEY, new CancellableCollectProcessor(methodKeys), (GlobalSearchScope)scope, null);
            for (String key : methodKeys) {
                Processor processor2 = declaration -> {
                    String typeText = key.substring(Math.min(key.indexOf(46) + 1, key.length()));
                    String methodName = declaration.getName();
                    if (methodName != null) {
                        if (!declaration.isPublic()) {
                            return true;
                        }
                        String lookupString = !typeText.isEmpty() ? StringUtil.capitalize((String)typeText) + "_" + methodName : methodName;
                        GoTestFunctionCompletionProvider.addVariants(declaration, lookupString, fileNameWithoutTestPrefix, allTestFunctionNames, resultSet, supportsFuzzing);
                    }
                    return true;
                };
                GoMethodIndex.process(key, project, (GlobalSearchScope)scope, null, (Processor<? super GoMethodDeclaration>)processor2);
            }
        }
    }

    private static void addVariants(@NotNull GoFunctionOrMethodDeclaration declaration, @NotNull String functionName, @NotNull String fileNameWithoutTestPrefix, @NotNull Set<String> allTestFunctionNames, @NotNull CompletionResultSet resultSet, boolean supportsFuzzing) {
        if (declaration == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(3);
        }
        if (functionName == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(4);
        }
        if (fileNameWithoutTestPrefix == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(5);
        }
        if (allTestFunctionNames == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(6);
        }
        if (resultSet == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(7);
        }
        int priority = fileNameWithoutTestPrefix.equals(declaration.getContainingFile().getName()) ? 5 : 0;
        GoTestFunctionCompletionProvider.addLookupElement("Test" + functionName, priority, allTestFunctionNames, resultSet);
        GoTestFunctionCompletionProvider.addLookupElement("Benchmark" + functionName, priority, allTestFunctionNames, resultSet);
        GoTestFunctionCompletionProvider.addLookupElement("Example" + functionName, priority, allTestFunctionNames, resultSet);
        if (supportsFuzzing) {
            GoTestFunctionCompletionProvider.addLookupElement("Fuzz" + functionName, priority, allTestFunctionNames, resultSet);
        }
    }

    private static void addLookupElement(@NotNull String lookupString, int initialPriority, @NotNull Set<String> allTestFunctionNames, @NotNull CompletionResultSet result) {
        if (lookupString == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(8);
        }
        if (allTestFunctionNames == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(9);
        }
        if (result == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(10);
        }
        int priority = initialPriority;
        if (allTestFunctionNames.contains(lookupString)) {
            priority -= 5;
            lookupString = UniqueNameGenerator.generateUniqueName((String)lookupString, allTestFunctionNames);
        }
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupString).withInsertHandler(GenerateTestInsertHandler.INSTANCE), (double)priority));
    }

    @NotNull
    private static Set<String> collectAllFunctionNames(@NotNull PsiDirectory directory) {
        if (directory == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(11);
        }
        GlobalSearchScope packageScope = GoPackageUtil.packagesScope(GoPackage.in(directory));
        HashSet<String> result = new HashSet<String>();
        StubIndex.getInstance().processAllKeys(GoFunctionIndex.KEY, (Processor)new CancellableCollectProcessor<String>(result){

            protected boolean accept(String s) {
                return !"_".equals(s) && StringUtil.isCapitalized((String)s);
            }
        }, packageScope, null);
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> collectAllTestNames(@NotNull Collection<String> names, @NotNull Project project, @NotNull GoFile file2) {
        if (names == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(15);
        }
        HashSet<String> result = new HashSet<String>();
        GlobalSearchScope packageScope = GoPackageUtil.packageScope(file2);
        GoUtil.TestsScope scope = new GoUtil.TestsScope(packageScope);
        for (String name : names) {
            if (GoTestFunctionType.fromName(name) == null) continue;
            GoFunctionIndex.process(name, project, (GlobalSearchScope)scope, null, (Processor<? super GoFunctionDeclaration>)((Processor)declaration -> {
                result.add(name);
                return false;
            }));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    private static void finishFuncTemplateIfNeeded(@NotNull InsertionContext context) {
        TemplateManager templateManager;
        Template template;
        if (context == null) {
            GoTestFunctionCompletionProvider.$$$reportNull$$$0(17);
        }
        if ((template = (templateManager = TemplateManager.getInstance((Project)context.getProject())).getActiveTemplate(context.getEditor())) != null && "go_lang_func".equals(template.getKey())) {
            templateManager.finishTemplate(context.getEditor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutTestPrefix";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTestFunctionNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoTestFunctionCompletionProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoTestFunctionCompletionProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllFunctionNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllTestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLookupElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAllFunctionNames";
                break;
            }
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAllTestNames";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "finishFuncTemplateIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 16 -> new IllegalStateException(string);
        };
    }

    private static class GenerateTestInsertHandler
    implements InsertHandler<LookupElement> {
        public static final InsertHandler<LookupElement> INSTANCE = new GenerateTestInsertHandler();

        private GenerateTestInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            PsiElement elementAt;
            GoFunctionOrMethodDeclaration declaration;
            if (context == null) {
                GenerateTestInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                GenerateTestInsertHandler.$$$reportNull$$$0(1);
            }
            if ((declaration = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)(elementAt = context.getFile().findElementAt(context.getStartOffset())), (Class[])new Class[]{GoFunctionOrMethodDeclaration.class})) != null) {
                GoTestFunctionCompletionProvider.finishFuncTemplateIfNeeded(context);
                GoTestFunctionType testingType = GoTestFunctionType.fromName(declaration.getName());
                if (testingType != null) {
                    GoBlock block;
                    String testingQualifier = null;
                    if (testingType.getParamType() != null) {
                        testingQualifier = GoGenerateTestActionBase.importTestingPackageIfNeeded(declaration.getContainingFile());
                    }
                    if ((block = declaration.getBlock()) == null) {
                        block = (GoBlock)declaration.add(GoElementFactory.createBlock(context.getProject()));
                    } else if (ContainerUtil.and(block.getStatementList(), it -> it instanceof GoEmptyStatement)) {
                        block = (GoBlock)block.replace(GoElementFactory.createBlock(context.getProject()));
                    }
                    GoSignature newSignature = GoElementFactory.createFunctionSignatureFromText(context.getProject(), "", testingType.getSignature(testingQualifier));
                    GoSignature signature = declaration.getSignature();
                    if (signature == null) {
                        declaration.addBefore(newSignature, block);
                    } else if (signature.getParameters().getParameterDeclarationList().isEmpty()) {
                        signature.replace(newSignature);
                    }
                    TemplateManager templateManager = TemplateManager.getInstance((Project)context.getProject());
                    Template template = templateManager.getActiveTemplate(context.getEditor());
                    if (template != null) {
                        return;
                    }
                    Document document = context.getDocument();
                    PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    GoStatement firstStatement = (GoStatement)ContainerUtil.getFirstItem(block.getStatementList());
                    if (firstStatement != null) {
                        context.getEditor().getCaretModel().moveToOffset(firstStatement.getTextRange().getStartOffset());
                    } else {
                        int lbraceEndOffset;
                        int startLine;
                        PsiElement lbrace = block.getLbrace();
                        PsiElement rbrace = block.getRbrace();
                        int endLine = rbrace != null ? document.getLineNumber(rbrace.getTextRange().getStartOffset()) : startLine;
                        int lineDiff = endLine - (startLine = document.getLineNumber(lbraceEndOffset = lbrace.getTextRange().getEndOffset()));
                        if (lineDiff < 2) {
                            document.insertString(lbraceEndOffset, (CharSequence)StringUtil.repeat((String)"\n", (int)(2 - lineDiff)));
                        }
                        int offsetToMove = document.getLineStartOffset(startLine + 1);
                        context.getEditor().getCaretModel().moveToOffset(offsetToMove);
                        CodeStyleManager.getInstance((Project)context.getProject()).adjustLineIndent(document, offsetToMove);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoTestFunctionCompletionProvider$GenerateTestInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

