/*
 * Decompiled with CFR 0.152.
 */
package com.goide.configuration;

import com.goide.configuration.GoLibrariesConfigurableUi;
import com.goide.i18n.GoBundle;
import com.goide.project.GoLibrariesService;
import com.goide.project.GoProjectLibrariesService;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GoLibrariesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    @Nls
    private final String myDisplayName;
    private final GoLibrariesService<?> myLibrariesService;
    private final CollectionListModel<ListItem> myListModel;
    private Consumer<? super Boolean> myUseEnvGoPathCheckBoxValueConsumer;
    private final GoLibrariesConfigurableUi ui;
    private boolean modifyingReadOnlyItems;

    public GoLibrariesConfigurable(@Nls @NotNull String displayName, @NotNull GoLibrariesService<?> librariesService) {
        if (displayName == null) {
            GoLibrariesConfigurable.$$$reportNull$$$0(0);
        }
        if (librariesService == null) {
            GoLibrariesConfigurable.$$$reportNull$$$0(1);
        }
        this.myListModel = new CollectionListModel((Object[])new ListItem[0]);
        this.myDisplayName = displayName;
        this.myLibrariesService = librariesService;
        JBList filesList = new JBList(this.myListModel);
        filesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<ListItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ListItem> list, ListItem value2, int index, boolean selected, boolean hasFocus) {
                VirtualFile file2;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2.readOnly) {
                    if (value2.defaultPath) {
                        this.append(GoBundle.message((String)"go.libraries.configurable.path.source.prefix.default", (Object[])new Object[0]) + " ", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    } else {
                        this.append(GoBundle.message((String)"go.libraries.configurable.path.source.prefix.gopath", (Object[])new Object[0]) + " ", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
                if ((file2 = VirtualFileManager.getInstance().findFileByUrl(value2.url)) != null) {
                    this.append(file2.getPresentableUrl(), value2.readOnly ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(IconUtil.getIcon((VirtualFile)file2, (int)2, null));
                } else {
                    this.append(VfsUtilCore.urlToPath((String)value2.url), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/goide/configuration/GoLibrariesConfigurable$1", "customizeCellRenderer"));
            }
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)filesList).setAddAction(button -> {
            VirtualFile[] newDirectories;
            FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), null, (Component)filesList);
            VirtualFile fileToSelect = null;
            ListItem lastItem = (ListItem)ContainerUtil.getLastItem((List)this.myListModel.getItems());
            if (lastItem != null) {
                fileToSelect = VirtualFileManager.getInstance().findFileByUrl(lastItem.url);
            }
            for (VirtualFile newDirectory : newDirectories = fileChooser.choose(null, new VirtualFile[]{fileToSelect})) {
                String newDirectoryUrl = newDirectory.getUrl();
                boolean alreadyAdded = false;
                for (ListItem item : this.myListModel.getItems()) {
                    if (!newDirectoryUrl.equals(item.url) || item.readOnly) continue;
                    filesList.clearSelection();
                    filesList.setSelectedValue((Object)item, true);
                    GoLibrariesConfigurable.scrollToSelection(filesList);
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                this.myListModel.add((Object)new ListItem(newDirectoryUrl, false, false));
            }
        }).setRemoveActionUpdater(event -> {
            for (ListItem selectedValue : filesList.getSelectedValuesList()) {
                if (!selectedValue.readOnly) continue;
                return false;
            }
            return true;
        }).setRemoveAction(button -> {
            for (ListItem selectedValue : filesList.getSelectedValuesList()) {
                this.myListModel.remove((Object)selectedValue);
            }
        });
        this.ui = new GoLibrariesConfigurableUi(decorator, librariesService);
        this.ui.useEnvGoPathCheckBox.addActionListener(e -> {
            if (this.myUseEnvGoPathCheckBoxValueConsumer != null) {
                this.myUseEnvGoPathCheckBoxValueConsumer.accept((Boolean)this.ui.useEnvGoPathCheckBox.isSelected());
            }
        });
    }

    private static void scrollToSelection(JList<?> list) {
        int selectedRow = list.getSelectedIndex();
        if (selectedRow >= 0) {
            list.scrollRectToVisible(list.getCellBounds(selectedRow, 0));
        }
    }

    @Nullable
    public JComponent createComponent() {
        return this.ui.panel;
    }

    public boolean isModified() {
        return !this.getUserDefinedUrls().equals(this.myLibrariesService.getLibraryRootUrls()) || this.myLibrariesService instanceof GoProjectLibrariesService && (((GoProjectLibrariesService)this.myLibrariesService).isIndexEntireGopath() != this.ui.indexEntireGoPathCheckBox.isSelected() || ((GoProjectLibrariesService)this.myLibrariesService).isUseGoPathFromSystemEnvironment() != this.ui.useEnvGoPathCheckBox.isSelected());
    }

    public void apply() {
        this.myLibrariesService.setLibraryRootUrls(this.getUserDefinedUrls());
        if (this.myLibrariesService instanceof GoProjectLibrariesService) {
            ((GoProjectLibrariesService)this.myLibrariesService).setUseGoPathFromSystemEnvironment(this.ui.useEnvGoPathCheckBox.isSelected());
            ((GoProjectLibrariesService)this.myLibrariesService).setIndexEntireGopath(this.ui.indexEntireGoPathCheckBox.isSelected());
        }
    }

    public void reset() {
        List toRemove = ContainerUtil.filter((Collection)this.myListModel.getItems(), item -> !item.readOnly);
        for (ListItem item2 : toRemove) {
            this.myListModel.remove((Object)item2);
        }
        if (this.myLibrariesService instanceof GoProjectLibrariesService) {
            boolean indexEntireGoPath;
            boolean value2 = ((GoProjectLibrariesService)this.myLibrariesService).isUseGoPathFromSystemEnvironment();
            if (value2 != this.ui.useEnvGoPathCheckBox.isSelected()) {
                if (this.myUseEnvGoPathCheckBoxValueConsumer != null) {
                    this.myUseEnvGoPathCheckBoxValueConsumer.accept((Boolean)value2);
                }
                this.ui.useEnvGoPathCheckBox.setSelected(value2);
            }
            if ((indexEntireGoPath = ((GoProjectLibrariesService)this.myLibrariesService).isIndexEntireGopath()) != this.ui.indexEntireGoPathCheckBox.isSelected()) {
                this.ui.indexEntireGoPathCheckBox.setSelected(indexEntireGoPath);
            }
        }
        for (String url : this.myLibrariesService.getLibraryRootUrls()) {
            this.myListModel.add((Object)new ListItem(url, false, false));
        }
    }

    public @Unmodifiable List<ListItem> getReadOnlyUrls(boolean defaultUrls) {
        return ContainerUtil.filter((Collection)this.myListModel.getItems(), item -> item.readOnly && item.defaultPath == defaultUrls);
    }

    public void addReadOnlyUrls(List<String> urls, boolean defaultUrls) {
        this.modifyingReadOnlyItems = true;
        this.myListModel.addAll(0, ContainerUtil.map(urls, url -> new ListItem((String)url, defaultUrls, true)));
        this.modifyingReadOnlyItems = false;
    }

    public void removeReadOnlyUrls(boolean defaultUrls) {
        List<ListItem> toRemove = this.getReadOnlyUrls(defaultUrls);
        this.modifyingReadOnlyItems = true;
        for (ListItem item : toRemove) {
            this.myListModel.remove((Object)item);
        }
        this.modifyingReadOnlyItems = false;
    }

    public void addPathsChangeListener(final @NotNull Runnable pathsChangeListener) {
        if (pathsChangeListener == null) {
            GoLibrariesConfigurable.$$$reportNull$$$0(2);
        }
        this.myListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                if (!GoLibrariesConfigurable.this.modifyingReadOnlyItems) {
                    pathsChangeListener.run();
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (!GoLibrariesConfigurable.this.modifyingReadOnlyItems) {
                    pathsChangeListener.run();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (!GoLibrariesConfigurable.this.modifyingReadOnlyItems) {
                    pathsChangeListener.run();
                }
            }
        });
    }

    public void setUseGoPathCheckBoxValueConsumer(@NotNull Consumer<? super Boolean> useGoPathStateConsumer) {
        if (useGoPathStateConsumer == null) {
            GoLibrariesConfigurable.$$$reportNull$$$0(3);
        }
        this.myUseEnvGoPathCheckBoxValueConsumer = useGoPathStateConsumer;
    }

    public void disposeUIResources() {
        UIUtil.dispose((Component)this.ui.useEnvGoPathCheckBox);
        UIUtil.dispose((Component)this.ui.panel);
        for (ListDataListener listener2 : this.myListModel.getListDataListeners()) {
            this.myListModel.removeListDataListener(listener2);
        }
        this.myListModel.removeAll();
    }

    @NotNull
    @Nls
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            GoLibrariesConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "Configuring_GOROOT_and_GOPATH";
    }

    @NotNull
    public Collection<String> getUserDefinedUrls() {
        ArrayList<String> libraryUrls = new ArrayList<String>();
        for (ListItem item : this.myListModel.getItems()) {
            if (item.readOnly) continue;
            libraryUrls.add(item.url);
        }
        ArrayList<String> arrayList = libraryUrls;
        if (arrayList == null) {
            GoLibrariesConfigurable.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public String getId() {
        return "go.libraries";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsChangeListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useGoPathStateConsumer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/configuration/GoLibrariesConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/configuration/GoLibrariesConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPathsChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUseGoPathCheckBoxValueConsumer";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class ListItem {
        private final boolean defaultPath;
        final boolean readOnly;
        final String url;

        private ListItem(String url, boolean defaultPath, boolean readOnly) {
            this.readOnly = readOnly;
            this.url = url;
            this.defaultPath = defaultPath;
        }
    }
}

