/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.inspections;

import com.goide.dfa.GoDfaConfig;
import com.goide.dfa.GoDfaConfigGlobal;
import com.goide.dfa.symbolicExecution.interpreter.GoDfaResourceLeakAnalysisKt;
import com.goide.dfa.translator.GoFunctionPsiToIrTranslator;
import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/goide/dfa/inspections/GoResourceLeakInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "disableInTests", "", "getDisableInTests", "()Z", "setDisableInTests", "(Z)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "intellij.go.dfa"})
public final class GoResourceLeakInspection
extends GoInspectionBase {
    private boolean disableInTests = true;

    public final boolean getDisableInTests() {
        return this.disableInTests;
    }

    public final void setDisableInTests(boolean bl) {
        this.disableInTests = bl;
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoResourceLeakInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunctionDeclaration(GoFunctionDeclaration o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitFunctionDeclaration(o);
                if (this.this$0.getDisableInTests() && GoTestFinder.isTestFile(o.getContainingFile())) {
                    return;
                }
                GoDfaConfigGlobal config = GoDfaConfig.Companion.getGlobal();
                GoFunctionPsiToIrTranslator translator = new GoFunctionPsiToIrTranslator(config, false);
                IrFunctionDecl irFunctionDecl = translator.translateAndPerformTransformStages(o);
                if (irFunctionDecl == null) {
                    return;
                }
                IrFunctionDecl irFunction = irFunctionDecl;
                PsiFile psiFile = o.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                Set<IrLocation> resourceLeaks = GoDfaResourceLeakAnalysisKt.inferResourceLeaks(irFunction, (GoFile)psiFile, false);
                for (IrLocation loc : resourceLeaks) {
                    PsiElement element;
                    if (PsiTreeUtil.findElementOfClassAtRange((PsiFile)o.getContainingFile(), (int)loc.getOffset1(), (int)loc.getOffset2(), PsiElement.class) == null) {
                        throw new IllegalStateException("Unable to get psi element for location " + loc);
                    }
                    this.$holder.registerProblem(element, GoInspectionProblemUtil.message("go.inspection.potential.resource.leak.message"), new LocalQuickFix[0]);
                }
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"disableInTests", (String)GoBundle.message((String)"go.inspection.dfa.potential.resource.leak.settings.disable.in.tests.checkbox", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }
}

