/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvFunc;
import com.goide.dlv.DlvNamedType;
import com.goide.dlv.DlvPackagePath;
import com.goide.dlv.DlvStackFuncName;
import com.goide.dlv.DlvUtil;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.psi.GoFile;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DlvSymbolPrettier {
    private final Project myProject;
    private final Module myModule;
    private final XDebugSession mySession;
    private final ConcurrentMap<String, String> myPrettyTypesCache;
    private final ConcurrentMap<DlvPackagePath, Set<String>> myPackageNames;
    private final ConcurrentMap<String, DlvStackFuncName> myFunctionsCache;

    DlvSymbolPrettier(@NotNull XDebugSession session) {
        if (session == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(0);
        }
        this.myPrettyTypesCache = new ConcurrentHashMap<String, String>();
        this.myPackageNames = new ConcurrentHashMap<DlvPackagePath, Set<String>>();
        this.myFunctionsCache = new ConcurrentHashMap<String, DlvStackFuncName>();
        this.myProject = session.getProject();
        this.myModule = DlvUtil.getModule(session);
        this.mySession = session;
    }

    @RequiresBackgroundThread
    @NotNull
    DlvStackFuncName prettifyFunc(@NotNull String dlvFunc) {
        if (dlvFunc == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertBackgroundThread();
        DlvStackFuncName dlvStackFuncName = this.myFunctionsCache.computeIfAbsent(dlvFunc, __ -> this.doPrettifyFunc(dlvFunc));
        if (dlvStackFuncName == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(2);
        }
        return dlvStackFuncName;
    }

    @NotNull
    private DlvStackFuncName doPrettifyFunc(@NotNull String dlvFuncString) {
        DlvFunc dlvFunc;
        if (dlvFuncString == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(3);
        }
        if ((dlvFunc = DlvFunc.parse(dlvFuncString)) == null) {
            return new DlvStackFuncName(dlvFuncString, "");
        }
        Set<String> pkgNames = this.getPackageNames(dlvFunc.getDlvPackagePath());
        String pkgName = (String)ContainerUtil.getOnlyItem(pkgNames);
        if (pkgName != null) {
            return new DlvStackFuncName(pkgName + "." + dlvFunc.getName(), dlvFunc.getDlvPackagePath().getPackagePath());
        }
        return new DlvStackFuncName(dlvFuncString, "");
    }

    @RequiresBackgroundThread
    @NotNull
    String prettifyType(@NotNull String dlvType) {
        if (dlvType == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertBackgroundThread();
        String string = this.myPrettyTypesCache.computeIfAbsent(dlvType, __ -> this.doPrettifyType(dlvType));
        if (string == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String doPrettifyType(@NotNull String dlvType) {
        String typeForEditor;
        if (dlvType == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(6);
        }
        if ((typeForEditor = DlvSymbolPrettier.prepareTypeForEditor(dlvType)) == null || typeForEditor.length() != dlvType.length()) {
            String string = dlvType;
            if (string == null) {
                DlvSymbolPrettier.$$$reportNull$$$0(7);
            }
            return string;
        }
        GoType type = GoElementFactory.createType(this.myProject, typeForEditor, null);
        if (type == null || !typeForEditor.equals(type.getText())) {
            String string = dlvType;
            if (string == null) {
                DlvSymbolPrettier.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (!(type instanceof GoStructType) && !(type instanceof GoInterfaceType)) {
            List<GoTypeReferenceExpression> references = DlvSymbolPrettier.getTypeReferences(type);
            int typeStart = type.getTextRange().getStartOffset();
            for (GoTypeReferenceExpression ref : references) {
                if (this.replaceWithShortReference(dlvType, ref, typeStart)) continue;
                String string = dlvType;
                if (string == null) {
                    DlvSymbolPrettier.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        String string = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().withoutParameterNames().oneline().build(type);
        if (string == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(10);
        }
        return string;
    }

    private boolean replaceWithShortReference(@NotNull String dlvType, @NotNull GoTypeReferenceExpression typeRef, int typeStart) {
        if (dlvType == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(11);
        }
        if (typeRef == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(12);
        }
        TextRange range = typeRef.getTextRange().shiftLeft(typeStart);
        if (!TextRange.from((int)0, (int)dlvType.length()).contains(range)) {
            return false;
        }
        String origDlvType = range.substring(dlvType);
        if (origDlvType.equals(typeRef.getText())) {
            return true;
        }
        DlvNamedType dlvNamedType = DlvNamedType.parse(origDlvType);
        if (dlvNamedType == null) {
            return false;
        }
        Set<String> pkgNames = this.getPackageNames(dlvNamedType.getDlvPackagePath());
        String pkgName = (String)ContainerUtil.getOnlyItem(pkgNames);
        if (pkgName == null) {
            return false;
        }
        String text = "package p; var a = " + pkgName + "." + dlvNamedType.getTypeName() + "{}";
        GoTypeReferenceExpression updatedRef = GoElementFactory.createElement(this.myProject, text, GoTypeReferenceExpression.class);
        if (updatedRef == null) {
            return false;
        }
        try {
            typeRef.replace(updatedRef);
            return true;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public Set<String> getPackageNames(@NotNull DlvPackagePath dlvPackagePath) {
        if (dlvPackagePath == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (DumbService.isDumb((Project)this.myProject)) {
            Set<String> set = Set.of();
            if (set == null) {
                DlvSymbolPrettier.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set set = this.myPackageNames.computeIfAbsent(dlvPackagePath, __ -> this.computePackageNames(dlvPackagePath));
        if (set == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    private Set<String> computePackageNames(@NotNull DlvPackagePath dlvPackagePath) {
        GoTestRunConfiguration runConfiguration;
        String packagePath;
        if (dlvPackagePath == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)(packagePath = dlvPackagePath.getPackagePath()))) {
            Set<String> set = Set.of();
            if (set == null) {
                DlvSymbolPrettier.$$$reportNull$$$0(17);
            }
            return set;
        }
        if ("main".equals(packagePath) && !dlvPackagePath.isTestPackage()) {
            Set<String> set = Set.of("main");
            if (set == null) {
                DlvSymbolPrettier.$$$reportNull$$$0(18);
            }
            return set;
        }
        if ("command-line-arguments".equals(packagePath) && (runConfiguration = (GoTestRunConfiguration)((Object)ObjectUtils.tryCast((Object)this.mySession.getRunProfile(), GoTestRunConfiguration.class))) != null && runConfiguration.getKind() == GoBuildingRunConfiguration.Kind.FILE) {
            List<String> paths = runConfiguration.getFilePaths();
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            TreeSet<String> result = new TreeSet<String>();
            for (String path : paths) {
                VirtualFile vfile = VirtualFileManager.getInstance().findFileByNioPath(Path.of(path, new String[0]));
                GoFile file2 = (GoFile)((Object)ObjectUtils.tryCast((Object)(vfile != null ? psiManager.findFile(vfile) : null), GoFile.class));
                String packageName = file2 != null ? file2.getPackageName() : null;
                if (packageName == null) continue;
                result.add(packageName);
            }
            TreeSet<String> treeSet = result;
            if (treeSet == null) {
                DlvSymbolPrettier.$$$reportNull$$$0(19);
            }
            return treeSet;
        }
        Collection<GoPackage> packages = GoPackageUtil.findByImportPath(packagePath, this.myProject, this.myModule, ResolveState.initial());
        List packageNames = ContainerUtil.map(packages, p -> p.getName() + (dlvPackagePath.isTestPackage() ? "_test" : ""));
        return new TreeSet<String>(packageNames);
    }

    @NotNull
    private static List<GoTypeReferenceExpression> getTypeReferences(@NotNull GoType type) {
        if (type == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(20);
        }
        List result = ((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)type)).filter(GoTypeReferenceExpression.class).toList();
        List list = result = ContainerUtil.sorted((Collection)result, (o1, o2) -> Integer.compare(o2.getTextRange().getStartOffset(), o1.getTextRange().getStartOffset()));
        if (list == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    private static String prepareTypeForEditor(@NotNull String dlvType) {
        if (dlvType == null) {
            DlvSymbolPrettier.$$$reportNull$$$0(22);
        }
        String keep = "*{}[]() ,;";
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < dlvType.length(); ++i) {
            char c = dlvType.charAt(i);
            if (GoUtil.isValidGoIdentifierCharacter(c)) {
                result.append(c);
                continue;
            }
            if (keep.indexOf(c) >= 0) {
                result.append(c);
                continue;
            }
            if (c == '<') {
                boolean startOfArrow;
                boolean bl = startOfArrow = i < dlvType.length() - 1 && dlvType.charAt(i + 1) == '-';
                if (startOfArrow) {
                    result.append(c);
                    result.append(dlvType.charAt(i + 1));
                    ++i;
                    continue;
                }
                return null;
            }
            result.append('_');
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 8, 9, 10, 14, 15, 17, 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dlvFunc";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvSymbolPrettier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dlvFuncString";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dlvType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRef";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dlvPackagePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvSymbolPrettier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prettifyFunc";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prettifyType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doPrettifyType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computePackageNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prettifyFunc";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doPrettifyFunc";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prettifyType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doPrettifyType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithShortReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computePackageNames";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeReferences";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareTypeForEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 8, 9, 10, 14, 15, 17, 18, 19, 21 -> new IllegalStateException(string);
        };
    }
}

