/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.dump;

import com.goide.dlv.dump.DlvStack;
import com.goide.dlv.dump.IntTable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DlvStackIndex {
    private static int ourMinTableSize = 100;
    private final IntTable<String> myFuncTable;
    private final IntTable<String> myFileTable;
    private final IntTable<DlvStack> myStackTable;

    DlvStackIndex(@Nullable DlvStackIndex base) {
        this.myFuncTable = DlvStackIndex.createTable(base != null ? base.myFuncTable : null);
        this.myFileTable = DlvStackIndex.createTable(base != null ? base.myFileTable : null);
        this.myStackTable = DlvStackIndex.createTable(base != null ? base.myStackTable : null);
    }

    int addFuncIfAbsent(@Nullable String func) {
        return this.myFuncTable.addIfAbsent(func);
    }

    int addFileIfAbsent(@Nullable String file2) {
        return this.myFileTable.addIfAbsent(file2);
    }

    int addStackIfAbsent(@Nullable DlvStack stack) {
        return this.myStackTable.addIfAbsent(stack);
    }

    @Nullable
    String getFuncName(int funcId) {
        return this.myFuncTable.get(funcId);
    }

    @Nullable
    String getFile(int fileId) {
        return this.myFileTable.get(fileId);
    }

    @Nullable
    DlvStack getStack(int stackId) {
        return this.myStackTable.get(stackId);
    }

    @NotNull
    static <T> IntTable<T> createTable(@Nullable IntTable<T> base) {
        if ((base = DlvStackIndex.findNonEmpty(base)) == null) {
            return new IntTable(null);
        }
        List<T> baseOwnValues = base.getOwnValues();
        if (baseOwnValues.size() >= ourMinTableSize) {
            return new IntTable<T>(base);
        }
        IntTable<T> result = new IntTable<T>(base.getBase());
        for (T value2 : base.getOwnValues()) {
            result.addIfAbsent(value2);
        }
        IntTable<T> intTable = result;
        if (intTable == null) {
            DlvStackIndex.$$$reportNull$$$0(0);
        }
        return intTable;
    }

    @Nullable
    private static <T> IntTable<T> findNonEmpty(@Nullable IntTable<T> table) {
        while (table != null) {
            if (!table.getOwnValues().isEmpty()) {
                return table;
            }
            table = table.getBase();
        }
        return null;
    }

    public static int getMinTableSize() {
        return ourMinTableSize;
    }

    public static void setMinTableSize(int minTableSize) {
        ourMinTableSize = minTableSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/dlv/dump/DlvStackIndex", "createTable"));
    }
}

