/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTopLevelDeclaration;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStatementMover
extends LineMover {
    private static final Logger LOGGER = Logger.getInstance(GoStatementMover.class);

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement commonParent;
        if (editor == null) {
            GoStatementMover.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GoStatementMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            GoStatementMover.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof GoFile) || !super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        Couple<PsiElement> primeElementRange = GoStatementMover.getElementRange(editor, file2);
        if (primeElementRange == null) {
            return false;
        }
        PsiElement psiElement = commonParent = ((PsiElement)primeElementRange.first).isEquivalentTo((PsiElement)primeElementRange.second) ? ((PsiElement)primeElementRange.first).getParent() : PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)primeElementRange.first), (PsiElement)((PsiElement)primeElementRange.second));
        if (commonParent == null || PsiTreeUtil.hasErrorElements((PsiElement)commonParent)) {
            return false;
        }
        Couple elementRange = GoStatementMover.getTopmostElementRange(primeElementRange, commonParent);
        if (elementRange == null) {
            return false;
        }
        if (commonParent == elementRange.first) {
            commonParent = commonParent.getParent();
        }
        info.toMove = GoStatementMover.createLineRange((PsiElement)elementRange.first, (PsiElement)elementRange.second);
        if (GoStatementMover.containsPackage(elementRange, commonParent)) {
            info.toMove2 = null;
            return true;
        }
        if (commonParent instanceof GoSwitchStatement) {
            PsiElement toMove2 = GoStatementMover.getNeighborOfType(elementRange, GoCaseClause.class, down);
            info.toMove2 = toMove2 != null ? GoStatementMover.createLineRange(toMove2) : null;
            return true;
        }
        if (commonParent instanceof GoImportList) {
            PsiElement toMove2 = GoStatementMover.getNeighborOfType(elementRange, GoImportDeclaration.class, down);
            info.toMove2 = toMove2 != null ? GoStatementMover.createLineRange(toMove2) : null;
            return true;
        }
        if (!GoStatementMover.containsCommentsOnly(elementRange, commonParent) && commonParent instanceof GoArgumentList) {
            PsiElement toMove2 = GoStatementMover.getNeighborOfType(elementRange, GoCompositeElement.class, down);
            info.toMove2 = toMove2 != null ? GoStatementMover.createLineRange(toMove2) : null;
            return true;
        }
        GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)commonParent, GoStructType.class, (boolean)false);
        if (struct != null) {
            PsiElement toMove2;
            if (!(elementRange.first instanceof GoFieldDeclaration)) {
                PsiElement first = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elementRange.first), GoFieldDeclaration.class);
                PsiElement second = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elementRange.second), GoFieldDeclaration.class);
                elementRange = Couple.of((Object)first, (Object)second);
            }
            info.toMove2 = (toMove2 = GoStatementMover.getNeighborOfType(elementRange, GoFieldDeclaration.class, down)) != null ? GoStatementMover.createLineRange(toMove2) : null;
            return true;
        }
        if (!GoStatementMover.containsCommentsOnly(elementRange, commonParent) && ((PsiElement)elementRange.first).getParent() instanceof GoFile) {
            PsiElement toMove2 = GoStatementMover.getNeighborOfType(elementRange, GoTopLevelDeclaration.class, down);
            info.toMove2 = toMove2 != null ? GoStatementMover.createLineRange(toMove2) : null;
            return true;
        }
        GoStatementMover.setUpInfoToMoveInTopLevelDeclaration(file2, editor, info, elementRange, commonParent, down);
        return true;
    }

    private static Couple<PsiElement> getElementRange(@NotNull Editor editor, @NotNull PsiFile file2) {
        Pair primeElementRangePair;
        if (editor == null) {
            GoStatementMover.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GoStatementMover.$$$reportNull$$$0(4);
        }
        if ((primeElementRangePair = GoStatementMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)GoStatementMover.getLineRangeFromSelection((Editor)editor))) == null) {
            return null;
        }
        LeafElement firstNode = TreeUtil.findFirstLeaf((ASTNode)((PsiElement)primeElementRangePair.first).getNode());
        ASTNode lastNode = TreeUtil.findLastLeaf((ASTNode)((PsiElement)primeElementRangePair.second).getNode());
        if (firstNode == null || lastNode == null) {
            return null;
        }
        return Couple.of((Object)firstNode.getPsi(), (Object)lastNode.getPsi());
    }

    @Nullable
    private static Couple<PsiElement> getTopmostElementRange(@NotNull Couple<PsiElement> elementRange, @NotNull PsiElement commonParent) {
        if (elementRange == null) {
            GoStatementMover.$$$reportNull$$$0(5);
        }
        if (commonParent == null) {
            GoStatementMover.$$$reportNull$$$0(6);
        }
        if (elementRange.first == null || elementRange.second == null) {
            return null;
        }
        int startOfVeryFirstElement = GoStatementMover.skipWhitespaceAndCommentsBackward((PsiElement)elementRange.first).getTextRange().getStartOffset();
        int endOfVeryLastElement = GoStatementMover.skipWhitespaceAndCommentsForward((PsiElement)elementRange.second).getTextRange().getEndOffset();
        TextRange range = commonParent.getTextRange();
        PsiElement[] children = commonParent.getChildren();
        if (commonParent.isEquivalentTo((PsiElement)elementRange.first) || commonParent.isEquivalentTo((PsiElement)elementRange.second) || range.getStartOffset() >= startOfVeryFirstElement && (children.length == 0 || children[0].getTextRange().getStartOffset() > startOfVeryFirstElement) || range.getEndOffset() <= endOfVeryLastElement && (children.length == 0 || children[children.length - 1].getTextRange().getEndOffset() < endOfVeryLastElement)) {
            return Couple.of((Object)commonParent, (Object)commonParent);
        }
        int start = ((PsiElement)elementRange.first).getTextRange().getStartOffset();
        int end = ((PsiElement)elementRange.second).getTextRange().getEndOffset();
        PsiElement startElement = (PsiElement)elementRange.first;
        PsiElement endElement = (PsiElement)elementRange.second;
        for (PsiElement element : children) {
            range = element.getTextRange();
            if (range.contains(start) && !range.contains(end)) {
                startElement = element;
            }
            if (!range.contains(end - 1) || range.contains(start - 1)) continue;
            endElement = element;
        }
        return startElement.getParent().isEquivalentTo(endElement.getParent()) ? Couple.of((Object)startElement, (Object)endElement) : null;
    }

    @NotNull
    private static PsiElement skipWhitespaceAndCommentsBackward(@NotNull PsiElement element) {
        if (element == null) {
            GoStatementMover.$$$reportNull$$$0(7);
        }
        PsiElement result = element;
        PsiElement prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
        while (prevVisibleLeaf instanceof PsiComment) {
            result = prevVisibleLeaf;
            prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)prevVisibleLeaf);
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            GoStatementMover.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement skipWhitespaceAndCommentsForward(@NotNull PsiElement element) {
        if (element == null) {
            GoStatementMover.$$$reportNull$$$0(9);
        }
        PsiElement result = element;
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        while (nextVisibleLeaf instanceof PsiComment) {
            result = nextVisibleLeaf;
            nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextVisibleLeaf);
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            GoStatementMover.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    private static void setUpInfoToMoveInTopLevelDeclaration(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Couple<PsiElement> range, @NotNull PsiElement commonParent, boolean down) {
        int endLine;
        if (file2 == null) {
            GoStatementMover.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            GoStatementMover.$$$reportNull$$$0(12);
        }
        if (info == null) {
            GoStatementMover.$$$reportNull$$$0(13);
        }
        if (range == null) {
            GoStatementMover.$$$reportNull$$$0(14);
        }
        if (commonParent == null) {
            GoStatementMover.$$$reportNull$$$0(15);
        }
        info.toMove = GoStatementMover.createLineRange((PsiElement)range.first, (PsiElement)range.second);
        if (range.first instanceof GoPackageClause) {
            info.toMove2 = null;
            return;
        }
        boolean containsCommentsOnly = GoStatementMover.containsCommentsOnly(range, commonParent);
        int mostDistantLineToMove = GoStatementMover.getMostDistantLineToMove(file2, editor, info, down, containsCommentsOnly);
        PsiElement topLevelDeclaration = commonParent instanceof GoFile || commonParent instanceof GoLiteralValue || commonParent instanceof GoSwitchStatement ? commonParent : PsiTreeUtil.findPrevParent((PsiElement)commonParent.getContainingFile(), (PsiElement)commonParent);
        int startLine = down ? info.toMove.endLine : mostDistantLineToMove;
        int n = endLine = down ? mostDistantLineToMove + 1 : info.toMove.startLine;
        info.toMove2 = containsCommentsOnly || GoStatementMover.createLineRange(topLevelDeclaration).containsLine(down ? endLine : startLine - 1) ? new LineRange(startLine, endLine) : null;
    }

    private static int getMostDistantLineToMove(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down, boolean containsCommentsOnly) {
        TextRange statementRange;
        int offset;
        if (file2 == null) {
            GoStatementMover.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            GoStatementMover.$$$reportNull$$$0(17);
        }
        if (info == null) {
            GoStatementMover.$$$reportNull$$$0(18);
        }
        Document document = editor.getDocument();
        int distantLine = down ? info.toMove.endLine - 1 : info.toMove.startLine;
        do {
            if ((distantLine += down ? 1 : -1) < 0 || distantLine >= document.getLineCount()) {
                LOGGER.error("Cannot move line (down: " + down + ", offset: " + editor.getCaretModel().getOffset() + ")", new Attachment[]{CoreAttachmentFactory.createAttachment((Document)document)});
            }
            offset = down ? document.getLineEndOffset(distantLine) : document.getLineStartOffset(distantLine);
            PsiElement at = file2.findElementAt(offset);
            GoBlock block = (GoBlock)PsiTreeUtil.getParentOfType((PsiElement)at, GoBlock.class);
            PsiElement statement = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])new Class[]{GoStatement.class, GoLiteralValue.class, GoFunctionLit.class});
            if (statement == null || statement instanceof GoSwitchStatement || statement instanceof GoSelectStatement || statement instanceof GoLiteralValue || block != null && block.getParent() == statement) break;
            statementRange = statement.getTextRange();
        } while (offset != (down ? statementRange.getEndOffset() : statementRange.getStartOffset()) && !containsCommentsOnly);
        return distantLine;
    }

    @Nullable
    private static PsiElement getNeighborOfType(@NotNull Couple<PsiElement> range, @NotNull Class<? extends PsiElement> clazz, boolean rightNeighbor) {
        if (range == null) {
            GoStatementMover.$$$reportNull$$$0(19);
        }
        if (clazz == null) {
            GoStatementMover.$$$reportNull$$$0(20);
        }
        return rightNeighbor ? PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)range.second), clazz) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)((PsiElement)range.first), clazz);
    }

    private static boolean containsCommentsOnly(@NotNull Couple<PsiElement> range, @NotNull PsiElement commonParent) {
        if (range == null) {
            GoStatementMover.$$$reportNull$$$0(21);
        }
        if (commonParent == null) {
            GoStatementMover.$$$reportNull$$$0(22);
        }
        boolean check = false;
        for (ASTNode node2 : commonParent.getNode().getChildren(null)) {
            PsiElement child = node2.getPsi();
            if (range.first == child) {
                check = true;
            }
            if (check && !(child instanceof PsiComment) && !(child instanceof PsiWhiteSpace)) {
                return false;
            }
            if (range.second != child) continue;
            return true;
        }
        return true;
    }

    private static boolean containsPackage(@NotNull Couple<PsiElement> range, @NotNull PsiElement commonParent) {
        if (range == null) {
            GoStatementMover.$$$reportNull$$$0(23);
        }
        if (commonParent == null) {
            GoStatementMover.$$$reportNull$$$0(24);
        }
        boolean check = false;
        for (PsiElement child : commonParent.getChildren()) {
            if (range.first == child) {
                check = true;
            }
            if (check && child instanceof GoPackageClause) {
                return true;
            }
            if (range.second != child) continue;
            return false;
        }
        return false;
    }

    private static LineRange createLineRange(@NotNull PsiElement element) {
        if (element == null) {
            GoStatementMover.$$$reportNull$$$0(25);
        }
        return GoStatementMover.createLineRange(element, element);
    }

    private static LineRange createLineRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            GoStatementMover.$$$reportNull$$$0(26);
        }
        if (end == null) {
            GoStatementMover.$$$reportNull$$$0(27);
        }
        PsiComment firstComment = (PsiComment)ContainerUtil.getFirstItem(GoDocumentationProvider.getUpperComments(start));
        PsiComment lastComment = (PsiComment)ContainerUtil.getLastItem(GoDocumentationProvider.getAfterComments(end));
        return new LineRange((PsiElement)ObjectUtils.notNull((Object)firstComment, (Object)start), (PsiElement)ObjectUtils.notNull((Object)lastComment, (Object)end));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 6: 
            case 15: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonParent";
                break;
            }
            case 7: 
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoStatementMover";
                break;
            }
            case 14: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoStatementMover";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhitespaceAndCommentsBackward";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhitespaceAndCommentsForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementRange";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostElementRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceAndCommentsBackward";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceAndCommentsForward";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setUpInfoToMoveInTopLevelDeclaration";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMostDistantLineToMove";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNeighborOfType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsCommentsOnly";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsPackage";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createLineRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10 -> new IllegalStateException(string);
        };
    }
}

