/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.smart;

import com.goide.GoTypes;
import com.goide.inspections.GoDeferGoInspection;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    public GoSmartEnterProcessor() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{new IfFixer(), new ForFixer(), new FuncFixer(), new GoDeferExpressionFixer(), new CompositeLiteralElementFixer(), new GoCallFixer()});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new PlainEnterProcessor()});
    }

    private static void addBlock(@NotNull GoStatement element) {
        if (element == null) {
            GoSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        element.add(GoElementFactory.createBlock(element.getProject()));
    }

    private static void addBlockIfNeeded(@NotNull GoStatement element) {
        if (element == null) {
            GoSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (element.getBlock() == null) {
            GoSmartEnterProcessor.addBlock(element);
        }
    }

    public boolean doNotStepInto(PsiElement element) {
        return element instanceof GoBlock;
    }

    protected void collectAdditionalElements(@NotNull PsiElement element, @NotNull List<PsiElement> result) {
        if (element == null) {
            GoSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            GoSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoElement.class, GoStatement.class, GoFunctionOrMethodDeclaration.class, GoFunctionLit.class, GoCallExpr.class})) != null) {
            result.add(element);
            PsiElement parent = element.getParent();
            if (parent instanceof GoStatement) {
                result.add(parent);
            }
        }
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{GoElement.class, GoStatement.class});
        if (element instanceof GoElement) {
            PsiElement literal = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoCompositeLit.class, GoStatement.class});
            if (literal instanceof GoCompositeLit) {
                CodeEditUtil.markToReformat((ASTNode)literal.getNode(), (boolean)true);
            }
            return;
        }
        super.reformat(atCaret);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/smart/GoSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addBlockIfNeeded";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IfFixer
    extends SmartEnterProcessorWithFixers.Fixer<SmartEnterProcessorWithFixers> {
        private IfFixer() {
        }

        public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            GoIfStatement ifStatement;
            if (editor == null) {
                IfFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                IfFixer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                IfFixer.$$$reportNull$$$0(2);
            }
            if ((ifStatement = (GoIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GoIfStatement.class, (boolean)false)) != null && ifStatement.getBlock() == null) {
                GoExpression ifStatementCondition = ifStatement.getCondition();
                if (ifStatementCondition == null) {
                    GoSmartEnterProcessor.addBlock(ifStatement);
                } else {
                    int conditionStart = ifStatementCondition.getTextRange().getStartOffset();
                    int caretOffset = editor.getCaretModel().getOffset();
                    if (caretOffset <= conditionStart && (GoPsiUtil.hasNewLineAfter(ifStatement.getSemicolon()) || GoPsiUtil.hasNewLineAfter(ifStatement.getInitStatement()))) {
                        int bracketsStart = ifStatement.getIf().getTextRange().getEndOffset();
                        if (ifStatement.getSemicolon() != null) {
                            bracketsStart = ifStatement.getSemicolon().getTextRange().getEndOffset();
                        } else if (ifStatement.getInitStatement() != null) {
                            bracketsStart = ifStatement.getInitStatement().getTextRange().getEndOffset();
                        }
                        editor.getDocument().insertString(bracketsStart, (CharSequence)"{}");
                        CodeEditUtil.markToReformat((ASTNode)ifStatement.getNode(), (boolean)true);
                    } else {
                        GoSmartEnterProcessor.addBlock(ifStatement);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/smart/GoSmartEnterProcessor$IfFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ForFixer
    extends SmartEnterProcessorWithFixers.Fixer<SmartEnterProcessorWithFixers> {
        private ForFixer() {
        }

        public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            GoForStatement forStatement;
            if (editor == null) {
                ForFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                ForFixer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ForFixer.$$$reportNull$$$0(2);
            }
            if ((forStatement = (GoForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GoForStatement.class, (boolean)false)) != null) {
                GoSmartEnterProcessor.addBlockIfNeeded(forStatement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/smart/GoSmartEnterProcessor$ForFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FuncFixer
    extends SmartEnterProcessorWithFixers.Fixer<SmartEnterProcessorWithFixers> {
        private FuncFixer() {
        }

        public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            if (editor == null) {
                FuncFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                FuncFixer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                FuncFixer.$$$reportNull$$$0(2);
            }
            if ((element instanceof GoFunctionOrMethodDeclaration || element instanceof GoFunctionLit) && ((GoSignatureOwner)element).getBlockIfExists() == null) {
                element.add((PsiElement)GoElementFactory.createBlock(element.getProject()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/smart/GoSmartEnterProcessor$FuncFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoDeferExpressionFixer
    extends SmartEnterProcessorWithFixers.Fixer<SmartEnterProcessorWithFixers> {
        private GoDeferExpressionFixer() {
        }

        public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiElement expr;
            if (editor == null) {
                GoDeferExpressionFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                GoDeferExpressionFixer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                GoDeferExpressionFixer.$$$reportNull$$$0(2);
            }
            Project project = element.getProject();
            if (element instanceof GoGoStatement) {
                PsiElement expr2 = GoDeferGoInspection.GoAddParensQuickFix.addParensIfNeeded(project, ((GoGoStatement)element).getExpression());
                if (expr2 != null) {
                    element.replace((PsiElement)GoElementFactory.createGoStatement(project, expr2.getText()));
                }
            } else if (element instanceof GoDeferStatement && (expr = GoDeferGoInspection.GoAddParensQuickFix.addParensIfNeeded(project, ((GoDeferStatement)element).getExpression())) != null) {
                element.replace((PsiElement)GoElementFactory.createDeferStatement(project, expr.getText()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/smart/GoSmartEnterProcessor$GoDeferExpressionFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompositeLiteralElementFixer
    extends SmartEnterProcessorWithFixers.Fixer<SmartEnterProcessorWithFixers> {
        private CompositeLiteralElementFixer() {
        }

        public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            if (editor == null) {
                CompositeLiteralElementFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                CompositeLiteralElementFixer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                CompositeLiteralElementFixer.$$$reportNull$$$0(2);
            }
            if (!(element instanceof GoElement)) {
                return;
            }
            PsiElement nextVisibleSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
            if (nextVisibleSibling == null || nextVisibleSibling.getNode().getElementType() == GoTypes.COMMA) {
                return;
            }
            PsiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            parent.addAfter(GoElementFactory.createComma(element.getProject()), element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/smart/GoSmartEnterProcessor$CompositeLiteralElementFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoCallFixer
    extends SmartEnterProcessorWithFixers.Fixer<SmartEnterProcessorWithFixers> {
        private GoCallFixer() {
        }

        public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) throws IncorrectOperationException {
            if (editor == null) {
                GoCallFixer.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                GoCallFixer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                GoCallFixer.$$$reportNull$$$0(2);
            }
            if (element instanceof GoCallExpr) {
                GoArgumentList parent;
                GoCallExpr parentCall;
                if (PsiTreeUtil.getDeepestLast((PsiElement)element).getNode().getElementType() != GoTypes.RPAREN) {
                    PsiDocumentManager.getInstance((Project)element.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    int endOffset = element.getTextRange().getEndOffset();
                    editor.getDocument().insertString(endOffset, (CharSequence)")");
                }
                if ((parentCall = (GoCallExpr)ObjectUtils.tryCast((Object)((parent = (GoArgumentList)ObjectUtils.tryCast((Object)element.getParent(), GoArgumentList.class)) != null ? parent.getParent() : null), GoCallExpr.class)) != null) {
                    this.apply(editor, processor2, parentCall);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/smart/GoSmartEnterProcessor$GoCallFixer";
            objectArray[2] = "apply";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        @Nullable
        private static GoBlock findBlock(@Nullable PsiElement element) {
            if ((element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoStatement.class, GoBlock.class, GoFunctionOrMethodDeclaration.class, GoFunctionLit.class})) instanceof GoSimpleStatement && element.getParent() instanceof GoStatement) {
                element = element.getParent();
            }
            if (element instanceof GoIfStatement) {
                return ((GoIfStatement)element).getBlock();
            }
            if (element instanceof GoForStatement) {
                return ((GoForStatement)element).getBlock();
            }
            if (element instanceof GoBlock) {
                return (GoBlock)element;
            }
            if (element instanceof GoSignatureOwner) {
                return ((GoSignatureOwner)element).getBlockIfExists();
            }
            return null;
        }

        @Nullable
        private static PsiElement findCommaAfterStructLiteralElement(@Nullable PsiElement element) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoElement.class, GoStatement.class});
            PsiElement nextSibling = parent instanceof GoElement ? PsiTreeUtil.skipSiblingsForward((PsiElement)parent, (Class[])new Class[]{PsiWhiteSpace.class}) : null;
            return nextSibling != null && nextSibling.getNode().getElementType() == GoTypes.COMMA ? nextSibling : null;
        }

        public boolean doEnter(PsiElement psiElement, PsiFile file2, @NotNull Editor editor, boolean modified) {
            PsiElement comma;
            if (editor == null) {
                PlainEnterProcessor.$$$reportNull$$$0(0);
            }
            if ((comma = PlainEnterProcessor.findCommaAfterStructLiteralElement(psiElement)) != null) {
                editor.getCaretModel().moveToOffset(comma.getTextRange().getEndOffset());
                return true;
            }
            GoBlock block = PlainEnterProcessor.findBlock(psiElement);
            if (block != null) {
                editor.getCaretModel().moveToOffset(block.getLbrace().getTextRange().getEndOffset());
            }
            if (IntentionPreviewUtils.isIntentionPreviewActive()) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"\n");
                CodeStyleManager.getInstance((Project)psiElement.getProject()).adjustLineIndent(editor.getDocument(), editor.getCaretModel().getOffset());
            } else {
                this.plainEnter(editor);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/goide/editor/smart/GoSmartEnterProcessor$PlainEnterProcessor", "doEnter"));
        }
    }
}

