/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.surround;

import com.goide.psi.GoBlock;
import com.goide.psi.GoIfStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoStatementsSurrounder
implements Surrounder {
    private static final Logger LOG = Logger.getInstance(GoStatementsSurrounder.class);

    public boolean isApplicable(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements2) {
        PsiElement container;
        if (project == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(3);
        }
        if ((container = elements2[0].getParent()) == null) {
            return null;
        }
        return this.surroundStatements(project, container, elements2);
    }

    @Nullable
    protected abstract TextRange surroundStatements(@NotNull Project var1, @NotNull PsiElement var2, PsiElement @NotNull [] var3) throws IncorrectOperationException;

    @Nullable
    protected TextRange surroundStatementsWithIfElse(@NotNull Project project, @NotNull PsiElement container, PsiElement @NotNull [] statements, boolean withElse) {
        if (project == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(4);
        }
        if (container == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(5);
        }
        if (statements == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(6);
        }
        PsiElement first = (PsiElement)ArrayUtil.getFirstElement((Object[])statements);
        PsiElement last = (PsiElement)ArrayUtil.getLastElement((Object[])statements);
        if (!GoStatementsSurrounder.isParentEquals(first, container) || !GoStatementsSurrounder.isParentEquals(last, container)) {
            String offsetsText = "container offset: " + GoStatementsSurrounder.getOffsetText(container) + "; statements start offset: " + GoStatementsSurrounder.getOffsetText(first) + "; statements end offset " + GoStatementsSurrounder.getOffsetText(last);
            LOG.error("Cannot surround statements", new Attachment[]{new Attachment("offsets", offsetsText), CoreAttachmentFactory.createAttachment((VirtualFile)container.getContainingFile().getVirtualFile())});
        }
        String block = StringUtil.join((Object[])statements, PsiElement::getText, (String)"");
        GoIfStatement ifStatement = GoElementFactory.createIfStatement(project, "", block, withElse ? "" : null);
        ifStatement = (GoIfStatement)container.addAfter((PsiElement)ifStatement, last);
        container.deleteChildRange(first, last);
        int offset = this.getOffsetLBraceOfBlock(ifStatement.getBlock());
        return offset > -1 ? new TextRange(offset, offset) : null;
    }

    private static String getOffsetText(@Nullable PsiElement element) {
        return element != null ? String.valueOf(element.getTextRange().getStartOffset()) : "null";
    }

    private static boolean isParentEquals(@Nullable PsiElement element, @NotNull PsiElement equalsTo) {
        if (equalsTo == null) {
            GoStatementsSurrounder.$$$reportNull$$$0(7);
        }
        return element != null && equalsTo.equals((Object)element.getParent());
    }

    protected int getOffsetLBraceOfBlock(@Nullable GoBlock block) {
        return block != null ? block.getLbrace().getTextRange().getStartOffset() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalsTo";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/surround/GoStatementsSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundStatementsWithIfElse";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isParentEquals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

