/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.ui;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.util.Alarm;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLand5Anniversary
extends TypedHandlerDelegate
implements CopyPastePreProcessor {
    private static final String KEY_PHRASE = "Happy B-day, GoLand";
    private static final int ANIMATION_LENGTH_IN_MILLISECONDS = 3500;
    private static final String GAME_URL = "https://jb.gg/wondergoland";
    private static final Dimension GAME_WINDOW_SIZE = new Dimension(800, 600);

    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        if (Registry.is((String)"glnd.gm.enabled") && (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)KEY_PHRASE) || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)KEY_PHRASE.replace(",", "")))) {
            this.startGame(editor);
        }
        String string = text;
        if (string == null) {
            GoLand5Anniversary.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GoLand5Anniversary.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoLand5Anniversary.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            GoLand5Anniversary.$$$reportNull$$$0(3);
        }
        if (Registry.is((String)"glnd.gm.enabled") && (GoLand5Anniversary.hasKeyPhrase(editor, KEY_PHRASE) || GoLand5Anniversary.hasKeyPhrase(editor, KEY_PHRASE.replace(",", "")))) {
            this.startGame(editor);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            GoLand5Anniversary.$$$reportNull$$$0(4);
        }
        return result;
    }

    private static boolean hasKeyPhrase(@NotNull Editor editor, String keyPhrase) {
        String text;
        int offset;
        if (editor == null) {
            GoLand5Anniversary.$$$reportNull$$$0(5);
        }
        return (offset = editor.getCaretModel().getOffset()) >= keyPhrase.length() && StringUtil.equalsIgnoreCase((CharSequence)(text = editor.getDocument().getText(new TextRange(offset - keyPhrase.length(), offset))), (CharSequence)keyPhrase);
    }

    private void startGame(Editor editor) {
        Window activeFrame = IdeFrameImpl.getActiveFrame();
        Project project = editor.getProject();
        if (!(activeFrame instanceof IdeFrameImpl) || project == null) {
            return;
        }
        JBCefBrowser browser = JBCefBrowser.createBuilder().setOffScreenRendering(true).setUrl("about:blank").build();
        browser.setProperty("JBCefBrowser.focusOnShow", (Object)Boolean.TRUE);
        JRootPane rootPane = ((IdeFrameImpl)activeFrame).getRootPane();
        JComponent browserComponent = browser.getComponent();
        browserComponent.setBackground(Gray.x00.withAlpha(0));
        rootPane.getLayeredPane().add(browserComponent);
        rootPane.getLayeredPane().setLayer(browserComponent, 1);
        SwingUtilities.invokeLater(() -> {
            try {
                InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("data.html");
                if (stream != null) {
                    browser.loadHTML(FileUtil.loadTextAndClose((InputStream)stream));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Alarm().addRequest(() -> {
                rootPane.getLayeredPane().remove(browserComponent);
                if (GoLand5Anniversary.isShowGameInBrowser()) {
                    BrowserUtil.browse((String)GAME_URL);
                } else {
                    JBCefBrowser game = JBCefBrowser.createBuilder().setUrl(GAME_URL).build();
                    game.setOpenLinksInExternalBrowser(true);
                    game.getComponent().setSize(GAME_WINDOW_SIZE);
                    game.getComponent().setPreferredSize(GAME_WINDOW_SIZE);
                    JBPopupFactory.getInstance().createComponentPopupBuilder(game.getComponent(), game.getComponent()).setResizable(true).setModalContext(true).setCancelOnClickOutside(false).setRequestFocus(true).setMinSize(GAME_WINDOW_SIZE).createPopup().showInFocusCenter();
                }
            }, 3500);
        });
        Point loc = SwingUtilities.convertPoint(editor.getComponent(), 0, 0, ((IdeFrameImpl)activeFrame).getContentPane());
        Dimension size = editor.getComponent().getSize();
        browserComponent.setBounds(loc.x, loc.y, size.width, size.height);
    }

    private static boolean isShowGameInBrowser() {
        return Registry.is((String)"glnd.gm.show.in.browser");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/ui/GoLand5Anniversary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/ui/GoLand5Anniversary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasKeyPhrase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

