/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.goide.GoOsManager;
import com.goide.execution.GoBuildResultKey;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GoBuildResultCache
implements Disposable {
    private final Cache<GoBuildResultKey, String> myCache = Caffeine.newBuilder().removalListener((key, value2, cause) -> {
        try {
            if (value2 != null) {
                Files.deleteIfExists(Paths.get(value2, new String[0]));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }).maximumSize(100L).build();

    @NotNull
    public static GoBuildResultCache getInstance() {
        GoBuildResultCache goBuildResultCache = (GoBuildResultCache)ApplicationManager.getApplication().getService(GoBuildResultCache.class);
        if (goBuildResultCache == null) {
            GoBuildResultCache.$$$reportNull$$$0(0);
        }
        return goBuildResultCache;
    }

    @Nullable
    public String getCachedOutputPath(@Nullable GoBuildResultKey result, @NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoBuildResultCache.$$$reportNull$$$0(1);
        }
        return result != null && GoBuildResultCache.cacheEnabledAndWorks(project, module) ? (String)this.myCache.getIfPresent((Object)result) : null;
    }

    public void cacheOutputPath(@Nullable GoBuildResultKey result, @NotNull String outputPath, @NotNull Project project, @Nullable Module module) {
        if (outputPath == null) {
            GoBuildResultCache.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoBuildResultCache.$$$reportNull$$$0(3);
        }
        if (result != null && GoBuildResultCache.cacheEnabledAndWorks(project, module)) {
            this.myCache.put((Object)result, (Object)outputPath);
        }
    }

    private static boolean cacheEnabledAndWorks(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoBuildResultCache.$$$reportNull$$$0(4);
        }
        return Registry.is((String)"go.build.output.path.cache.enabled") && (!GoOsManager.isWindows() || GoSdkService.getInstance(project).getSdk(module).getMajorVersion().isAtLeast(GoSdkVersion.GO_1_14));
    }

    public void dispose() {
        this.myCache.invalidateAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoBuildResultCache";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoBuildResultCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOutputPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cacheOutputPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cacheEnabledAndWorks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

