/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.execution.GoBuildingRunningState;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoPackageUtil;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoBuildingRunConfiguration<RunningState extends GoBuildingRunningState<? extends GoBuildingRunConfiguration<RunningState>>>
extends GoRunConfigurationBase<RunningState> {
    @NonNls
    private static final String ROOT_DIRECTORY = "root_directory";
    @NonNls
    private static final String FILE_PATH_ATTRIBUTE_NAME = "filePath";
    @NonNls
    private static final String DIRECTORY_ATTRIBUTE_NAME = "directory";
    @NonNls
    private static final String KIND_ATTRIBUTE_NAME = "kind";
    @NonNls
    private static final String PACKAGE_ATTRIBUTE_NAME = "package";
    @NonNls
    private static final String OUTPUT_DIRECTORY_ATTRIBUTE_NAME = "output_directory";
    @NonNls
    private static final String BUILD_ON_REMOTE_TARGET_ATTRIBUTE_NAME = "build_on_remote_target";
    private static final String MY_BUILD_ON_REMOTE_TARGET_DEFAULT = "false";
    @Nullable
    private String myRootDirectory;
    @Nullable
    private String myPackage;
    @NotNull
    protected String myFilePaths;
    @NotNull
    protected String myDirectoryPath;
    @Nullable
    protected String myOutputDirectory;
    protected boolean myBuildOnRemoteTarget;
    private Kind myKind;

    protected GoBuildingRunConfiguration(@NotNull Project project, @NotNull String name, @NotNull ConfigurationType configurationType) {
        if (project == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(1);
        }
        if (configurationType == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(2);
        }
        super(name, new GoModuleBasedConfiguration(project), configurationType.getConfigurationFactories()[0]);
        this.myBuildOnRemoteTarget = false;
        this.myFilePaths = this.getWorkingDirectory();
        this.myDirectoryPath = this.getWorkingDirectory();
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        if (!this.getWorkingDirectory().equals(this.myRootDirectory)) {
            GoBuildingRunConfiguration.writeNonEmptyPathField(element, ROOT_DIRECTORY, this.myRootDirectory);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)KIND_ATTRIBUTE_NAME, this.myKind != null ? this.myKind.name() : null);
        GoBuildingRunConfiguration.writeNonEmptyField(element, PACKAGE_ATTRIBUTE_NAME, this.myPackage);
        GoBuildingRunConfiguration.writeNonEmptyPathField(element, DIRECTORY_ATTRIBUTE_NAME, this.myDirectoryPath);
        GoBuildingRunConfiguration.writeNonEmptyPathField(element, FILE_PATH_ATTRIBUTE_NAME, this.myFilePaths);
        GoBuildingRunConfiguration.writeNonEmptyPathField(element, OUTPUT_DIRECTORY_ATTRIBUTE_NAME, this.myOutputDirectory);
        JDOMExternalizerUtil.writeField((Element)element, (String)BUILD_ON_REMOTE_TARGET_ATTRIBUTE_NAME, (String)String.valueOf(this.myBuildOnRemoteTarget), (String)MY_BUILD_ON_REMOTE_TARGET_DEFAULT);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        this.myRootDirectory = GoBuildingRunConfiguration.readPathField(element, ROOT_DIRECTORY);
        this.myPackage = JDOMExternalizerUtil.readCustomField((Element)element, (String)PACKAGE_ATTRIBUTE_NAME);
        this.myDirectoryPath = StringUtil.notNullize((String)GoBuildingRunConfiguration.readPathField(element, DIRECTORY_ATTRIBUTE_NAME));
        this.myFilePaths = StringUtil.notNullize((String)GoBuildingRunConfiguration.readPathField(element, FILE_PATH_ATTRIBUTE_NAME));
        this.myOutputDirectory = GoBuildingRunConfiguration.readPathField(element, OUTPUT_DIRECTORY_ATTRIBUTE_NAME);
        this.myBuildOnRemoteTarget = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)BUILD_ON_REMOTE_TARGET_ATTRIBUTE_NAME, (String)MY_BUILD_ON_REMOTE_TARGET_DEFAULT));
        try {
            String kindName = JDOMExternalizerUtil.readCustomField((Element)element, (String)KIND_ATTRIBUTE_NAME);
            this.myKind = kindName != null ? Kind.valueOf(kindName) : this.getDefaultKind();
        }
        catch (IllegalArgumentException e) {
            this.myKind = this.getDefaultKind();
        }
    }

    @NotNull
    protected abstract Kind getDefaultKind();

    public boolean isBuildable() {
        return true;
    }

    @Override
    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        if (target == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Nullable
    public String getRootDirectory() {
        return this.myRootDirectory;
    }

    public void setRootDirectory(@Nullable String rootDirectory) {
        this.myRootDirectory = rootDirectory;
    }

    @NotNull
    public Collection<GoPackage> getContextPackages() {
        PsiDirectory psiWorkingDir = GoPsiUtil.findPsiDirectoryByUrl(this.getProject(), this.getWorkingDirectoryUrl());
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement((PsiElement)psiWorkingDir);
        Module module = ((GoModuleBasedConfiguration)this.getConfigurationModule()).getModule();
        Collection<GoPackage> collection = GoPackageUtil.findByImportPath(this.getPackage(), this.getProject(), module, resolveState);
        if (collection == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public String getPackage() {
        if (this.myPackage == null) {
            this.myPackage = this.suggestPackagePath();
        }
        String string = this.myPackage;
        if (string == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String suggestPackagePath() {
        Project project = this.getProject();
        String workingDirectory = this.getWorkingDirectory();
        if (!workingDirectory.isEmpty() && project.isInitialized()) {
            String string = (String)ReadAction.compute(() -> {
                VirtualFile file2 = this.findFile(workingDirectory);
                if (file2 != null) {
                    PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(file2);
                    return StringUtil.notNullize((String)GoPackageUtil.findFirstImportPath(directory, false));
                }
                return "";
            });
            if (string == null) {
                GoBuildingRunConfiguration.$$$reportNull$$$0(8);
            }
            return string;
        }
        return "";
    }

    public void setPackage(@NotNull String aPackage) {
        if (aPackage == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(9);
        }
        this.myPackage = aPackage;
    }

    @NotNull
    public String getFilePathsString() {
        String string = this.myFilePaths;
        if (string == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setFilePathsString(@NotNull String filePaths) {
        if (filePaths == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(11);
        }
        this.myFilePaths = filePaths;
    }

    @NotNull
    public List<String> getFilePaths() {
        List<String> list = GoRunUtil.PATHS_SPLITTER.apply(this.myFilePaths);
        if (list == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void setFilePaths(@NotNull List<String> filePaths) {
        if (filePaths == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(13);
        }
        this.myFilePaths = GoRunUtil.PATHS_JOINER.apply(filePaths);
    }

    @NotNull
    public String getDirectoryPath() {
        String string = this.myDirectoryPath;
        if (string == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setDirectoryPath(@NotNull String directoryPath) {
        if (directoryPath == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(15);
        }
        this.myDirectoryPath = directoryPath;
    }

    @Nullable
    public String getOutputDirectory() {
        return this.myOutputDirectory;
    }

    public void setOutputDirectory(@Nullable String outputDirectory) {
        this.myOutputDirectory = outputDirectory;
    }

    public boolean isBuildOnRemoteTarget() {
        return this.myBuildOnRemoteTarget;
    }

    public void setBuildOnRemoteTarget(boolean buildOnRemoteTarget) {
        this.myBuildOnRemoteTarget = buildOnRemoteTarget;
    }

    @NotNull
    public Kind getKind() {
        if (this.myKind == null) {
            this.myKind = this.getDefaultKind();
        }
        Kind kind = this.myKind;
        if (kind == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(16);
        }
        return kind;
    }

    public void setKind(@NotNull Kind aKind) {
        if (aKind == null) {
            GoBuildingRunConfiguration.$$$reportNull$$$0(17);
        }
        this.myKind = aKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 10, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoBuildingRunConfiguration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoBuildingRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPackagePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathsString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFilePathsString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFilePaths";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 10, 12, 14, 16 -> new IllegalStateException(string);
        };
    }

    public static enum Kind {
        DIRECTORY("go.run.configuration.kind.directory"),
        PACKAGE("go.run.configuration.kind.package"),
        FILE("go.run.configuration.kind.file");

        private final String myUiNameProperty;

        private Kind(String uiNameProperty) {
            if (uiNameProperty == null) {
                Kind.$$$reportNull$$$0(0);
            }
            this.myUiNameProperty = uiNameProperty;
        }

        @NotNull
        @Nls
        public String getUiName() {
            String string = GoBundle.message((String)this.myUiNameProperty, (Object[])new Object[0]);
            if (string == null) {
                Kind.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiNameProperty";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoBuildingRunConfiguration$Kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoBuildingRunConfiguration$Kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

