/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.testing.GoTestConsoleProperties;
import com.goide.execution.testing.GoTestFramework;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.frameworks.gocheck.GocheckFramework;
import com.goide.execution.testing.frameworks.gotest.GotestFramework;
import com.goide.execution.testing.ui.GoTestRunConfigurationEditorForm;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkService;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestRunConfiguration
extends GoBuildingRunConfiguration<GoTestRunningState>
implements SMRunnerConsolePropertiesProvider,
DumbAware {
    @NonNls
    private static final String PATTERN_ATTRIBUTE_NAME = "pattern";
    @NonNls
    private static final String FRAMEWORK_ATTRIBUTE_NAME = "framework";
    @NonNls
    private static final String TEST_NAME_PREFIX = "test_name_prefix";
    @NotNull
    private String myPattern;
    @NotNull
    private GoTestFramework myTestFramework;
    @NotNull
    private String myTestNamePrefix;

    public GoTestRunConfiguration(@NotNull Project project, @NotNull String name, @NotNull ConfigurationType configurationType) {
        if (project == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(1);
        }
        if (configurationType == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, name, configurationType);
        this.myPattern = "";
        this.myTestFramework = GotestFramework.INSTANCE;
        this.myTestNamePrefix = "";
    }

    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull TestConsoleProperties consoleProperties, @Nullable Module module) {
        if (consoleProperties == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(3);
        }
        String defaultImportPath = switch (this.getKind()) {
            default -> throw new MatchException(null, null);
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> this.myDirectoryPath;
            case GoBuildingRunConfiguration.Kind.PACKAGE -> this.getPackage();
            case GoBuildingRunConfiguration.Kind.FILE -> this.myFilePaths;
        };
        return this.myTestFramework.createTestEventsConverter(defaultImportPath, consoleProperties, module);
    }

    @Override
    @NotNull
    protected GoTestRunningState newRunningState(ExecutionEnvironment env, Module module) {
        GoTestRunningState goTestRunningState = this.myTestFramework.newRunningState(env, module, this);
        if (goTestRunningState == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(4);
        }
        return goTestRunningState;
    }

    @Override
    public SettingsEditorGroup<GoTestRunConfiguration> createSettingsEditorGroup() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new GoTestRunConfigurationEditorForm(this.getProject()));
        return group;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        GoModuleBasedConfiguration configurationModule = (GoModuleBasedConfiguration)this.getConfigurationModule();
        if (!this.myTestFramework.isAvailable(configurationModule.getModule())) {
            throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.framework.not.available.in.module.error", (Object[])new Object[]{this.myTestFramework.getName()}));
        }
        switch (this.getKind()) {
            case DIRECTORY: {
                if (StringUtil.isEmptyOrSpaces((String)this.myDirectoryPath)) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.directory.is.not.specified.error", (Object[])new Object[0]));
                }
                String directoryPath = this.getAbsoluteDirectoryPath();
                if (!FileUtil.isAncestor((String)this.getWorkingDirectory(), (String)directoryPath, (boolean)false)) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.working.directory.should.be.ancestor.of.testing.directory.error", (Object[])new Object[0]));
                }
                VirtualFile testingDirectory = LocalFileSystem.getInstance().findFileByPath(directoryPath);
                if (testingDirectory != null) break;
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.testing.directory.does.not.exist.error", (Object[])new Object[0]));
            }
            case PACKAGE: {
                Module module = configurationModule.getModule();
                assert (module != null);
                String myPackage = this.getPackage();
                if (StringUtil.isEmptyOrSpaces((String)myPackage)) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.package.is.not.specified.error", (Object[])new Object[0]));
                }
                PsiDirectory psiWorkingDir = GoPsiUtil.findPsiDirectoryByUrl(module.getProject(), this.getWorkingDirectoryUrl());
                ResolveState resolveState = GoPsiImplUtil.createContextOnElement((PsiElement)psiWorkingDir);
                Collection<GoPackage> packages = GoPackageUtil.findByImportPath(myPackage, module.getProject(), module, resolveState);
                if (packages.isEmpty()) {
                    if (myPackage.endsWith("...")) {
                        throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.non.a.package.error", (Object[])new Object[]{myPackage}), () -> {
                            this.setKind(GoBuildingRunConfiguration.Kind.DIRECTORY);
                            Collection<GoPackage> packages2 = GoPackageUtil.findByImportPath(StringUtil.trimEnd((String)myPackage, (String)"..."), module.getProject(), module, resolveState);
                            block0: for (GoPackage aPackage : packages2) {
                                for (VirtualFile directory : aPackage.getDirectories()) {
                                    if (!directory.isValid()) continue;
                                    this.myDirectoryPath = directory.getPresentableUrl();
                                    continue block0;
                                }
                            }
                        });
                    }
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.cannot.find.package.error", (Object[])new Object[]{myPackage}));
                }
                for (GoPackage aPackage : packages) {
                    if (aPackage.find(file2 -> this.myTestFramework.isAvailableOnFile((PsiFile)file2)) == null) continue;
                    return;
                }
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.cannot.find.files.compatible.with.framework.error", (Object[])new Object[]{myPackage, this.myTestFramework.getName()}));
            }
            case FILE: {
                boolean hasSupportedFile = false;
                PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
                VirtualFile parent = null;
                if (StringUtil.isEmptyOrSpaces((String)this.myFilePaths)) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.file.is.not.specified.error", (Object[])new Object[0]));
                }
                List<String> filePaths = this.getFilePaths();
                if (filePaths.isEmpty()) {
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.file.is.not.specified.error", (Object[])new Object[0]));
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>();
                for (String filePath : filePaths) {
                    VirtualFile virtualFile = this.findFile(filePath);
                    if (virtualFile == null) {
                        throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.file.does.not.exist.error", (Object[])new Object[]{filePath}));
                    }
                    if (parent != null && !parent.equals(virtualFile.getParent())) {
                        throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.files.must.be.in.one.directory.error", (Object[])new Object[0]));
                    }
                    parent = virtualFile.getParent();
                    PsiFile file3 = psiManager.findFile(virtualFile);
                    if (!hasSupportedFile && this.myTestFramework.isAvailableOnFile(file3)) {
                        hasSupportedFile = true;
                    }
                    if (files.add(virtualFile)) continue;
                    throw new RuntimeConfigurationError(GoBundle.message((String)"go.execution.duplicate.file.error", (Object[])new Object[]{filePath}));
                }
                if (hasSupportedFile) break;
                throw new RuntimeConfigurationError(GoBundle.message((String)"go.test.framework.is.not.available.on.files.error", (Object[])new Object[]{this.myTestFramework.getName(), this.getFilePathsString()}));
            }
        }
    }

    @NotNull
    private String getAbsoluteDirectoryPath() {
        String string = OSAgnosticPathUtil.isAbsolute((String)this.myDirectoryPath) ? this.myDirectoryPath : FileUtil.join((String[])new String[]{this.getWorkingDirectory(), this.myDirectoryPath});
        if (string == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String suggestedName() {
        String functionName = this.myTestNamePrefix + GoTestRunConfiguration.patternToName(this.getPattern());
        return switch (this.getKind()) {
            default -> throw new MatchException(null, null);
            case GoBuildingRunConfiguration.Kind.PACKAGE -> {
                if (functionName.isEmpty()) {
                    yield this.myTestFramework.getPackageConfigurationName(this.getPackage());
                }
                yield GoBundle.message((String)"go.test.suggested.run.configuration.name", (Object[])new Object[]{functionName, this.getPackage()});
            }
            case GoBuildingRunConfiguration.Kind.FILE -> {
                String fileNames = StringUtil.join(this.getFilePaths(), PathUtil::getFileName, (String)" ");
                if (functionName.isEmpty()) {
                    yield this.myTestFramework.getFileConfigurationName(fileNames);
                }
                yield GoBundle.message((String)"go.test.suggested.run.configuration.name", (Object[])new Object[]{functionName, fileNames});
            }
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> {
                String directoryName = PathUtil.getFileName((String)this.getDirectoryPath());
                if (functionName.isEmpty()) {
                    yield this.myTestFramework.getPackageConfigurationName(directoryName);
                }
                yield GoBundle.message((String)"go.test.suggested.run.configuration.name", (Object[])new Object[]{functionName, directoryName});
            }
        };
    }

    @NotNull
    public GoTestConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(6);
        }
        GoTestConsoleProperties properties = new GoTestConsoleProperties(this, this.getTestFramework().getName(), executor, this.getConsoleScope());
        properties.setIdBasedTestTree(this.supportsJsonTestsOutput());
        GoTestConsoleProperties goTestConsoleProperties = properties;
        if (goTestConsoleProperties == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(7);
        }
        return goTestConsoleProperties;
    }

    protected boolean supportsJsonTestsOutput() {
        return this.getTestFramework().supportsJsonTestsOutput() && GoSdkService.getInstance(this.getProject()).getSdk(((GoModuleBasedConfiguration)this.getConfigurationModule()).getModule()).supportsJsonTestsOutput();
    }

    protected boolean supportsPanicOnExit0() {
        return GoSdkService.getInstance(this.getProject()).getSdk(((GoModuleBasedConfiguration)this.getConfigurationModule()).getModule()).supportsPanicOnExit0();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        if (this.myTestFramework == GocheckFramework.INSTANCE && this.getKind() == GoBuildingRunConfiguration.Kind.FILE) {
            List directories = ContainerUtil.mapNotNull(this.getContextFiles(), file2 -> {
                VirtualFile virtualFile = file2.getVirtualFile();
                return virtualFile != null ? virtualFile.getParent() : null;
            });
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)this.getProject(), (boolean)false, (VirtualFile[])directories.toArray(VirtualFile.EMPTY_ARRAY));
            if (globalSearchScope == null) {
                GoTestRunConfiguration.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = switch (this.getKind()) {
            default -> throw new MatchException(null, null);
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> {
                VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(this.getDirectoryPath());
                if (directory != null) {
                    yield GlobalSearchScopesCore.directoryScope((Project)this.getProject(), (VirtualFile)directory, (boolean)true);
                }
                yield GlobalSearchScope.EMPTY_SCOPE;
            }
            case GoBuildingRunConfiguration.Kind.PACKAGE -> (GlobalSearchScope)ReadAction.compute(() -> GoPackageUtil.packagesScope(this.getContextPackages()));
            case GoBuildingRunConfiguration.Kind.FILE -> GlobalSearchScope.filesScope((Project)this.getProject(), (Collection)ContainerUtil.map(this.getContextFiles(), PsiFile::getVirtualFile));
        };
        if (globalSearchScope == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    public List<GoFile> getContextFiles() {
        List list = ContainerUtil.mapNotNull(this.getFilePaths(), path -> {
            try {
                return this.findGoFile((String)path);
            }
            catch (ExecutionException e) {
                return null;
            }
        });
        if (list == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public GoFile findGoFile(@Nullable String filePath) throws ExecutionException {
        VirtualFile virtualFile;
        if (filePath != null) {
            VirtualFile tempFSFile = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(filePath) : null;
            virtualFile = tempFSFile != null ? tempFSFile : LocalFileSystem.getInstance().findFileByPath(filePath);
        } else {
            virtualFile = null;
        }
        if (virtualFile == null) {
            throw new ExecutionException(GoBundle.message((String)"go.test.file.does.not.exist.error", (Object[])new Object[]{filePath}));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        PsiFile file2 = (PsiFile)ReadAction.compute(() -> psiManager.findFile(virtualFile));
        if (!(file2 instanceof GoFile)) {
            throw new ExecutionException(GoBundle.message((String)"go.test.not.go.file.error", (Object[])new Object[]{filePath}));
        }
        GoFile goFile = (GoFile)file2;
        if (goFile == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(11);
        }
        return goFile;
    }

    @NotNull
    static String patternToName(String pattern) {
        String withoutEdges = StringUtil.trimStart((String)StringUtil.trimEnd((String)pattern, (String)"$"), (String)"^");
        String string = StringUtil.join((Collection)ContainerUtil.map((Collection)StringUtil.split((String)withoutEdges, (String)"$/^"), part -> StringUtil.join((Collection)ContainerUtil.map((Object[])part.split("\\|"), s -> StringUtil.trimStart((String)StringUtil.trimEnd((String)s, (String)"\\E"), (String)"\\Q")), (String)"|")), (String)"/");
        if (string == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(13);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)FRAMEWORK_ATTRIBUTE_NAME, (String)this.myTestFramework.getName());
        GoTestRunConfiguration.writeNonEmptyField(element, PATTERN_ATTRIBUTE_NAME, this.myPattern);
        GoTestRunConfiguration.writeNonEmptyField(element, TEST_NAME_PREFIX, this.myTestNamePrefix);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(14);
        }
        super.readExternal(element);
        this.myPattern = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)PATTERN_ATTRIBUTE_NAME));
        this.myTestFramework = GoTestFramework.fromName(JDOMExternalizerUtil.readCustomField((Element)element, (String)FRAMEWORK_ATTRIBUTE_NAME));
        this.myTestNamePrefix = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)TEST_NAME_PREFIX));
    }

    @Override
    @NotNull
    protected GoBuildingRunConfiguration.Kind getDefaultKind() {
        GoBuildingRunConfiguration.Kind kind = GoBuildingRunConfiguration.Kind.DIRECTORY;
        if (kind == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(15);
        }
        return kind;
    }

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setPattern(@NotNull String pattern) {
        if (pattern == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(17);
        }
        this.myPattern = pattern;
    }

    public void setTestFramework(@NotNull GoTestFramework testFramework) {
        if (testFramework == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(18);
        }
        this.myTestFramework = testFramework;
    }

    @NotNull
    public GoTestFramework getTestFramework() {
        GoTestFramework goTestFramework = this.myTestFramework;
        if (goTestFramework == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(19);
        }
        return goTestFramework;
    }

    public void setTestNamePrefix(@NotNull String testNamePrefix) {
        if (testNamePrefix == null) {
            GoTestRunConfiguration.$$$reportNull$$$0(20);
        }
        this.myTestNamePrefix = testNamePrefix;
    }

    @Override
    public boolean isBuildable() {
        return this.getKind() != GoBuildingRunConfiguration.Kind.DIRECTORY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9, 10, 11, 12, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestRunConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATTERN_ATTRIBUTE_NAME;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNamePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newRunningState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteDirectoryPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "patternToName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKind";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTestEventsConverter";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setPattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setTestFramework";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setTestNamePrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9, 10, 11, 12, 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

