/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoBuildingRunner;
import com.goide.execution.GoBuildingRunningState;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunningState;
import com.goide.execution.application.GoApplicationRunningState;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.coverage.GoCoverageEngine;
import com.goide.i18n.GoBundle;
import com.goide.util.GoHistoryProcessListener;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.io.IOException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class GoCoverageProgramRunner
extends GoBuildingRunner {
    @NonNls
    private static final String ID = "GoCoverageProgramRunner";

    @Override
    @NotNull
    public String getRunnerId() {
        return ID;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals("Coverage") && GoCoverageEngine.isApplicable(profile);
    }

    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return new CoverageRunnerData();
    }

    @Override
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        RunProfile runProfile;
        if (environment == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        if (state == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        if ((runProfile = environment.getRunProfile()) instanceof GoRunConfigurationBase) {
            GoRunConfigurationBase runConfiguration = (GoRunConfigurationBase)runProfile;
            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
            if (state instanceof GoBuildingRunningState) {
                GoBuildingRunningState buildingRunningState = (GoBuildingRunningState)state;
                if (buildingRunningState instanceof GoTestRunningState && !GoCoverageEngine.isApplicable((RunProfile)runConfiguration)) {
                    throw new ExecutionException(GoBundle.message((String)"go.execution.coverage.cannot.run.coverage.on.directory.kind.run.configurations.error", (Object[])new Object[0]));
                }
                String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
                buildingRunningState.setCoverageLocation(coverageFilePath);
                if (buildingRunningState instanceof GoApplicationRunningState) {
                    Object coverageDir;
                    GoApplicationRunningState applicationRunningState = (GoApplicationRunningState)buildingRunningState;
                    String goCoverDir = GoCoverageProgramRunner.getGoCoverDirValue(environment.getProject(), runConfiguration);
                    if (goCoverDir != null) {
                        coverageDir = goCoverDir;
                        this.prepareCoverageDir((String)coverageDir, false);
                    } else {
                        coverageDir = coverageFilePath + ".binary";
                        this.prepareCoverageDir((String)coverageDir, true);
                    }
                    applicationRunningState.setCoverageDirectoryLocation((String)coverageDir);
                }
            }
        }
        Promise<RunContentDescriptor> promise = super.execute(environment, state);
        if (promise == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        return promise;
    }

    private void prepareCoverageDir(@NotNull String coverageDir, boolean clear) throws ExecutionException {
        if (coverageDir == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        WriteAction.run(() -> {
            try {
                VirtualFile directory = VfsUtil.createDirectoryIfMissing((String)coverageDir);
                if (clear && directory != null) {
                    directory.refresh(false, false);
                    for (VirtualFile child : directory.getChildren()) {
                        child.delete((Object)this);
                    }
                }
            }
            catch (IOException e) {
                throw new ExecutionException(GoBundle.message((String)"go.execution.coverage.failed.to.create.or.clear.coverage.dir", (Object[])new Object[]{coverageDir}), (Throwable)e);
            }
        });
    }

    @Nullable
    private static String getGoCoverDirValue(@NotNull Project project, @NotNull GoRunConfigurationBase<?> runConfiguration) {
        String goCoverDir;
        if (project == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        if (runConfiguration == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        if ((goCoverDir = runConfiguration.getCustomEnvironment().get("GOCOVERDIR")) != null) {
            return goCoverDir;
        }
        goCoverDir = VgoProjectSettings.getInstance(project).getEnvironment().get("GOCOVERDIR");
        if (goCoverDir != null) {
            return goCoverDir;
        }
        if (runConfiguration.isPassParentEnvironment()) {
            return (String)EnvironmentUtil.getEnvironmentMap().get("GOCOVERDIR");
        }
        return null;
    }

    @Override
    @NotNull
    protected GoBuildingRunner.GoStarter createStarter(@NotNull GoRunningState<?> state, @NotNull GoHistoryProcessListener historyProcessListener, @NotNull Supplier<@Nullable String> outputFilePath, int compilationExitCode) {
        if (state == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        if (historyProcessListener == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        if (outputFilePath == null) {
            GoCoverageProgramRunner.$$$reportNull$$$0(11);
        }
        return new GoCoverageStarter(outputFilePath, historyProcessListener, compilationExitCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageProgramRunner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProcessListener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageProgramRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareCoverageDir";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGoCoverDirValue";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStarter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private final class GoCoverageStarter
    extends GoBuildingRunner.GoStarter {
        private GoCoverageStarter(@NotNull Supplier<String> outputFilePath, GoHistoryProcessListener historyListener, int compilationExitCode) {
            if (outputFilePath == null) {
                GoCoverageStarter.$$$reportNull$$$0(0);
            }
            if (historyListener == null) {
                GoCoverageStarter.$$$reportNull$$$0(1);
            }
            super(GoCoverageProgramRunner.this, outputFilePath, historyListener, compilationExitCode);
        }

        @Override
        @NotNull
        public Promise<RunContentDescriptor> execute(@NotNull GoRunningState<?> state, final @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (state == null) {
                GoCoverageStarter.$$$reportNull$$$0(2);
            }
            if (env == null) {
                GoCoverageStarter.$$$reportNull$$$0(3);
            }
            if (state instanceof GoBuildingRunningState) {
                final GoBuildingRunningState buildingRunningState = (GoBuildingRunningState)state;
                RunProfile runProfile = env.getRunProfile();
                if (runProfile instanceof GoBuildingRunConfiguration) {
                    final GoBuildingRunConfiguration runConfiguration = (GoBuildingRunConfiguration)runProfile;
                    this.patchBuildingState(state);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!Disposer.isDisposed((Disposable)env)) {
                            CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
                        }
                    });
                    ProcessHandler process = state.startProcess();
                    final Project project = runConfiguration.getProject();
                    process.addProcessListener(new ProcessListener(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            new Task.Backgroundable(project, GoBundle.message((String)"go.execution.coverage.downloading.coverage.report.progress.title", (Object[])new Object[0])){

                                public void run(@NotNull ProgressIndicator indicator) {
                                    if (indicator == null) {
                                        GoCoverageStarter.1.$$$reportNull$$$0(0);
                                    }
                                    buildingRunningState.processReport(() -> CoverageDataManager.getInstance((Project)project).processGatheredCoverage((RunConfigurationBase)runConfiguration, env.getRunnerSettings()));
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/execution/testing/coverage/GoCoverageProgramRunner$GoCoverageStarter$1$1", "run"));
                                }
                            }.queue();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/execution/testing/coverage/GoCoverageProgramRunner$GoCoverageStarter$1", "processTerminated"));
                        }
                    });
                    Promise promise = GoCoverageProgramRunner.this.executeProcess(state, env, process);
                    if (promise == null) {
                        GoCoverageStarter.$$$reportNull$$$0(4);
                    }
                    return promise;
                }
            }
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                GoCoverageStarter.$$$reportNull$$$0(5);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "historyListener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageProgramRunner$GoCoverageStarter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageProgramRunner$GoCoverageStarter";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

