/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.creator;

import com.goide.GoNotifications;
import com.goide.actions.tool.GoDownloadableFileAction;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.creator.GoTestCreator;
import com.goide.execution.testing.creator.GoTestGenerator;
import com.goide.i18n.GoBundle;
import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoExecutor;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoGeneratingTestCreator
extends GoTestCreator {
    public static final Key<Boolean> USE_TESTIFY_ASSERT = Key.create((String)"GO_USE_TESTIFY_ASSERT");

    public void createTest(Project project, Editor editor, PsiFile file2) {
        if (Registry.is((String)"go.testing.creator.use.gotest", (boolean)false)) {
            this.createTestUsingGotest(project, editor, file2);
        } else {
            GoGeneratingTestCreator.generateTests(project, file2, this.getFunctions(editor, (GoFile)file2));
        }
    }

    @Override
    public boolean isAvailable(Project project, Editor editor, PsiFile file2) {
        if (editor == null) {
            return false;
        }
        GoFile goFile = (GoFile)((Object)ObjectUtils.tryCast((Object)file2, GoFile.class));
        return goFile != null && this.isAvailable(editor, goFile);
    }

    private boolean isAvailable(Editor editor, GoFile file2) {
        return !this.getFunctions(editor, file2).isEmpty();
    }

    private void createTestUsingGotest(Project project, Editor editor, PsiFile file2) {
        Module module = GoUtil.module((PsiElement)file2);
        VirtualFile executable = GoSdkUtil.findExecutableInGoPath("gotests", project, module);
        if (executable == null || !executable.exists()) {
            GoDownloadableFileAction.showDownloadToolNotification(project, module, "Gotests", "gotests", "github.com/cweill/gotests");
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final ArrayList generatedFunctions = new ArrayList();
        GoExecutor.in(project, module).withPresentableName(GoBundle.message((String)"go.test.creator.gotests.generation.name", (Object[])new Object[0])).withExePath(executable.getPath()).withParameters("-w").withParameters(this.getExtraParameters(editor, file2)).withParameters(this.getTargetFile(file2)).showGoEnvVariables(false).withPtyEnabled(false).withProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String generatedFunctionPrefix;
                String text;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text = event.getText()).startsWith(generatedFunctionPrefix = "Generated ")) {
                    generatedFunctions.add(StringUtil.trimStart((String)text, (String)generatedFunctionPrefix).trim());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/goide/execution/testing/creator/GoGeneratingTestCreator$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).executeWithProgress(true, true, result -> {
            if (result.status == GoExecutor.ExecutionResult.Status.SUCCEEDED) {
                String firstGeneratedFunctionName = (String)ContainerUtil.getFirstItem((List)generatedFunctions);
                if (firstGeneratedFunctionName != null) {
                    GoGeneratingTestCreator.navigateToGeneratedFunction(file2, firstGeneratedFunctionName);
                } else {
                    HintManager.getInstance().showInformationHint(editor, GoBundle.message((String)"go.test.creator.gotests.no.tests.generated", (Object[])new Object[0]));
                }
            }
        });
    }

    private static void navigateToGeneratedFunction(@NotNull PsiFile file2, @NotNull String generatedFunctionName) {
        VirtualFile virtualFile;
        if (file2 == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(0);
        }
        if (generatedFunctionName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file2.getVirtualFile()) != null) {
            GoGeneratingTestCreator.navigateToGeneratedFunction(file2.getContainingDirectory(), virtualFile.getNameWithoutExtension() + "_test.go", generatedFunctionName);
        }
    }

    private static void navigateToGeneratedFunction(@Nullable PsiDirectory dir, @NotNull String testFileName, @NotNull String generatedFunctionName) {
        if (testFileName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(2);
        }
        if (generatedFunctionName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            return;
        }
        Project project = dir.getProject();
        if (project.isDisposed()) {
            return;
        }
        VirtualFile parent = dir.getVirtualFile();
        VfsUtil.markDirty((boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{parent});
        parent.refresh(true, false, () -> {
            PsiFile testFile;
            VirtualFile child = parent.findChild(testFileName);
            PsiFile psiFile = testFile = child != null ? PsiManager.getInstance((Project)project).findFile(child) : null;
            if (testFile instanceof GoFile) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(testFile);
                if (document != null) {
                    documentManager.performForCommittedDocument(document, () -> {
                        GoFunctionDeclaration function = (GoFunctionDeclaration)ContainerUtil.getFirstItem(((GoFile)testFile).getFunctions(generatedFunctionName));
                        ((Navigatable)((PsiNamedElement)Objects.requireNonNullElse(function, testFile))).navigate(true);
                    });
                }
            }
        });
    }

    @NotNull
    protected String getTargetFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(4);
        }
        String string = file2.getVirtualFile().getPath();
        if (string == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected String @NotNull [] getExtraParameters(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(7);
        }
        String[] stringArray = new String[]{"-all"};
        if (stringArray == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    protected abstract List<GoFunctionOrMethodDeclaration> getFunctions(@NotNull Editor var1, @NotNull GoFile var2);

    private static void generateTests(Project project, PsiFile file2, List<GoFunctionOrMethodDeclaration> functions) {
        String packageName;
        PsiDirectory dir = file2.getParent();
        if (file2 instanceof GoFile) {
            GoFile goFile = (GoFile)file2;
            v0 = goFile.getPackageName();
        } else {
            v0 = packageName = null;
        }
        if (functions.isEmpty() || dir == null || packageName == null) {
            return;
        }
        String testFileName = GoTestFinder.isTestFile(file2) ? file2.getName() : file2.getVirtualFile().getNameWithoutExtension() + "_test.go";
        boolean useTestifyAssert = GoGeneratingTestCreator.isUseTestifyAssert(file2);
        GoGeneratingTestCreator.generateTests(project, dir, testFileName, packageName, functions, useTestifyAssert);
    }

    private static boolean isUseTestifyAssert(PsiFile file2) {
        GoPackage pkg;
        Boolean flag;
        if (ApplicationManager.getApplication().isUnitTestMode() && (flag = (Boolean)TestModeFlags.get(USE_TESTIFY_ASSERT)) != null) {
            return flag;
        }
        GoFile goFile = (GoFile)((Object)ObjectUtils.tryCast((Object)file2, GoFile.class));
        GoPackage goPackage = pkg = goFile != null ? GoPackage.of(goFile) : null;
        if (pkg == null) {
            return false;
        }
        GoUtil.TestsScope scope = new GoUtil.TestsScope(pkg.getScope());
        return GoImportPathToAliasIndexKt.getImportPathUsageCount((GlobalSearchScope)scope, "github.com/stretchr/testify/assert") > 0;
    }

    private static void generateTests(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull String testFileName, @NotNull String testPackageName, @NotNull List<GoFunctionOrMethodDeclaration> functions, boolean useTestifyAssert) {
        if (project == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(10);
        }
        if (testFileName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(11);
        }
        if (testPackageName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(12);
        }
        if (functions == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(13);
        }
        try {
            String firstFunctionName = GoGeneratingTestCreator.generate(project, dir, testFileName, testPackageName, functions, useTestifyAssert);
            if (firstFunctionName == null) {
                GoGeneratingTestCreator.showWarning(project, GoBundle.message((String)"go.test.creator.gotests.no.tests.generated", (Object[])new Object[0]));
            } else {
                GoGeneratingTestCreator.navigateToGeneratedFunction(dir, testFileName, firstFunctionName);
            }
        }
        catch (GoTestGenerator.TestGenerationException e) {
            GoGeneratingTestCreator.showWarning(project, e.getMessage());
        }
    }

    @Nullable
    private static String generate(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull String testFileName, @NotNull String testPackageName, @NotNull List<GoFunctionOrMethodDeclaration> functions, boolean useTestifyAssert) {
        if (project == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(14);
        }
        if (dir == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(15);
        }
        if (testFileName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(16);
        }
        if (testPackageName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(17);
        }
        if (functions == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(18);
        }
        return (String)WriteCommandAction.writeCommandAction((Project)project).compute(() -> {
            GoFile testFile = GoGeneratingTestCreator.findOrCreateTestFile(project, dir, testFileName, testPackageName);
            if (testFile == null) {
                throw new GoTestGenerator.TestGenerationException(GoBundle.message((String)"go.test.creator.gotests.failed.to.create.test.file", (Object[])new Object[]{testFileName}));
            }
            GoTestGenerator generator = new GoTestGenerator(testFile);
            generator.setUseTestifyAssert(useTestifyAssert);
            List<GoFunctionDeclaration> tests = generator.generateTests(functions);
            GoFunctionDeclaration first = (GoFunctionDeclaration)ContainerUtil.getFirstItem(tests);
            return first != null ? first.getName() : null;
        });
    }

    private static void showWarning(@NotNull Project project, @NlsContexts.NotificationContent @NotNull String message) {
        if (project == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(19);
        }
        if (message == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(20);
        }
        String title = GoBundle.message((String)"go.test.creator.gotests.generation.failed.notification.title", (Object[])new Object[0]);
        GoNotifications.getGeneralGroup().createNotification(title, message, NotificationType.WARNING).notify(project);
    }

    @Nullable
    private static GoFile findOrCreateTestFile(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull String testFileName, @NotNull String testPackageName) {
        GoFile testFile;
        if (project == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(21);
        }
        if (dir == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(22);
        }
        if (testFileName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(23);
        }
        if (testPackageName == null) {
            GoGeneratingTestCreator.$$$reportNull$$$0(24);
        }
        if ((testFile = (GoFile)((Object)ObjectUtils.tryCast((Object)dir.findFile(testFileName), GoFile.class))) == null) {
            testFile = GoRefactoringUtil.createFile(dir, testFileName, testPackageName, project);
        } else if (testFile.getImportList() == null) {
            testFile.delete();
            testFile = GoRefactoringUtil.createFile(dir, testFileName, testPackageName, project);
        }
        return testFile;
    }

    static boolean canGenerateTest(@Nullable GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            return false;
        }
        return !function.isBlank() && function.getName() != null && !GoPsiUtil.isMainOrInitFunction(function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFunctionName";
                break;
            }
            case 2: 
            case 11: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFileName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/creator/GoGeneratingTestCreator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPackageName";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/creator/GoGeneratingTestCreator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigateToGeneratedFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFile";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtraParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateTests";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateTestFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }
}

