/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gocheck;

import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFramework;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.frameworks.gocheck.GocheckEventsConverter;
import com.goide.execution.testing.frameworks.gocheck.GocheckRunningState;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.stubs.index.GoPackagesIndex;
import com.goide.util.GoUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GocheckFramework
extends GoTestFramework {
    @NonNls
    public static final String NAME = "gocheck";
    public static final GocheckFramework INSTANCE = new GocheckFramework();
    private static final Pattern GO_CHECK_IMPORT_PATH = Pattern.compile("gopkg\\.in/check\\.v\\d+");
    private static final Pattern GO_CHECK_GITHUB_IMPORT_PATH = Pattern.compile("github\\.com/go-check/check(\\.v\\d+)?");

    private GocheckFramework() {
    }

    @Nullable
    public static String getGocheckTestName(@NotNull GoMethodDeclaration method) {
        String methodName;
        if (method == null) {
            GocheckFramework.$$$reportNull$$$0(0);
        }
        String string = methodName = GoTestFunctionType.fromName(method.getName()) == GoTestFunctionType.TEST ? method.getName() : null;
        if (methodName != null) {
            String suiteName;
            GoType type = GoPsiImplUtil.unwrapPointerIfNeeded(method.getReceiverType());
            String string2 = suiteName = type != null ? type.getPresentationText() : "";
            if (!suiteName.isEmpty()) {
                return suiteName + "." + methodName;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isAvailable(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        return (Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> !StubIndex.getInstance().processElements(GoPackagesIndex.KEY, (Object)"check", module.getProject(), GoUtil.goPathResolveScope(module, null), GoFile.class, file2 -> !GocheckFramework.isGoCheckImportPath(file2.getImportPath(true))));
    }

    private static boolean isGoCheckImportPath(String importPath) {
        if (importPath == null) {
            return false;
        }
        return GO_CHECK_IMPORT_PATH.matcher(importPath).matches() || GO_CHECK_GITHUB_IMPORT_PATH.matcher(importPath).matches();
    }

    @Override
    public boolean isAvailableOnFile(@Nullable PsiFile file2) {
        if (!GoTestFinder.isTestFile(file2)) {
            return false;
        }
        for (String importPath : ((GoFile)file2).getImportedPackagesMap().keySet()) {
            if (!GocheckFramework.isGoCheckImportPath(importPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailableOnFunction(@Nullable GoFunctionOrMethodDeclaration functionOrMethodDeclaration) {
        return functionOrMethodDeclaration instanceof GoMethodDeclaration && GoTestFinder.isTestOrExampleFunction(functionOrMethodDeclaration);
    }

    @Override
    @NotNull
    protected GoTestRunningState newRunningState(@NotNull ExecutionEnvironment env, @NotNull Module module, @NotNull GoTestRunConfiguration runConfiguration) {
        if (env == null) {
            GocheckFramework.$$$reportNull$$$0(1);
        }
        if (module == null) {
            GocheckFramework.$$$reportNull$$$0(2);
        }
        if (runConfiguration == null) {
            GocheckFramework.$$$reportNull$$$0(3);
        }
        return new GocheckRunningState(env, module, runConfiguration);
    }

    @Override
    @NotNull
    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String defaultImportPath, @NotNull TestConsoleProperties consoleProperties, @Nullable Module module) {
        if (defaultImportPath == null) {
            GocheckFramework.$$$reportNull$$$0(4);
        }
        if (consoleProperties == null) {
            GocheckFramework.$$$reportNull$$$0(5);
        }
        return new GocheckEventsConverter(defaultImportPath, consoleProperties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/testing/frameworks/gocheck/GocheckFramework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGocheckTestName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "newRunningState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestEventsConverter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

