/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.exitpoint;

import com.goide.psi.GoBreakStatement;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoContinueStatement;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoSwitchStart;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBreakAndContinueStatementsExitPointHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    @NotNull
    private final PsiElement myTarget;
    @Nullable
    private final GoStatement myStatement;
    @Nullable
    private final PsiElement myOwner;

    private GoBreakAndContinueStatementsExitPointHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement target, @Nullable GoStatement statement, @Nullable PsiElement owner) {
        if (editor == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(2);
        }
        super(editor, file2);
        this.myTarget = target;
        this.myStatement = statement;
        this.myOwner = owner;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(4);
        }
        if (selectionConsumer == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(5);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiElement parent;
        if (targets == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(6);
        }
        final PsiElement statementOwner = this.findOwner();
        GoRecursiveVisitor visitor2 = new GoRecursiveVisitor(){

            @Override
            public void visitLabelDefinition(@NotNull GoLabelDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o == statementOwner) {
                    GoBreakAndContinueStatementsExitPointHandler.this.addOccurrence(o);
                }
                super.visitLabelDefinition(o);
            }

            @Override
            public void visitBreakStatement(@NotNull GoBreakStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (o == GoBreakAndContinueStatementsExitPointHandler.this.myStatement || GoBreakAndContinueStatementsExitPointHandler.getStatementOwnerOrResolve(o) == statementOwner) {
                    GoBreakAndContinueStatementsExitPointHandler.this.addOccurrence(o);
                }
                super.visitBreakStatement(o);
            }

            @Override
            public void visitContinueStatement(@NotNull GoContinueStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (o == GoBreakAndContinueStatementsExitPointHandler.this.myStatement || GoBreakAndContinueStatementsExitPointHandler.getStatementOwnerOrResolve(o) == statementOwner) {
                    GoBreakAndContinueStatementsExitPointHandler.this.addOccurrence(o);
                }
                super.visitContinueStatement(o);
            }

            @Override
            public void visitSwitchStatement(@NotNull GoSwitchStatement o) {
                GoSwitchStart switchStart;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (o == statementOwner && (switchStart = o.getSwitchStart()) != null) {
                    GoBreakAndContinueStatementsExitPointHandler.this.addOccurrence(switchStart.getSwitch());
                }
                super.visitSwitchStatement(o);
            }

            @Override
            public void visitForStatement(@NotNull GoForStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (o == statementOwner) {
                    GoBreakAndContinueStatementsExitPointHandler.this.addOccurrence(o.getFor());
                }
                super.visitForStatement(o);
            }

            @Override
            public void visitSelectStatement(@NotNull GoSelectStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (o == statementOwner) {
                    GoBreakAndContinueStatementsExitPointHandler.this.addOccurrence(o.getSelect());
                }
                super.visitSelectStatement(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/highlighting/exitpoint/GoBreakAndContinueStatementsExitPointHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLabelDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBreakStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitContinueStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSelectStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (statementOwner != null && (parent = statementOwner.getParent()) instanceof GoCompositeElement) {
            visitor2.visitCompositeElement((GoCompositeElement)parent);
        }
    }

    @Nullable
    private PsiElement findOwner() {
        if (this.myOwner != null) {
            return this.myOwner;
        }
        if (this.myStatement != null) {
            return GoBreakAndContinueStatementsExitPointHandler.getStatementOwnerOrResolve(this.myStatement);
        }
        return null;
    }

    @Nullable
    public static PsiElement getStatementOwnerOrResolve(@NotNull GoStatement statement) {
        if (statement == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(7);
        }
        if (statement instanceof GoBreakStatement) {
            GoLabelRef label = ((GoBreakStatement)statement).getLabelRef();
            return label != null ? label.getReference().resolve() : GoPsiUtil.getBreakStatementOwner(statement);
        }
        if (statement instanceof GoContinueStatement) {
            GoLabelRef label = ((GoContinueStatement)statement).getLabelRef();
            return label != null ? label.getReference().resolve() : GoPsiUtil.getContinueStatementOwner(statement);
        }
        return null;
    }

    @Nullable
    public static GoBreakAndContinueStatementsExitPointHandler createForElement(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement element) {
        GoStatement target;
        if (editor == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(9);
        }
        if (element == null) {
            GoBreakAndContinueStatementsExitPointHandler.$$$reportNull$$$0(10);
        }
        if ((target = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoBreakStatement.class, GoSwitchStatement.class, GoSelectStatement.class, GoForStatement.class, GoContinueStatement.class})) == null) {
            return null;
        }
        return target instanceof GoBreakStatement || target instanceof GoContinueStatement ? new GoBreakAndContinueStatementsExitPointHandler(editor, file2, element, target, null) : new GoBreakAndContinueStatementsExitPointHandler(editor, file2, element, null, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/exitpoint/GoBreakAndContinueStatementsExitPointHandler";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/exitpoint/GoBreakAndContinueStatementsExitPointHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStatementOwnerOrResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createForElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

