/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.generics.GoAbstractConstraintTerm;
import com.goide.psi.impl.generics.GoTypeSet;
import com.goide.psi.impl.generics.GoTypeSetKt;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.Complex;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoInvalidExpressionConversionInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoInvalidExpressionConversionInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(1);
        }
        super.visitCallExpr(callExpr);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(callExpr);
        this.visitConversionExpression(callExpr, callExpr.getArgumentList().getExpressionList(), context);
    }

    @Override
    public void visitBuiltinCallExpr(@NotNull GoBuiltinCallExpr builtinCallExpr) {
        if (builtinCallExpr == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(2);
        }
        super.visitBuiltinCallExpr(builtinCallExpr);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(builtinCallExpr);
        this.visitConversionExpression(builtinCallExpr, builtinCallExpr.getBuiltinArgumentList().getExpressionList(), context);
    }

    @Override
    public void visitConversionExpr(@NotNull GoConversionExpr conversionExpr) {
        if (conversionExpr == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(3);
        }
        super.visitConversionExpr(conversionExpr);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(conversionExpr);
        this.visitConversionExpression(conversionExpr, Collections.singletonList(conversionExpr.getExpression()), context);
    }

    private void visitConversionExpression(@NotNull GoExpression expr, @NotNull List<GoExpression> args, @Nullable PsiElement context) {
        GoType argType;
        if (expr == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(4);
        }
        if (args == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(5);
        }
        if (!GoPsiUtil.isConversionExpression(expr)) {
            return;
        }
        GoType conversionType = expr.getGoType(null);
        if (conversionType == null) {
            return;
        }
        GoExpression arg = (GoExpression)ContainerUtil.getOnlyItem(args);
        GoType goType = argType = arg != null ? arg.getGoType(null) : null;
        if (argType == null) {
            return;
        }
        GoInspectionMessage error = GoInvalidExpressionConversionInspection.getInvalidConversionTypeError(conversionType, context);
        if (error != null) {
            this.myHolder.registerProblem((PsiElement)expr, error, new LocalQuickFix[0]);
            return;
        }
        if (GoInvalidExpressionConversionInspection.isValidConversion(arg, argType, conversionType, false, context) == ThreeState.NO) {
            String argTypeText = argType.getText();
            String conversionTypeText = conversionType.getText();
            GoInspectionMessage message = GoExpressionUtil.isNil(arg) && StringUtil.isNotEmpty((String)conversionTypeText) ? GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.nil", GoInspectionProblemUtil.code(conversionTypeText)) : (StringUtil.isNotEmpty((String)argTypeText) && StringUtil.isNotEmpty((String)conversionTypeText) ? GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.expression", GoInspectionProblemUtil.code(argTypeText), GoInspectionProblemUtil.code(conversionTypeText)) : GoInspectionProblemUtil.message("go.inspection.problem.invalid.conversion"));
            this.myHolder.registerProblem((PsiElement)expr, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    public static GoInspectionMessage getInvalidConversionTypeError(@NotNull GoType conversionType, @Nullable PsiElement context) {
        GoType unwrappedPtr;
        if (conversionType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(6);
        }
        if (GoTypeUtil.isTypeParameter(unwrappedPtr = GoTypeUtil.unwrapPointerAndParTypes(conversionType), context)) {
            return null;
        }
        GoType underlyingConversionType = unwrappedPtr.getUnderlyingType(context);
        GoInterfaceType underlyingInterface = (GoInterfaceType)ObjectUtils.tryCast((Object)underlyingConversionType, GoInterfaceType.class);
        GoInterfaceType invalidConversionType = GoTypeUtil.findFirstMatchedInterfaceDfs(underlyingInterface, iface -> !GoTypeUtil.isBasicInterface(iface, context));
        if (invalidConversionType != null) {
            return GoTypeUtil.isBuiltinComparable(invalidConversionType, context) ? GoInspectionProblemUtil.message("go.inspection.problem.invalid.conversion.type.comparable") : GoInspectionProblemUtil.message("go.inspection.problem.invalid.conversion.type.with.constraints");
        }
        return null;
    }

    @NotNull
    public static ThreeState isValidConversion(@Nullable GoTypeOwner expressionOrNil, @NotNull GoType expressionType, @NotNull GoType conversionType, boolean strict, @Nullable PsiElement context) {
        if (expressionType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(7);
        }
        if (conversionType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(8);
        }
        if (GoTypeUtil.isUnsafePointerType(conversionType, context)) {
            if (expressionType.getUnderlyingType(context) instanceof GoCType) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(9);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.fromBoolean((GoExpressionUtil.isNil(expressionOrNil) || GoInvalidExpressionConversionInspection.canConvertToUnsafePointer(expressionType, context) ? 1 : 0) != 0);
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(10);
            }
            return threeState;
        }
        if (GoTypeUtil.isUnsafePointerType(expressionType, context)) {
            if (conversionType.getUnderlyingType(context) instanceof GoCType) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(11);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.canConvertToUnsafePointer(conversionType, context));
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(12);
            }
            return threeState;
        }
        GoExpression expression = (GoExpression)ObjectUtils.tryCast((Object)expressionOrNil, GoExpression.class);
        if (expression != null && expression.isConstant()) {
            return GoInvalidExpressionConversionInspection.isValidConstExpressionConversion(expression, expressionType, conversionType, strict, context);
        }
        ThreeState threeState = ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.isValidNonConstExpressionConversion(expressionOrNil, expressionType, conversionType, strict, context));
        if (threeState == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(13);
        }
        return threeState;
    }

    private static boolean canConvertToUnsafePointer(@NotNull GoType type, @Nullable PsiElement context) {
        GoType underlyingType;
        if (type == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(14);
        }
        return (underlyingType = type.getUnderlyingType(context)) instanceof GoPointerType || GoTypeUtil.isUintptr(underlyingType, context);
    }

    @NotNull
    public static ThreeState isValidConstExpressionConversion(@NotNull GoExpression constExpr, @NotNull GoType constExprType, @NotNull GoType conversionType, boolean strict, @Nullable PsiElement context) {
        Value constExprValue;
        if (constExpr == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(15);
        }
        if (constExprType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(16);
        }
        if (conversionType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(17);
        }
        if ((constExprValue = constExpr.getValue()) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(18);
            }
            return threeState;
        }
        GoType constUnderlyingType = constExprType.getUnderlyingType(context);
        GoType conversionUnderlyingType = conversionType.getUnderlyingType(context);
        GoInterfaceType interfaceType = (GoInterfaceType)ObjectUtils.tryCast((Object)conversionUnderlyingType, GoInterfaceType.class);
        if (interfaceType != null && GoTypeUtil.isTypeParameter(conversionType, context)) {
            return GoInvalidExpressionConversionInspection.getMostNegativeStateForTypeSet(interfaceType, termType -> GoInvalidExpressionConversionInspection.isValidConstExpressionConversion(constExpr, constExprType, termType, strict, context));
        }
        ThreeState representable = GoInvalidExpressionConversionInspection.isRepresentable(constExprValue, constExprType, conversionType, strict, context);
        if (representable == ThreeState.YES) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(19);
            }
            return threeState;
        }
        if (GoTypeUtil.isIntegerType(constUnderlyingType, context) && GoTypeUtil.isString(conversionUnderlyingType, context) || GoInvalidExpressionConversionInspection.isValidStringToSlice(constUnderlyingType, conversionUnderlyingType, context)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(20);
            }
            return threeState;
        }
        ThreeState threeState = representable == ThreeState.UNSURE ? ThreeState.UNSURE : ThreeState.NO;
        if (threeState == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(21);
        }
        return threeState;
    }

    @NotNull
    public static ThreeState isRepresentable(@NotNull GoTypeOwner constExpr, @NotNull GoType constExprType, @NotNull GoType targetType, boolean strict, @Nullable PsiElement context) {
        if (constExpr == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(22);
        }
        if (constExprType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(23);
        }
        if (targetType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(24);
        }
        Value value2 = null;
        if (constExpr instanceof GoExpression) {
            value2 = ((GoExpression)constExpr).getValue();
        } else if (constExpr instanceof GoConstDefinition) {
            value2 = ((GoConstDefinition)constExpr).getValue();
        }
        return GoInvalidExpressionConversionInspection.isRepresentable(value2, constExprType, targetType, strict, context);
    }

    @NotNull
    public static ThreeState isRepresentable(@Nullable Value<?> constExprValue, @NotNull GoType constExprType, @NotNull GoType targetType, boolean strict, @Nullable PsiElement context) {
        if (constExprType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(25);
        }
        if (targetType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(26);
        }
        if (constExprValue == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(27);
            }
            return threeState;
        }
        GoType originalType = targetType;
        if ((targetType = targetType.getUnderlyingType(context)) instanceof GoCType) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(28);
            }
            return threeState;
        }
        if (targetType instanceof GoInterfaceType) {
            if (GoTypeUtil.isTypeParameter(originalType, context)) {
                GoType constExprTypeFinal = constExprType;
                return GoInvalidExpressionConversionInspection.getMostNegativeStateForTypeSet((GoInterfaceType)targetType, termType -> GoInvalidExpressionConversionInspection.isRepresentable(constExprValue, constExprTypeFinal, termType, strict, context));
            }
            ThreeState threeState = ThreeState.fromBoolean((boolean)GoTypeUtil.isImplementsInterface(targetType, constExprType, strict, context));
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(29);
            }
            return threeState;
        }
        if (targetType.getTypeReferenceExpression() != null && targetType.resolve(context) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(30);
            }
            return threeState;
        }
        if (GoTypeUtil.isBoolean(constExprType = constExprType.getUnderlyingType(context), context)) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)GoTypeUtil.isBoolean(targetType, context));
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(31);
            }
            return threeState;
        }
        if (GoTypeUtil.isString(constExprType, context)) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)GoTypeUtil.isString(targetType, context));
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(32);
            }
            return threeState;
        }
        if (GoTypeUtil.isIntegerType(constExprType, context)) {
            Long integerValue = constExprValue.getInteger();
            if (integerValue == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(33);
                }
                return threeState;
            }
            if (GoTypeUtil.isIntegerType(targetType, context)) {
                return GoInvalidExpressionConversionInspection.checkIntegerToInteger(integerValue, targetType, context);
            }
            if (GoTypeUtil.isTypedFloatType(targetType, context)) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.checkIntegerToFloat(integerValue, GoTypeUtil.isFloat32(targetType, context)));
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(34);
                }
                return threeState;
            }
            if (GoTypeUtil.isTypedComplexType(targetType, context)) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.checkIntegerToFloat(integerValue, GoTypeUtil.isComplex64(targetType, context)));
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(35);
                }
                return threeState;
            }
        }
        if (GoTypeUtil.isFloatType(constExprType, context)) {
            Double doubleValue = constExprValue.getDouble();
            if (doubleValue == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(36);
                }
                return threeState;
            }
            if (GoTypeUtil.isIntegerType(targetType, context)) {
                return GoInvalidExpressionConversionInspection.checkFloatToInteger(doubleValue, targetType, context);
            }
            if (GoTypeUtil.isTypedFloatType(targetType, context)) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.checkFloatToFloat(doubleValue, GoTypeUtil.isFloat32(targetType, context)));
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(37);
                }
                return threeState;
            }
            if (GoTypeUtil.isTypedComplexType(targetType, context)) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.checkFloatToFloat(doubleValue, GoTypeUtil.isComplex64(targetType, context)));
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(38);
                }
                return threeState;
            }
        }
        if (GoTypeUtil.isComplexType(constExprType, context)) {
            Complex complexValue = constExprValue.getComplex();
            if (complexValue == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(39);
                }
                return threeState;
            }
            if (GoTypeUtil.isIntegerType(targetType, context)) {
                ThreeState threeState = complexValue.im() == 0.0 ? GoInvalidExpressionConversionInspection.checkFloatToInteger(complexValue.re(), targetType, context) : ThreeState.NO;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(40);
                }
                return threeState;
            }
            if (GoTypeUtil.isTypedFloatType(targetType, context)) {
                ThreeState threeState = complexValue.im() == 0.0 ? ThreeState.fromBoolean((boolean)GoInvalidExpressionConversionInspection.checkFloatToFloat(complexValue.re(), GoTypeUtil.isFloat32(targetType, context))) : ThreeState.NO;
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(41);
                }
                return threeState;
            }
            if (GoTypeUtil.isTypedComplexType(targetType, context)) {
                boolean componentsCheck = GoInvalidExpressionConversionInspection.checkFloatToFloat(complexValue.re(), GoTypeUtil.isComplex64(targetType, context)) && GoInvalidExpressionConversionInspection.checkFloatToFloat(complexValue.im(), GoTypeUtil.isComplex64(targetType, context));
                ThreeState threeState = ThreeState.fromBoolean((boolean)componentsCheck);
                if (threeState == null) {
                    GoInvalidExpressionConversionInspection.$$$reportNull$$$0(42);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(43);
        }
        return threeState;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ThreeState checkIntegerToInteger(long integerConstValue, @NotNull GoType integerTargetType, @Nullable PsiElement psiElement) {
        void context;
        Pair<Long, Long> limits;
        if (integerTargetType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(44);
        }
        if ((limits = GoTypeUtil.getIntegerTypeLimits(integerTargetType, (PsiElement)context)) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(45);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.fromBoolean(((Long)limits.first <= integerConstValue && integerConstValue <= (Long)limits.second ? 1 : 0) != 0);
        if (threeState == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(46);
        }
        return threeState;
    }

    private static boolean checkIntegerToFloat(long integerConstValue, boolean targetIsFloat32) {
        return targetIsFloat32 && Float.isFinite(integerConstValue) || Double.isFinite(integerConstValue);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ThreeState checkFloatToInteger(double floatConstValue, @NotNull GoType integerTargetType, @Nullable PsiElement psiElement) {
        void context;
        if (integerTargetType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(47);
        }
        if (!Double.isFinite(floatConstValue) || Math.rint(floatConstValue) != floatConstValue) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(48);
            }
            return threeState;
        }
        Pair<Long, Long> limits = GoTypeUtil.getIntegerTypeLimits(integerTargetType, (PsiElement)context);
        if (limits == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(49);
            }
            return threeState;
        }
        if (!(-9.223372036854776E18 <= floatConstValue) || !(floatConstValue <= 9.223372036854776E18)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(50);
            }
            return threeState;
        }
        long integerConstValue = (long)floatConstValue;
        ThreeState threeState = ThreeState.fromBoolean(((Long)limits.first <= integerConstValue && integerConstValue <= (Long)limits.second ? 1 : 0) != 0);
        if (threeState == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(51);
        }
        return threeState;
    }

    private static boolean checkFloatToFloat(double floatConstValue, boolean targetIsFloat32) {
        return !targetIsFloat32 || Float.isFinite((float)floatConstValue);
    }

    private static boolean isValidNonConstExpressionConversion(@Nullable GoTypeOwner typeOwner, @NotNull GoType expressionType, @NotNull GoType conversionType, boolean strict, @Nullable PsiElement context) {
        GoSdkVersion targetGoSdkVersion;
        boolean isValidToString;
        boolean isBothIntegerOrFloat;
        boolean isIdenticalPtrBaseTypes;
        if (expressionType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(52);
        }
        if (conversionType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(53);
        }
        if (GoTypeUtil.isAssignable(conversionType, typeOwner, expressionType, strict)) {
            return true;
        }
        if (GoExpressionUtil.isNil(typeOwner)) {
            return false;
        }
        GoType exprUnderlyingType = expressionType.getUnderlyingType(context);
        GoType conversionUnderlyingType = conversionType.getUnderlyingType(context);
        boolean expressionIsTypeParameter = GoTypeUtil.isTypeParameter(expressionType, context);
        boolean conversionIsTypeParameter = GoTypeUtil.isTypeParameter(conversionType, context);
        if (!expressionIsTypeParameter && !conversionIsTypeParameter && GoTypeUtil.identical(exprUnderlyingType, conversionUnderlyingType, strict, true, context)) {
            return true;
        }
        GoType exprPtrTypeBaseType = GoInvalidExpressionConversionInspection.getBaseTypeIfPointerOrPointerAlias(expressionType, context);
        GoType conversionPtrTypeBaseType = GoInvalidExpressionConversionInspection.getBaseTypeIfPointerOrPointerAlias(conversionType, context);
        boolean bl = isIdenticalPtrBaseTypes = exprPtrTypeBaseType != null && conversionPtrTypeBaseType != null && !GoTypeUtil.isTypeParameter(exprPtrTypeBaseType, context) && !GoTypeUtil.isTypeParameter(conversionPtrTypeBaseType, context) && GoTypeUtil.identical(exprPtrTypeBaseType.getUnderlyingType(context), conversionPtrTypeBaseType.getUnderlyingType(context), strict, true, context);
        if (isIdenticalPtrBaseTypes) {
            return true;
        }
        boolean bl2 = isBothIntegerOrFloat = !(!GoTypeUtil.isIntegerType(exprUnderlyingType, context) && !GoTypeUtil.isFloatType(exprUnderlyingType, context) || !GoTypeUtil.isIntegerType(conversionUnderlyingType, context) && !GoTypeUtil.isFloatType(conversionUnderlyingType, context));
        if (isBothIntegerOrFloat) {
            return true;
        }
        if (GoTypeUtil.isComplexType(exprUnderlyingType, context) && GoTypeUtil.isComplexType(conversionUnderlyingType, context)) {
            return true;
        }
        boolean bl3 = isValidToString = GoTypeUtil.isString(conversionUnderlyingType, context) && (GoTypeUtil.isIntegerType(exprUnderlyingType, context) || GoTypeUtil.isByteSlice(exprUnderlyingType, context) || GoTypeUtil.isRuneSlice(exprUnderlyingType, context));
        if (isValidToString) {
            return true;
        }
        if (GoInvalidExpressionConversionInspection.isValidStringToSlice(exprUnderlyingType, conversionUnderlyingType, context)) {
            return true;
        }
        GoSdk sdk = GoSdkService.getInstance(expressionType.getProject()).getSdk(GoUtil.module(context));
        if (sdk.supportsSliceToArrayPointerConversion() && ((targetGoSdkVersion = GoInvalidExpressionConversionInspection.fileSDKVersion(typeOwner, expressionType, context)) == null || targetGoSdkVersion.supportsSliceToArrayPointerConversion()) && GoInvalidExpressionConversionInspection.isValidSliceToArrayPointer(exprUnderlyingType, conversionUnderlyingType, strict, context)) {
            return true;
        }
        if (sdk.supportsSliceToArrayConversion() && ((targetGoSdkVersion = GoInvalidExpressionConversionInspection.fileSDKVersion(typeOwner, expressionType, context)) == null || targetGoSdkVersion.supportsSliceToArrayConversion()) && GoInvalidExpressionConversionInspection.isValidSliceToArray(exprUnderlyingType, conversionUnderlyingType, strict, context)) {
            return true;
        }
        if (expressionIsTypeParameter && conversionIsTypeParameter) {
            return GoTypeUtil.matchTypeConstraints(expressionType.getUnderlyingType(context), context, expressionTypeTerm -> GoTypeUtil.matchTypeConstraints(conversionType.getUnderlyingType(context), context, conversionTypeTerm -> GoInvalidExpressionConversionInspection.isValidNonConstExpressionConversion(typeOwner, expressionTypeTerm, conversionTypeTerm, strict, context)));
        }
        if (expressionIsTypeParameter) {
            return GoTypeUtil.matchTypeConstraints(expressionType.getUnderlyingType(context), context, t -> GoInvalidExpressionConversionInspection.isValidNonConstExpressionConversion(typeOwner, t, conversionType, strict, context));
        }
        if (conversionIsTypeParameter) {
            return GoTypeUtil.matchTypeConstraints(conversionType.getUnderlyingType(context), context, t -> GoInvalidExpressionConversionInspection.isValidNonConstExpressionConversion(typeOwner, expressionType, t, strict, context));
        }
        return false;
    }

    @Nullable
    private static GoSdkVersion fileSDKVersion(@Nullable GoTypeOwner typeOwner, @NotNull GoType exprType, @Nullable PsiElement context) {
        if (exprType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(54);
        }
        PsiFile file2 = context != null ? context.getContainingFile() : ((GoCompositeElement)ObjectUtils.notNull((Object)typeOwner, (Object)exprType)).getContainingFile();
        return GoTargetSdkVersionProvider.getTargetGoSdkVersion((PsiElement)file2);
    }

    private static boolean isValidStringToSlice(@Nullable GoType from2, @Nullable GoType to, @Nullable PsiElement context) {
        return GoTypeUtil.isString(from2, context) && (GoTypeUtil.isByteSlice(to, context) || GoTypeUtil.isRuneSlice(to, context));
    }

    @Nullable
    private static GoType getBaseTypeIfPointerOrPointerAlias(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(55);
        }
        while (type != null && !(type instanceof GoPointerType)) {
            PsiElement resolve = type.resolve(context);
            GoTypeSpec typeSpec = resolve instanceof GoTypeSpec ? (GoTypeSpec)resolve : null;
            type = typeSpec != null && typeSpec.isTypeAlias() ? typeSpec.getSpecType().getType() : null;
        }
        return GoTypeUtil.getBasePointerType(type, context);
    }

    private static boolean isValidSliceToArrayPointer(@Nullable GoType from2, @Nullable GoType to, boolean strict, @Nullable PsiElement context) {
        if (from2 == null || to == null) {
            return !strict;
        }
        GoArrayOrSliceType sliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)from2, GoArrayOrSliceType.class);
        if (sliceType == null || sliceType.isArray()) {
            return false;
        }
        GoType baseTypeOfPointer = GoInvalidExpressionConversionInspection.getBaseTypeIfPointerOrPointerAlias(to, context);
        GoType baseUType = baseTypeOfPointer != null ? baseTypeOfPointer.getUnderlyingType(context) : null;
        GoArrayOrSliceType arrayType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)baseUType, GoArrayOrSliceType.class);
        if (arrayType == null || !arrayType.isArray()) {
            return false;
        }
        return GoTypeUtil.identical(sliceType.getType(), arrayType.getType(), strict, context);
    }

    private static boolean isValidSliceToArray(@Nullable GoType from2, @Nullable GoType to, boolean strict, @Nullable PsiElement context) {
        if (from2 == null || to == null) {
            return !strict;
        }
        GoArrayOrSliceType sliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)from2, GoArrayOrSliceType.class);
        if (sliceType == null || sliceType.isArray()) {
            return false;
        }
        GoArrayOrSliceType arrayType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)to, GoArrayOrSliceType.class);
        if (arrayType == null || !arrayType.isArray()) {
            return false;
        }
        return GoTypeUtil.identical(sliceType.getType(), arrayType.getType(), strict, context);
    }

    private static ThreeState mostNegative(@NotNull ThreeState s1, @NotNull ThreeState s2) {
        if (s1 == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(56);
        }
        if (s2 == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(57);
        }
        if (s1 == ThreeState.NO || s2 == ThreeState.NO) {
            return ThreeState.NO;
        }
        return s1 == ThreeState.UNSURE ? ThreeState.UNSURE : s2;
    }

    @NotNull
    private static ThreeState getMostNegativeStateForTypeSet(@NotNull GoInterfaceType constraintType, @NotNull @NotNull Function<@NotNull GoType, @NotNull ThreeState> termStateFn) {
        GoTypeSet typeSet;
        if (constraintType == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(58);
        }
        if (termStateFn == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(59);
        }
        if ((typeSet = GoTypeSetKt.computeTypeSet(constraintType, ResolveState.initial())) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(60);
            }
            return threeState;
        }
        GoTypeSet.Terms termsTypeSet = (GoTypeSet.Terms)ObjectUtils.tryCast((Object)typeSet, GoTypeSet.Terms.class);
        if (termsTypeSet == null) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(61);
            }
            return threeState;
        }
        List<GoAbstractConstraintTerm> terms = termsTypeSet.getTerms();
        if (terms.isEmpty()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                GoInvalidExpressionConversionInspection.$$$reportNull$$$0(62);
            }
            return threeState;
        }
        ThreeState result = ThreeState.YES;
        for (GoAbstractConstraintTerm term : terms) {
            GoType termType = term.getType();
            ThreeState termState = termStateFn.apply(termType);
            result = GoInvalidExpressionConversionInspection.mostNegative(result, termState);
            if (termState != ThreeState.NO) continue;
            break;
        }
        ThreeState threeState = result;
        if (threeState == null) {
            GoInvalidExpressionConversionInspection.$$$reportNull$$$0(63);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 18, 19, 20, 21, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 60, 61, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtinCallExpr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conversionExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 8: 
            case 17: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conversionType";
                break;
            }
            case 7: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidExpressionConversionInspection";
                break;
            }
            case 14: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constExpr";
                break;
            }
            case 16: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constExprType";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "integerTargetType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprType";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintType";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termStateFn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidExpressionConversionInspection";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isValidConversion";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "isValidConstExpressionConversion";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "isRepresentable";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIntegerToInteger";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFloatToInteger";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostNegativeStateForTypeSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpr";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitBuiltinCallExpr";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitConversionExpr";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitConversionExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidConversionTypeError";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidConversion";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canConvertToUnsafePointer";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidConstExpressionConversion";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isRepresentable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkIntegerToInteger";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkFloatToInteger";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isValidNonConstExpressionConversion";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fileSDKVersion";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypeIfPointerOrPointerAlias";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "mostNegative";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getMostNegativeStateForTypeSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 18, 19, 20, 21, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 60, 61, 62, 63 -> new IllegalStateException(string);
        };
    }
}

