/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoInvalidTildeInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoInvalidTildeInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoInvalidTildeInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitUnaryExpr(@NotNull GoUnaryExpr o) {
        if (o == null) {
            GoInvalidTildeInspection.$$$reportNull$$$0(1);
        }
        this.checkExpression(o);
    }

    @Override
    public void visitBinaryExpr(@NotNull GoBinaryExpr o) {
        if (o == null) {
            GoInvalidTildeInspection.$$$reportNull$$$0(2);
        }
        this.checkExpression(o);
    }

    private void checkExpression(@NotNull GoExpression o) {
        ASTNode tilde;
        if (o == null) {
            GoInvalidTildeInspection.$$$reportNull$$$0(3);
        }
        if ((tilde = o.getNode().findChildByType(GoTypes.TILDE)) != null) {
            this.myHolder.registerProblem(tilde.getPsi(), GoInspectionProblemUtil.message("go.error.parser.unexpected", "~"), new ReplaceTildaByBitwiseNotQuickFix());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidTildeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceTildaByBitwiseNotQuickFix
    implements LocalQuickFix {
        private ReplaceTildaByBitwiseNotQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.replace.tilda.with.hat.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceTildaByBitwiseNotQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceTildaByBitwiseNotQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceTildaByBitwiseNotQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid() || element.getNode().getElementType() != GoTypes.TILDE) {
                return;
            }
            PsiElement error = element.getNextSibling();
            if (error instanceof PsiErrorElement) {
                error.delete();
            }
            element.replace(GoElementFactory.createUnaryOperatorFromText(project, "^"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidTildeInspection$ReplaceTildaByBitwiseNotQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidTildeInspection$ReplaceTildaByBitwiseNotQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

