/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.generate.GoGenerateTestActionBase;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestSignaturesInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoTestSignaturesInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoTestSignaturesInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitGoFile(@NotNull GoFile file2) {
        if (file2 == null) {
            GoTestSignaturesInspection.$$$reportNull$$$0(1);
        }
        if (!GoTestFinder.isTestFile((PsiFile)file2)) {
            return;
        }
        String testingQualifier = GoTestSignaturesInspection.getTestingPackageQualifier(file2);
        for (GoFunctionDeclaration goFunctionDeclaration : file2.getFunctions()) {
            GoSignature signature;
            GoTestFunctionType type = GoTestFunctionType.fromName(goFunctionDeclaration.getName());
            if (type == null || (signature = goFunctionDeclaration.getSignature()) == null) continue;
            if (type == GoTestFunctionType.EXAMPLE) {
                if (GoTestSignaturesInspection.isValidExampleSignature(signature)) continue;
                this.myHolder.registerProblem(goFunctionDeclaration.getIdentifier(), GoInspectionProblemUtil.message("go.inspection.problem.wrong.example.signature"), new GoTestSignaturesQuickFix(type));
                continue;
            }
            if (GoTestSignaturesInspection.isValidTestOrBenchmarkSignature(goFunctionDeclaration, type, testingQualifier)) continue;
            this.myHolder.registerProblem(goFunctionDeclaration.getIdentifier(), GoInspectionProblemUtil.message("go.inspection.problem.wrong.test.signature"), new GoTestSignaturesQuickFix(type));
        }
    }

    @Nullable
    public static String getTestingPackageQualifier(@NotNull GoFile file2) {
        if (file2 == null) {
            GoTestSignaturesInspection.$$$reportNull$$$0(2);
        }
        GoImportSpec testingImportSpec = file2.getImportedPackagesMap().get("testing");
        String result = (String)ContainerUtil.getFirstItem(GoPsiImplUtil.getImportQualifiersToUseInFile(testingImportSpec));
        if ("testing".equals(file2.getPackageName()) && "testing".equals(file2.getImportPath(false))) {
            result = "";
        }
        return result;
    }

    public static boolean isValidExampleSignature(@NotNull GoSignature exampleSignature) {
        List<GoParameterDeclaration> params;
        if (exampleSignature == null) {
            GoTestSignaturesInspection.$$$reportNull$$$0(3);
        }
        return (params = exampleSignature.getParameters().getParameterDeclarationList()).isEmpty() && exampleSignature.getResult() == null;
    }

    public static boolean isValidTestOrBenchmarkSignature(@NotNull GoFunctionDeclaration function, @NotNull GoTestFunctionType testFunctionType, @Nullable String testingPackageQualifier) {
        if (function == null) {
            GoTestSignaturesInspection.$$$reportNull$$$0(4);
        }
        if (testFunctionType == null) {
            GoTestSignaturesInspection.$$$reportNull$$$0(5);
        }
        GoSignature signature = function.getSignature();
        if (testingPackageQualifier == null || signature == null || signature.getResult() != null) {
            return false;
        }
        GoParameterDeclaration param = (GoParameterDeclaration)ContainerUtil.getOnlyItem(signature.getParameters().getParameterDeclarationList());
        GoType type = param != null ? param.getType() : null;
        return type != null && type.textMatches(testFunctionType.getQualifiedParamType(testingPackageQualifier)) && param.getParamDefinitionList().size() <= 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleSignature";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFunctionType";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoTestSignaturesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGoFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestingPackageQualifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidExampleSignature";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidTestOrBenchmarkSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class GoTestSignaturesQuickFix
    implements LocalQuickFix {
        private final GoTestFunctionType myType;

        private GoTestSignaturesQuickFix(GoTestFunctionType type) {
            this.myType = type;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.signature.name", (Object[])new Object[0]);
            if (string == null) {
                GoTestSignaturesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            GoSignature signature;
            PsiElement element;
            if (project == null) {
                GoTestSignaturesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoTestSignaturesQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getStartElement()) == null || !element.isValid()) {
                return;
            }
            GoFunctionDeclaration function = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)element.getParent(), GoFunctionDeclaration.class);
            GoSignature goSignature = signature = function != null ? function.getSignature() : null;
            if (signature == null) {
                return;
            }
            GoFile file2 = (GoFile)((Object)ObjectUtils.tryCast((Object)signature.getContainingFile(), GoFile.class));
            if (file2 == null) {
                return;
            }
            String testingQualifier = GoGenerateTestActionBase.importTestingPackageIfNeeded(file2);
            signature.replace(GoElementFactory.createFunctionSignatureFromText(project, "", this.myType.getSignature(testingQualifier)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoTestSignaturesInspection$GoTestSignaturesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoTestSignaturesInspection$GoTestSignaturesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

