/*
 * Decompiled with CFR 0.152.
 */
package com.goide.index;

import com.goide.GoFileType;
import com.goide.GoParserDefinition;
import com.goide.codeInsight.imports.GoImport;
import com.goide.lexer.GoLexer;
import com.goide.util.GoIndexUtilKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLinkNameIndex
extends FileBasedIndexExtension<String, String> {
    public static final ID<String, String> KEY = ID.create((String)"go.linkname");
    private static final String GO_LINKNAME_PREFIX = "//go:linkname ";

    @NotNull
    public ID<String, String> getName() {
        ID<String, String> iD = KEY;
        if (iD == null) {
            GoLinkNameIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 8;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{GoFileType.INSTANCE});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        return new DataIndexer<String, String, FileContent>(this){

            @NotNull
            public Map<String, String> map(@NotNull FileContent inputData) {
                IElementType token;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!GoLinkNameIndex.importsUnsafe(inputData)) {
                    Map<String, String> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                HashMap<String, String> result = new HashMap<String, String>();
                GoLexer lexer = new GoLexer();
                lexer.start(inputData.getContentAsText());
                while ((token = lexer.getTokenType()) != null) {
                    String suffix;
                    String commentText;
                    if (token == GoParserDefinition.Lazy.LINE_COMMENT && (commentText = lexer.getTokenText()).startsWith(GoLinkNameIndex.GO_LINKNAME_PREFIX) && !(suffix = commentText.substring(GoLinkNameIndex.GO_LINKNAME_PREFIX.length()).trim()).isEmpty()) {
                        String importedSymbol;
                        String localName;
                        int localNameEnd = suffix.indexOf(32);
                        if (localNameEnd == -1) {
                            localName = suffix;
                            importedSymbol = "";
                        } else {
                            localName = suffix.substring(0, localNameEnd);
                            importedSymbol = suffix.substring(localNameEnd).trim();
                        }
                        result.merge(localName, importedSymbol, (existing, value2) -> existing + "\n" + value2);
                    }
                    lexer.advance();
                }
                HashMap<String, String> hashMap = result;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/index/GoLinkNameIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/index/GoLinkNameIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    public static String getSymbolName(@NotNull String localName, @NotNull GlobalSearchScope scope) {
        if (localName == null) {
            GoLinkNameIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            GoLinkNameIndex.$$$reportNull$$$0(2);
        }
        Ref result = Ref.create();
        FileBasedIndex.getInstance().processValues(KEY, (Object)localName, null, (file2, symbolNames) -> {
            String[] lines = StringUtil.splitByLines((String)symbolNames, (boolean)false);
            if (lines.length != 1) {
                result.set(null);
                return false;
            }
            List names = lines[0].isEmpty() ? List.of("") : StringUtil.split((String)lines[0], (String)" ");
            String loneName = (String)ContainerUtil.getOnlyItem((Collection)names);
            if (loneName == null) {
                result.set(null);
                return false;
            }
            if (!result.isNull()) {
                result.set(null);
                return false;
            }
            result.set((Object)loneName);
            return true;
        }, scope);
        return (String)result.get();
    }

    private static boolean importsUnsafe(@NotNull FileContent inputData) {
        Set<GoImport> imports;
        if (inputData == null) {
            GoLinkNameIndex.$$$reportNull$$$0(3);
        }
        return ContainerUtil.find(imports = GoIndexUtilKt.scanFileContent(inputData).getImports(), it -> "unsafe".equals(it.getImportPath())) != null;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            GoLinkNameIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            GoLinkNameIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/index/GoLinkNameIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/index/GoLinkNameIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importsUnsafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

