/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoBlock;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoReplaceWithSelectStatementQuickFix;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInfiniteForInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoInfiniteForInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoInfiniteForInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitForStatement(@NotNull GoForStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitForStatement(o);
                if (GoInfiniteForInspection.isInfiniteLoop(o)) {
                    holder.registerProblem((PsiElement)o, GoInfiniteForInspection.message("go.inspection.problem.infinite.for.loop", new Object[]{GoInfiniteForInspection.code("for")}), new GoReplaceWithSelectStatementQuickFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoInfiniteForInspection$1", "visitForStatement"));
            }
        };
    }

    private static boolean isInfiniteLoop(@NotNull GoForStatement forStatement) {
        GoBlock block;
        if (forStatement == null) {
            GoInfiniteForInspection.$$$reportNull$$$0(2);
        }
        if ((block = forStatement.getBlock()) == null || !block.getStatementList().isEmpty()) {
            return false;
        }
        GoRangeClause rangeClause = forStatement.getRangeClause();
        if (rangeClause != null) {
            return rangeClause.getExpressionList().isEmpty();
        }
        GoForClause forClause = forStatement.getForClause();
        if (forClause != null) {
            return GoInfiniteForInspection.isEmptyOrTrueCondition(forClause.getExpression());
        }
        return GoInfiniteForInspection.isEmptyOrTrueCondition(forStatement.getExpression());
    }

    private static boolean isEmptyOrTrueCondition(@Nullable GoExpression condition) {
        if (condition == null) {
            return true;
        }
        Value value2 = condition.getValue();
        Boolean boolValue = value2 != null ? value2.getBool() : null;
        return boolValue == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoInfiniteForInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInfiniteLoop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

