/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRedundantCommaInspection
extends GoInspectionBase
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoRedundantCommaInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoRedundantCommaInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(comma -> holder.registerProblem((PsiElement)comma, GoRedundantCommaInspection.message("go.inspection.problem.redundant.comma"), GoDeleteQuickFix.Fixes.DELETE_COMMA_FIX));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoRedundantCommaInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends GoVisitor {
        @NotNull
        private final Consumer<? super PsiElement> problemConsumer;

        public Visitor(@NotNull Consumer<? super PsiElement> problemConsumer) {
            if (problemConsumer == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.problemConsumer = problemConsumer;
        }

        @Override
        public void visitArgumentList(@NotNull GoArgumentList o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitArgumentList(o);
            PsiElement comma = Visitor.findRedundantCommaBackwards(o.getRparen());
            if (comma != null) {
                this.registerProblem(comma);
            }
        }

        @Override
        public void visitLiteralValue(@NotNull GoLiteralValue o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitLiteralValue(o);
            PsiElement comma = Visitor.findRedundantCommaBackwards(o.getRbrace());
            if (comma != null) {
                this.registerProblem(comma);
            }
        }

        @Nullable
        private static PsiElement findRedundantCommaBackwards(@Nullable PsiElement element) {
            PsiElement prev = element != null ? PsiTreeUtil.prevVisibleLeaf((PsiElement)element) : null;
            IElementType type = prev != null ? prev.getNode().getElementType() : null;
            return type == GoTypes.COMMA && !GoPsiUtil.onDifferentLines(prev, element) ? prev : null;
        }

        private void registerProblem(@NotNull PsiElement comma) {
            if (comma == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.problemConsumer.accept((PsiElement)comma);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemConsumer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comma";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/GoRedundantCommaInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArgumentList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

