/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoExpression;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoDeleteSelfAssignmentQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSelfAssignmentInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitAssignmentStatement(@NotNull GoAssignmentStatement assignmentStatement) {
                if (assignmentStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitAssignmentStatement(assignmentStatement);
                if (!GoSelfAssignmentInspection.isSimpleAssignment(assignmentStatement)) {
                    return;
                }
                List<GoExpression> targetExprs = assignmentStatement.getLeftHandExprList().getExpressionList();
                List<GoExpression> assignedExprs = assignmentStatement.getExpressionList();
                this.checkSelfAssignment(targetExprs, assignedExprs, GoSelfAssignmentInspection::isSelfAssignment);
            }

            @Override
            public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration shortVarDeclaration) {
                if (shortVarDeclaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitShortVarDeclaration(shortVarDeclaration);
                List<GoVarDefinition> varDefinitions = shortVarDeclaration.getVarDefinitionList();
                List<GoExpression> assignedExprs = shortVarDeclaration.getRightExpressionsList();
                this.checkSelfAssignment(varDefinitions, assignedExprs, GoSelfAssignmentInspection::isSelfAssignment);
            }

            private <T, A extends GoExpression> void checkSelfAssignment(@NotNull List<T> targets, @NotNull List<A> assignedExprs, @NotNull BiPredicate<T, A> isSelfAssignment) {
                if (targets == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (assignedExprs == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (isSelfAssignment == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (targets.size() != assignedExprs.size()) {
                    return;
                }
                for (Pair assign : ContainerUtil.zip(targets, assignedExprs)) {
                    if (!isSelfAssignment.test(assign.first, (GoExpression)assign.second)) continue;
                    holder.registerProblem((PsiElement)assign.second, GoSelfAssignmentInspection.message("go.inspection.problem.value.is.assigned.to.itself", new Object[]{REF}), new GoDeleteSelfAssignmentQuickFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "shortVarDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targets";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignedExprs";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "isSelfAssignment";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoSelfAssignmentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitShortVarDeclaration";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkSelfAssignment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isSimpleAssignment(@NotNull GoAssignmentStatement assignmentStatement) {
        PsiElement operator;
        if (assignmentStatement == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(2);
        }
        IElementType operatorType = (operator = assignmentStatement.getAssignOp().getOperator()) != null ? operator.getNode().getElementType() : null;
        return operatorType == GoTypes.ASSIGN;
    }

    private static boolean isSelfAssignment(@Nullable GoExpression targetExpr, @Nullable GoExpression assignedExpr) {
        if (targetExpr == null || assignedExpr == null) {
            return false;
        }
        Pair<GoExpression, GoExpression> unwrapped = GoSelfAssignmentInspection.unwrapParensAndDereference(targetExpr, assignedExpr);
        targetExpr = (GoExpression)unwrapped.first;
        assignedExpr = (GoExpression)unwrapped.second;
        return targetExpr instanceof GoReferenceExpression && assignedExpr instanceof GoReferenceExpression && !(((GoReferenceExpression)targetExpr).resolve() instanceof GoConstDefinition) && GoSelfAssignmentInspection.isSameText(targetExpr, assignedExpr);
    }

    private static boolean isSelfAssignment(@Nullable GoVarDefinition targetVarDefinition, @Nullable GoExpression assignedExpr) {
        if (targetVarDefinition == null || assignedExpr == null) {
            return false;
        }
        if ((assignedExpr = GoPsiImplUtil.unwrapParentheses(assignedExpr)) instanceof GoReferenceExpression) {
            GoReferenceExpression assignedRef = (GoReferenceExpression)assignedExpr;
            return GoSelfAssignmentInspection.isSameText(targetVarDefinition, assignedRef) && GoSelfAssignmentInspection.isResolveToSameDefinition(targetVarDefinition, assignedRef);
        }
        return false;
    }

    @NotNull
    private static Pair<GoExpression, GoExpression> unwrapParensAndDereference(@NotNull GoExpression targetExpr, @NotNull GoExpression assignedExpr) {
        if (targetExpr == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(3);
        }
        if (assignedExpr == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(4);
        }
        while (true) {
            boolean isBothPointers;
            targetExpr = GoPsiImplUtil.unwrapParentheses(targetExpr);
            assignedExpr = GoPsiImplUtil.unwrapParentheses(assignedExpr);
            boolean bl = isBothPointers = targetExpr instanceof GoUnaryExpr && ((GoUnaryExpr)targetExpr).getMul() != null && assignedExpr instanceof GoUnaryExpr && ((GoUnaryExpr)assignedExpr).getMul() != null;
            if (!isBothPointers) break;
            targetExpr = ((GoUnaryExpr)targetExpr).getExpression();
            assignedExpr = ((GoUnaryExpr)assignedExpr).getExpression();
        }
        Pair pair = Pair.pair((Object)targetExpr, (Object)assignedExpr);
        if (pair == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private static boolean isSameText(@NotNull PsiElement targetElem, @NotNull PsiElement assignedElem) {
        String assignedText;
        if (targetElem == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(6);
        }
        if (assignedElem == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(7);
        }
        return (assignedText = assignedElem.getText()) != null && !assignedText.isEmpty() && targetElem.textMatches((CharSequence)assignedText);
    }

    private static boolean isResolveToSameDefinition(@NotNull GoVarDefinition targetVarDefinition, @NotNull GoReferenceExpression assignedRef) {
        PsiReference targetVarReference;
        if (targetVarDefinition == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(8);
        }
        if (assignedRef == null) {
            GoSelfAssignmentInspection.$$$reportNull$$$0(9);
        }
        PsiElement targetResolve = (targetVarReference = targetVarDefinition.getReference()) != null ? targetVarReference.resolve() : null;
        PsiElement assignedResolve = assignedRef.resolve();
        return (targetResolve instanceof GoVarDefinition && assignedResolve instanceof GoVarDefinition || targetResolve instanceof GoParamDefinition && assignedResolve instanceof GoParamDefinition || targetResolve instanceof GoReceiver && assignedResolve instanceof GoReceiver) && targetResolve.isEquivalentTo(assignedResolve);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedExpr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoSelfAssignmentInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedElem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetVarDefinition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoSelfAssignmentInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapParensAndDereference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleAssignment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unwrapParensAndDereference";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSameText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResolveToSameDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

