/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoBlock;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/goide/inspections/RemoveRedundantElseFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.go.impl"})
final class RemoveRedundantElseFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.inspection.problem.redundant.else.for.if.condition", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        GoElseStatement goElseStatement = psiElement instanceof GoElseStatement ? (GoElseStatement)psiElement : null;
        if (goElseStatement == null) {
            return;
        }
        GoElseStatement elseStmt = goElseStatement;
        PsiElement psiElement2 = elseStmt.getParent();
        GoIfStatement goIfStatement = psiElement2 instanceof GoIfStatement ? (GoIfStatement)psiElement2 : null;
        if (goIfStatement == null) {
            return;
        }
        GoIfStatement parentIfStmt = goIfStatement;
        GoBlock goBlock = elseStmt.getBlock();
        if (goBlock == null || (goBlock = goBlock.copy()) == null) {
            return;
        }
        GoBlock copy = goBlock;
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(copy.getContainingFile(), copy.getTextRange());
        if (copy instanceof GoBlock) {
            copy.getLbrace().delete();
            PsiElement psiElement3 = copy.getRbrace();
            if (psiElement3 != null) {
                psiElement3.delete();
            }
        }
        parentIfStmt.getParent().addAfter((PsiElement)copy, (PsiElement)parentIfStmt);
        parentIfStmt.getParent().addAfter(GoElementFactory.createNewLine(project), (PsiElement)parentIfStmt);
        elseStmt.delete();
    }
}

