/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.highlighting.GoHighlightingSettingsProvider;
import com.goide.highlighting.GoSyntaxHighlightingColors;
import com.goide.inspections.tag.GoTagLexer;
import com.goide.inspections.tag.GoTagToken;
import com.goide.psi.GoFile;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoTag;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoTagHighlighterFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    GoTagHighlighterFactory() {
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            GoTagHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GoTagHighlighterFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        if (psiFile == null) {
            GoTagHighlighterFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoTagHighlighterFactory.$$$reportNull$$$0(3);
        }
        if (GoHighlightingSettingsProvider.highlightingSkippedDueToSize(psiFile)) {
            return null;
        }
        GoFile goFile = (GoFile)((Object)ObjectUtils.tryCast((Object)psiFile, GoFile.class));
        return goFile != null ? new GoTagHighlighter(goFile, editor.getDocument()) : null;
    }

    @Nullable
    private static HighlightInfoType.HighlightInfoTypeImpl getHighlightType(@NotNull IElementType token) {
        if (token == null) {
            GoTagHighlighterFactory.$$$reportNull$$$0(4);
        }
        if (token == GoTagToken.KEY) {
            return Holder.KEY_HIGHLIGHT;
        }
        if (token == GoTagToken.COLON) {
            return Holder.COLON_HIGHLIGHT;
        }
        if (token == GoTagToken.VALUE) {
            return Holder.VALUE_HIGHLIGHT;
        }
        if (token == GoTagToken.TEXT) {
            return Holder.TEXT_HIGHLIGHT;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/tag/GoTagHighlighterFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoTagHighlighter
    extends TextEditorHighlightingPass {
        private final GoFile myFile;

        GoTagHighlighter(@NotNull GoFile file2, @NotNull Document document) {
            if (file2 == null) {
                GoTagHighlighter.$$$reportNull$$$0(0);
            }
            if (document == null) {
                GoTagHighlighter.$$$reportNull$$$0(1);
            }
            super(file2.getProject(), document);
            this.myFile = file2;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                GoTagHighlighter.$$$reportNull$$$0(2);
            }
            final ArrayList myInfos = new ArrayList();
            final GoTagLexer lexer = new GoTagLexer();
            this.myFile.accept(new GoRecursiveVisitor(this){

                @Override
                public void visitTag(@NotNull GoTag tag) {
                    if (tag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitTag(tag);
                    GoStringLiteral string = tag.getStringLiteral();
                    PsiElement rawString = string.getRawString();
                    if (rawString != null) {
                        IElementType token;
                        int startOffset = rawString.getTextRange().getStartOffset();
                        TextRange range = ElementManipulators.getManipulator((PsiElement)string).getRangeInElement((PsiElement)string);
                        String text = rawString.getText();
                        lexer.start(text, range.getStartOffset(), range.getEndOffset());
                        while ((token = lexer.getTokenType()) != null) {
                            HighlightInfoType.HighlightInfoTypeImpl highlightType = GoTagHighlighterFactory.getHighlightType(token);
                            if (highlightType != null) {
                                TextRange tokenRange = TextRange.create((int)lexer.getTokenStart(), (int)lexer.getTokenEnd());
                                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightType).range(tokenRange.shiftRight(startOffset)).create();
                                myInfos.add(highlightInfo);
                            }
                            lexer.advance();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/goide/inspections/tag/GoTagHighlighterFactory$GoTagHighlighter$1", "visitTag"));
                }
            });
            BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), myInfos, (int)this.getId());
        }

        public void doApplyInformationToEditor() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/tag/GoTagHighlighterFactory$GoTagHighlighter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        private static final HighlightInfoType.HighlightInfoTypeImpl KEY_HIGHLIGHT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, GoSyntaxHighlightingColors.GO_TAG_KEY);
        private static final HighlightInfoType.HighlightInfoTypeImpl COLON_HIGHLIGHT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, GoSyntaxHighlightingColors.GO_TAG_COLON);
        private static final HighlightInfoType.HighlightInfoTypeImpl VALUE_HIGHLIGHT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, GoSyntaxHighlightingColors.GO_TAG_VALUE);
        private static final HighlightInfoType.HighlightInfoTypeImpl TEXT_HIGHLIGHT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, GoSyntaxHighlightingColors.GO_TAG_TEXT);

        private Holder() {
        }
    }
}

