/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.GoTypes;
import com.goide.inspections.tag.GoTagEntry;
import com.goide.inspections.tag.GoTagFile;
import com.goide.inspections.tag.GoTagLanguage;
import com.goide.inspections.tag.GoTagLexer;
import com.goide.inspections.tag.GoTagToken;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoTag;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagUtil {
    public static final PsiElementPattern.Capture<PsiElement> RAW_STRING_IN_STRUCT_TAG = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(GoTypes.RAW_STRING)).withParent(GoStringLiteral.class)).withSuperParent(2, GoTag.class);

    @NotNull
    public static List<String> getKeys(@NotNull GoTag tag) {
        if (tag == null) {
            GoTagUtil.$$$reportNull$$$0(0);
        }
        return GoTagUtil.extractTokens(tag, GoTagToken.KEY);
    }

    @NotNull
    public static List<String> getValues(@NotNull GoTag tag) {
        if (tag == null) {
            GoTagUtil.$$$reportNull$$$0(1);
        }
        return GoTagUtil.extractTokens(tag, GoTagToken.VALUE);
    }

    @NotNull
    public static List<Pair<String, String>> getEntries(@NotNull GoTag tag) {
        if (tag == null) {
            GoTagUtil.$$$reportNull$$$0(2);
        }
        List<String> keys = GoTagUtil.getKeys(tag);
        List<String> values2 = GoTagUtil.getValues(tag);
        List list = ContainerUtil.map(keys, key -> Pair.create((Object)key, (Object)((String)values2.get(keys.indexOf(key)))));
        if (list == null) {
            GoTagUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static int getTagStartOffset(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoTagUtil.$$$reportNull$$$0(4);
        }
        TextRange literalContentRange = ElementManipulators.getManipulator((PsiElement)literal).getRangeInElement((PsiElement)literal);
        return literal.getTextRange().getStartOffset() + literalContentRange.getStartOffset();
    }

    @Nullable
    static GoTagEntry getTagEntry(@Nullable PsiElement element, int offsetInEditor) {
        GoStringLiteral stringLiteral = (GoStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, GoStringLiteral.class, (boolean)false);
        if (stringLiteral == null) {
            return null;
        }
        int relativeOffset = offsetInEditor - GoTagUtil.getTagStartOffset(stringLiteral);
        GoTagFile file2 = GoTagUtil.parseTagLiteral(stringLiteral);
        PsiElement elementInTag = file2 != null ? file2.findElementAt(relativeOffset) : null;
        return (GoTagEntry)PsiTreeUtil.getParentOfType((PsiElement)elementInTag, GoTagEntry.class, (boolean)false);
    }

    @Nullable
    static GoTagFile parseTagLiteral(@Nullable GoStringLiteral literal) {
        if (literal == null) {
            return null;
        }
        PsiElement tagString = literal.getRawString();
        if (tagString == null) {
            return null;
        }
        TextRange range = ElementManipulators.getManipulator((PsiElement)literal).getRangeInElement((PsiElement)literal);
        return GoTagUtil.createGoTagFile(literal.getProject(), range.substring(literal.getText()));
    }

    @Nullable
    static GoTagFile createGoTagFile(@NotNull Project project, @NotNull String tagText) {
        if (project == null) {
            GoTagUtil.$$$reportNull$$$0(5);
        }
        if (tagText == null) {
            GoTagUtil.$$$reportNull$$$0(6);
        }
        return (GoTagFile)PsiFileFactory.getInstance((Project)project).createFileFromText("elementFactory.gotag", (Language)GoTagLanguage.INSTANCE, (CharSequence)tagText, false, true);
    }

    @Nullable
    static PsiElement createValue(@NotNull Project project, @NotNull String valueText) {
        GoTagFile file2;
        if (project == null) {
            GoTagUtil.$$$reportNull$$$0(7);
        }
        if (valueText == null) {
            GoTagUtil.$$$reportNull$$$0(8);
        }
        GoTagEntry entry = (file2 = GoTagUtil.createGoTagFile(project, "k:" + valueText)) != null ? (GoTagEntry)((Object)ContainerUtil.getOnlyItem(file2.getEntries())) : null;
        return entry != null ? entry.getValue() : null;
    }

    @Nullable
    static String getFieldNameForTag(@Nullable PsiElement at) {
        GoFieldDeclaration field = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, GoFieldDeclaration.class);
        if (field == null) {
            return null;
        }
        GoFieldDefinition onlyDefinition = (GoFieldDefinition)ContainerUtil.getOnlyItem(field.getFieldDefinitionList());
        if (onlyDefinition != null) {
            return onlyDefinition.getName();
        }
        GoAnonymousFieldDefinition anonymous = field.getAnonymousFieldDefinition();
        return anonymous != null ? anonymous.getType().getText() : null;
    }

    @NotNull
    static List<String> extractTokens(@NotNull GoTag tag, @NotNull IElementType targetToken) {
        IElementType token;
        GoStringLiteral literal;
        PsiElement rawString;
        if (tag == null) {
            GoTagUtil.$$$reportNull$$$0(9);
        }
        if (targetToken == null) {
            GoTagUtil.$$$reportNull$$$0(10);
        }
        if ((rawString = (literal = tag.getStringLiteral()).getRawString()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GoTagUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        GoTagLexer lexer = new GoTagLexer();
        TextRange range = ElementManipulators.getManipulator((PsiElement)literal).getRangeInElement((PsiElement)literal);
        String text = rawString.getText();
        lexer.start(text, range.getStartOffset(), range.getEndOffset());
        while ((token = lexer.getTokenType()) != null) {
            if (token == targetToken) {
                tokens.add(text.substring(lexer.getTokenStart(), lexer.getTokenEnd()));
            }
            lexer.advance();
        }
        ArrayList<String> arrayList = tokens;
        if (arrayList == null) {
            GoTagUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEntries";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTagStartOffset";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createGoTagFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractTokens";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 12 -> new IllegalStateException(string);
        };
    }
}

