/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.unresolved;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.project.GoProjectLibrariesService;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GoDisabledGopathIndexingInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoDisabledGopathIndexingInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoDisabledGopathIndexingInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            @Override
            public void visitImportSpec(@NotNull GoImportSpec spec) {
                if (spec == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (spec.isCImport() || spec.getTextLength() < 2) {
                    return;
                }
                Project project = spec.getProject();
                if (GoProjectLibrariesService.getInstance(project).isIndexEntireGopath()) {
                    return;
                }
                Collection<GoPackage> goPackages = spec.resolve(ResolveState.initial());
                if (goPackages.isEmpty()) {
                    return;
                }
                Collection<VirtualFile> roots = GoSdkUtil.getGoPathRoots(project, GoUtil.module(spec));
                if (roots.isEmpty()) {
                    return;
                }
                boolean underGopath = false;
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
                for (GoPackage goPackage : goPackages) {
                    for (VirtualFile directory : goPackage.getDirectories()) {
                        if (index.isInContent(directory) || index.isInLibrary(directory)) {
                            return;
                        }
                        for (VirtualFile root : roots) {
                            underGopath |= VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)directory, (boolean)false);
                        }
                    }
                }
                if (underGopath) {
                    GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.inspection.unresolved.disabled.gopath.indexing.message");
                    holder.registerProblem((PsiElement)spec, (GoInspectionMessage)message, GoEnableGopathIndexingQuickFix.INSTANCE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/goide/inspections/unresolved/GoDisabledGopathIndexingInspection$1", "visitImportSpec"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/unresolved/GoDisabledGopathIndexingInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class GoEnableGopathIndexingQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new GoEnableGopathIndexingQuickFix();

        private GoEnableGopathIndexingQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.enable.gopath.indexing.name", (Object[])new Object[0]);
            if (string == null) {
                GoEnableGopathIndexingQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                GoEnableGopathIndexingQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoEnableGopathIndexingQuickFix.$$$reportNull$$$0(2);
            }
            GoProjectLibrariesService.getInstance(project).setIndexEntireGopath(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/unresolved/GoDisabledGopathIndexingInspection$GoEnableGopathIndexingQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/unresolved/GoDisabledGopathIndexingInspection$GoEnableGopathIndexingQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

