/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoIntToStringConversionCallQuickFix;
import com.goide.quickfix.GoRuneConversionQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GoVetIntToStringConversionInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetIntToStringConversionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetIntToStringConversionInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(this){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void visitCallExpr(@NotNull GoCallExpr call) {
                Object argumentTypeName;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(call);
                GoExpression callExpression = call.getExpression();
                GoType callExpressionType = callExpression.getGoType(null);
                if (callExpressionType == null || !GoTypeUtil.isString(callExpressionType, callExpression)) {
                    return;
                }
                List<GoExpression> argumentExpressions = call.getArgumentList().getExpressionList();
                if (argumentExpressions.size() != 1) {
                    return;
                }
                GoExpression argument = argumentExpressions.get(0);
                GoType argumentUnderlyingType = argument.getGoUnderlyingType(null);
                if (argumentUnderlyingType == null || !GoTypeUtil.isIntegerType(argumentUnderlyingType, argument) || argumentUnderlyingType instanceof GoLightType.LightUntypedRuneType || GoTypeUtil.isRuneType(argumentUnderlyingType, argument) || GoTypeUtil.isByteType(argumentUnderlyingType, argument)) {
                    return;
                }
                GoType argumentType = argument.getGoType(null);
                if (argumentType == null) {
                    return;
                }
                String underlyingArgumentTypeName = argumentUnderlyingType.getText();
                if (!underlyingArgumentTypeName.equals(argumentTypeName = argumentType.getText())) {
                    argumentTypeName = (String)argumentTypeName + " (" + underlyingArgumentTypeName + ")";
                }
                Object callExpressionText = callExpression.getText();
                @NotNull SmartList fixes = new SmartList();
                String argumentText = argument.getText();
                PsiFile file2 = call.getContainingFile();
                if (file2 instanceof GoFile) {
                    GoIntToStringConversionCallQuickFix conversionCallFix = new GoIntToStringConversionCallQuickFix((GoFile)file2, callExpressionType, (String)callExpressionText, argumentType, argumentUnderlyingType, argumentText);
                    fixes.add(conversionCallFix);
                }
                if (!"string".equals(callExpressionText)) {
                    callExpressionText = (String)callExpressionText + " (string)";
                }
                if (GoTypeUtil.isIntType(argumentUnderlyingType, argument)) {
                    fixes.add(new GoRuneConversionQuickFix(argumentText));
                }
                GoInspectionMessage message = GoVetIntToStringConversionInspection.message("go.inspection.problem.conversion.from.int.to.string", new Object[]{argumentTypeName, callExpressionText});
                holder.registerProblem((PsiElement)argument, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/goide/inspections/vet/GoVetIntToStringConversionInspection$1", "visitCallExpr"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoVetIntToStringConversionInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

