/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.GoConvertToShortVarDeclarationIntention;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoConvertToVarDeclarationIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.convert.to.var.declaration.name", (Object[])new Object[0]);
        if (string == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Pair<GoVarDefinition, GoShortVarDeclaration> pair;
        if (project == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(4);
        }
        if ((pair = GoConvertToVarDeclarationIntention.findDefinitionAndDeclaration(element)) == null) {
            return false;
        }
        GoVarDefinition definition = (GoVarDefinition)pair.first;
        GoShortVarDeclaration declaration = (GoShortVarDeclaration)pair.second;
        if (GoConvertToShortVarDeclarationIntention.isInBlock(declaration)) {
            int index = declaration.getDefinitionList().indexOf(definition);
            return GoPsiUtil.getByIndex(declaration.getExpressionList(), index) != null || GoConvertToShortVarDeclarationIntention.isMultiValue(declaration);
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<GoVarDefinition, GoShortVarDeclaration> pair;
        if (project == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(7);
        }
        if ((pair = GoConvertToVarDeclarationIntention.findDefinitionAndDeclaration(element)) == null) {
            return;
        }
        GoVarDefinition definition = (GoVarDefinition)pair.first;
        GoShortVarDeclaration declaration = (GoShortVarDeclaration)pair.second;
        if (GoConvertToShortVarDeclarationIntention.isMultiValue(declaration)) {
            PsiElement varAssign = declaration.getVarAssign();
            Pair<String, String> parts = GoConvertToShortVarDeclarationIntention.splitSiblings(varAssign);
            GoVarDeclaration newDeclaration = GoElementFactory.createVarDeclaration(project, (String)parts.first + " = " + (String)parts.second);
            GoFormatterUtil.reformat(declaration.replace(newDeclaration));
        } else {
            PsiElement parent;
            int index = declaration != null ? declaration.getDefinitionList().indexOf(definition) : -1;
            GoExpression expression = declaration != null ? GoPsiUtil.getByIndex(declaration.getExpressionList(), index) : null;
            PsiElement statement = declaration != null ? declaration.getParent() : null;
            PsiElement psiElement = parent = statement != null ? statement.getParent() : null;
            if (expression == null || parent == null) {
                return;
            }
            GoConvertToShortVarDeclarationIntention.moveDefinitionBefore(editor, declaration, definition, expression, statement, (left, right) -> "var " + left + " = " + right);
        }
    }

    @Nullable
    private static Pair<GoVarDefinition, GoShortVarDeclaration> findDefinitionAndDeclaration(@NotNull PsiElement context) {
        GoVarDefinition definition;
        if (context == null) {
            GoConvertToVarDeclarationIntention.$$$reportNull$$$0(8);
        }
        if ((definition = (GoVarDefinition)PsiTreeUtil.getParentOfType((PsiElement)context, GoVarDefinition.class)) != null) {
            GoShortVarDeclaration declaration = (GoShortVarDeclaration)PsiTreeUtil.getParentOfType((PsiElement)definition, GoShortVarDeclaration.class);
            return declaration != null ? Pair.pair((Object)definition, (Object)declaration) : null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoShortVarDeclaration.class, GoFunctionLit.class});
        GoShortVarDeclaration declaration = (GoShortVarDeclaration)ObjectUtils.tryCast((Object)parent, GoShortVarDeclaration.class);
        if (declaration == null) {
            return null;
        }
        List<GoVarDefinition> definitions = declaration.getDefinitionList();
        return definitions.size() == 1 || GoConvertToShortVarDeclarationIntention.isMultiValue(declaration) ? Pair.pair((Object)definitions.get(0), (Object)declaration) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoConvertToVarDeclarationIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoConvertToVarDeclarationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDefinitionAndDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

