/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.GoParserDefinition;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoGenerateTypeFromJsonDialog;
import com.goide.psi.GoFile;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoGenerateTypeFromJsonIntention
extends BaseElementAtCaretIntentionAction {
    private static final ElementPattern<?>[] WHITESPACE_ERROR_EMPTY = new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement().withText("")};

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return GoGenerateTypeFromJsonIntention.getFixName();
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return GoGenerateTypeFromJsonIntention.getFixName();
    }

    @NotNull
    @Nls
    public static String getFixName() {
        String string = GoBundle.message((String)"go.intention.generate.type.from.json", (Object[])new Object[0]);
        if (string == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(3);
        }
        return ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(WHITESPACE_ERROR_EMPTY)).withParent(GoFile.class)).accepts((Object)element) && !GoGenerateTypeFromJsonIntention.isWhitespaceOnSameLineAfterLineComment(editor, element);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(6);
        }
        GoGenerateTypeFromJsonIntention.showDialogAndGenerate(project, editor, (GoFile)element.getContainingFile(), null);
    }

    public static void showDialogAndGenerate(@NotNull Project project, @NotNull Editor editor, @NotNull GoFile file2, @Nullable TextRange rangeToRemove) {
        if (project == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            GoTypeSpec type;
            GoGenerateTypeFromJsonDialog dialog = new GoGenerateTypeFromJsonDialog(project, (PsiElement)file2);
            if (dialog.showAndGet() && (type = dialog.getGeneratedType()) != null) {
                DocumentUtil.writeInRunUndoTransparentAction(() -> GoGenerateTypeFromJsonIntention.runGenerateTypeTemplate(editor, file2, type, rangeToRemove, editor.getCaretModel().getOffset()));
            }
        });
    }

    public static void runGenerateTypeTemplate(@NotNull Editor editor, @NotNull GoFile file2, @NotNull GoTypeSpec type, @Nullable TextRange rangeToRemove, int offset) {
        if (editor == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(11);
        }
        if (type == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(12);
        }
        GoTypeDeclaration typeDecl = Objects.requireNonNull((GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)type, GoTypeDeclaration.class));
        int typeDeclStartOffset = typeDecl.getTextRange().getStartOffset();
        TextRange nameRange = type.getIdentifier().getTextRange();
        String typeDeclText = typeDecl.getText();
        LinkedHashSet<String> occupiedNames = GoNameSuggestionProvider.getNamesInContext((PsiElement)file2);
        String typeName = UniqueNameGenerator.generateUniqueName((String)"T", occupiedNames);
        GoTemplate template = new GoTemplate(file2);
        template.addTextSegment(typeDeclText.substring(0, nameRange.getStartOffset() - typeDeclStartOffset));
        template.addPrimaryVariable("NAME", (Expression)new ConstantNode(typeName));
        template.addEndVariable();
        template.addTextSegment(typeDeclText.substring(nameRange.getEndOffset() - typeDeclStartOffset));
        template.startTemplate(editor, offset, GoBundle.message((String)"go.intention.generate.type.from.json", (Object[])new Object[0]), rangeToRemove);
    }

    private static boolean isWhitespaceOnSameLineAfterLineComment(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(13);
        }
        if (element == null) {
            GoGenerateTypeFromJsonIntention.$$$reportNull$$$0(14);
        }
        if (!(element instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev == null || prev.getNode().getElementType() != GoParserDefinition.Lazy.LINE_COMMENT) {
            return false;
        }
        Document document = editor.getDocument();
        return document.getLineNumber(prev.getTextRange().getEndOffset()) == document.getLineNumber(editor.getCaretModel().getOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoGenerateTypeFromJsonIntention";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoGenerateTypeFromJsonIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGenerate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runGenerateTypeTemplate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceOnSameLineAfterLineComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

