/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoEnvironmentUtil;
import com.goide.project.GoLibrariesService;
import com.goide.project.GoProjectLibrariesService;
import com.goide.project.GoRootsProvider;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultGoRootsProvider
implements GoRootsProvider {
    @Override
    @NotNull
    public Collection<VirtualFile> getGoPathRoots(@Nullable Project project, @Nullable Module module) {
        SmartList roots = new SmartList();
        if (project != null && project.isDisposed()) {
            SmartList smartList = roots;
            if (smartList == null) {
                DefaultGoRootsProvider.$$$reportNull$$$0(0);
            }
            return smartList;
        }
        if (module != null) {
            roots.addAll(GoLibrariesService.getUserDefinedLibraries(module));
        } else if (project != null) {
            roots.addAll(GoLibrariesService.getUserDefinedLibraries(project));
        }
        if (project == null || GoProjectLibrariesService.getInstance(project).isUseGoPathFromSystemEnvironment()) {
            roots.addAll(GoSdkUtil.getGoPathsRootsFromEnvironment(project, module));
        }
        if (roots.isEmpty()) {
            ContainerUtil.addIfNotNull((Collection)roots, (Object)this.getDefaultGoPath(project, module));
        }
        SmartList smartList = roots;
        if (smartList == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getGoPathSourcesRoots(@Nullable Project project, @Nullable Module module) {
        if (project == null) {
            return this.getInnerGoPathSources(null, null);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)(module != null ? module : project), () -> CachedValueProvider.Result.create(this.getInnerGoPathSources(project, module), GoSdkUtil.getSdkAndLibrariesCacheDependencies(project, module, new Object[0])));
        if (collection == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @Nullable
    public VirtualFile getDefaultGoPath(@Nullable Project project, @Nullable Module module) {
        if (project == null || GoSdkService.getInstance(project).getSdk(module).supportsDefaultGoPath()) {
            return GoSdkUtil.getDefaultGoPath();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getGoPathBinRoots(@Nullable Project project, @Nullable Module module) {
        String goBinPath;
        VirtualFile executable;
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        if (project != null && (executable = GoSdkService.getInstance(project).getSdk(module).getExecutable()) != null) {
            ContainerUtil.addIfNotNull(result, (Object)executable.getParent());
        }
        if ((goBinPath = GoEnvironmentUtil.retrieveGoBinFromEnvironment()) != null) {
            ContainerUtil.addIfNotNull(result, (Object)VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)goBinPath)));
        }
        result.addAll(this.getRoots(project, module, "bin"));
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    @NotNull
    public ThreeState indexGoPathSources(@NotNull Project project) {
        boolean indexEntireGopath;
        if (project == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(4);
        }
        ThreeState threeState = (indexEntireGopath = GoProjectLibrariesService.getInstance(project).isIndexEntireGopath()) ? ThreeState.UNSURE : ThreeState.NO;
        if (threeState == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    @Override
    @Nullable
    public Collection<VirtualFile> getVendorDirectoriesInResolveScope(@NotNull Project project, @Nullable Module module, @Nullable VirtualFile file2) {
        if (project == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(6);
        }
        return GoSdkUtil.collectVendorDirectories(file2, GoSdkUtil.getSourcesPathsToLookup(project, module));
    }

    @NotNull
    private List<VirtualFile> getInnerGoPathSources(@Nullable Project project, @Nullable Module module) {
        return this.getRoots(project, module, "src");
    }

    @NotNull
    private List<VirtualFile> getRoots(@Nullable Project project, @Nullable Module module, @NotNull String subdirName) {
        if (subdirName == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(7);
        }
        Collection<VirtualFile> roots = this.getGoPathRoots(project, module);
        List list = roots.stream().map(new RetrieveSubDirectoryOrSelfFunction(subdirName)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new ArrayList(roots.size())));
        if (list == null) {
            DefaultGoRootsProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/DefaultGoRootsProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathSourcesRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathBinRoots";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/DefaultGoRootsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "indexGoPathSources";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexGoPathSources";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVendorDirectoriesInResolveScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static class RetrieveSubDirectoryOrSelfFunction
    implements Function<VirtualFile, VirtualFile> {
        @NotNull
        private final String mySubdirName;

        public RetrieveSubDirectoryOrSelfFunction(@NotNull String subdirName) {
            if (subdirName == null) {
                RetrieveSubDirectoryOrSelfFunction.$$$reportNull$$$0(0);
            }
            this.mySubdirName = subdirName;
        }

        @Override
        public VirtualFile apply(VirtualFile file2) {
            return file2 == null || !file2.isValid() || FileUtil.namesEqual((String)this.mySubdirName, (String)file2.getName()) ? file2 : file2.findChild(this.mySubdirName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "com/goide/project/DefaultGoRootsProvider$RetrieveSubDirectoryOrSelfFunction", "<init>"));
        }
    }
}

