/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project.migration;

import com.goide.i18n.GoBundle;
import com.goide.project.GoProjectLibrariesService;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

final class GoProjectModelConverterProvider
extends ConverterProvider {
    private static final String PROJECT_ROOT_MANAGER = "ProjectRootManager";

    private GoProjectModelConverterProvider() {
    }

    @NotNull
    public String getConversionDescription() {
        String string = GoBundle.message((String)"go.converter.project.model.description", (Object[])new Object[0]);
        if (string == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public ProjectConverter createConverter(final @NotNull ConversionContext context) {
        if (context == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(1);
        }
        return new ProjectConverter(this){
            private final Collection<Path> additionalCreatedFiles = new ArrayList<Path>();
            private final Collection<Path> additionalAffectedFiles = new ArrayList<Path>();

            @NotNull
            public ConversionProcessor<ComponentManagerSettings> createProjectFileConverter() {
                return new ProjectFileConverter();
            }

            @NotNull
            public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
                return new ModuleFileConverter();
            }

            @NotNull
            public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
                return new RunConfigurationsConverter();
            }

            public boolean isConversionNeeded() {
                if (context.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
                    return false;
                }
                Path dotIdea = context.getSettingsBaseDir();
                Path miscFile = dotIdea == null ? null : dotIdea.resolve("misc.xml");
                Element component2 = miscFile == null ? null : GoProjectModelConverterProvider.getProjectRootManager(miscFile);
                return component2 != null && GoProjectModelConverterProvider.isGoSdkType(component2.getAttributeValue("project-jdk-type"));
            }

            public void preProcessingFinished() throws CannotConvertException {
                Element component2;
                Path dotIdea = context.getSettingsBaseDir();
                Path miscFile = dotIdea == null ? null : dotIdea.resolve("misc.xml");
                Element element = component2 = miscFile == null ? null : GoProjectModelConverterProvider.getProjectRootManager(miscFile);
                if (component2 != null) {
                    try {
                        Element oldGoSettingsRoot;
                        GoProjectModelConverterProvider.updateSdkType(miscFile, component2);
                        this.additionalAffectedFiles.add(miscFile);
                        Path oldGoSettings = context.getSettingsBaseDir().resolve("go_settings.xml");
                        if (Files.exists(oldGoSettings, new LinkOption[0]) && GoProjectModelConverterProvider.isAttachProjectDirToLibraries(oldGoSettingsRoot = JDomConvertingUtil.load((Path)oldGoSettings))) {
                            Path librariesConfigFile = context.getSettingsBaseDir().resolve("goLibraries.xml");
                            if (Files.deleteIfExists(librariesConfigFile)) {
                                this.additionalAffectedFiles.add(librariesConfigFile);
                            } else {
                                this.additionalCreatedFiles.add(librariesConfigFile);
                            }
                            PathKt.write((Path)librariesConfigFile, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project></project>");
                            GoProjectModelConverterProvider.addProjectDirToLibraries(librariesConfigFile, JDomConvertingUtil.load((Path)librariesConfigFile));
                        }
                        Files.deleteIfExists(oldGoSettings);
                    }
                    catch (IOException e) {
                        throw new CannotConvertException("Cannot convert go project", (Throwable)e);
                    }
                }
            }

            @NotNull
            public Collection<Path> getAdditionalAffectedFiles() {
                Collection<Path> collection = this.additionalAffectedFiles;
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @NotNull
            public Collection<Path> getCreatedFiles() {
                Collection<Path> collection = this.additionalCreatedFiles;
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/goide/project/migration/GoProjectModelConverterProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalAffectedFiles";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCreatedFiles";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    private static Element getProjectRootManager(@NotNull Path miscFile) {
        if (miscFile == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(2);
        }
        try {
            return GoProjectModelConverterProvider.getProjectRootManager(JDOMUtil.load((Path)miscFile));
        }
        catch (IOException | JDOMException ignore) {
            return null;
        }
    }

    @Nullable
    private static Element getProjectRootManager(@Nullable Element rootElement) {
        return rootElement != null ? JDomSerializationUtil.findComponent((Element)rootElement, (String)PROJECT_ROOT_MANAGER) : null;
    }

    private static void updateSdkType(@NotNull Path path, @NotNull Element projectRootManager) throws CannotConvertException {
        if (path == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(3);
        }
        if (projectRootManager == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(4);
        }
        projectRootManager.setAttribute("project-jdk-type", "Go SDK");
        GoProjectModelConverterProvider.saveFile(path, projectRootManager, "Cannot save sdk type changing");
    }

    private static void addProjectDirToLibraries(@NotNull Path path, @NotNull Element rootElement) throws CannotConvertException {
        if (path == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(5);
        }
        if (rootElement == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(6);
        }
        GoProjectLibrariesService librariesService = new GoProjectLibrariesService(null);
        librariesService.setLibraryRootUrls("file://$PROJECT_DIR$");
        Element componentElement = JDomSerializationUtil.findOrCreateComponentElement((Element)rootElement, (String)"GoLibraries");
        XmlSerializer.serializeInto((Object)librariesService.getState(), (Element)componentElement);
        GoProjectModelConverterProvider.saveFile(path, rootElement, "Cannot save libraries settings");
    }

    private static boolean isAttachProjectDirToLibraries(Element rootElement) {
        Element goProjectSettings = JDomSerializationUtil.findComponent((Element)rootElement, (String)"GoProjectSettings");
        if (goProjectSettings != null) {
            for (Element option : goProjectSettings.getChildren("option")) {
                if (!"prependGoPath".equals(option.getAttributeValue("name"))) continue;
                goProjectSettings.detach();
                return "true".equalsIgnoreCase(option.getAttributeValue("value"));
            }
            goProjectSettings.detach();
        }
        return false;
    }

    private static boolean isGoSdkType(String sdkTypeName) {
        return "Google Go SDK".equals(sdkTypeName) || "Google Go App Engine SDK".equals(sdkTypeName);
    }

    private static void saveFile(@NotNull Path path, @NotNull Element rootElement, String errorMessage) throws CannotConvertException {
        if (path == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(7);
        }
        if (rootElement == null) {
            GoProjectModelConverterProvider.$$$reportNull$$$0(8);
        }
        try {
            JDOMUtil.writeDocument((Document)rootElement.getDocument(), (String)path.toString(), (String)System.lineSeparator());
        }
        catch (IOException e) {
            throw new CannotConvertException(errorMessage, (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/migration/GoProjectModelConverterProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "miscFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversionDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/migration/GoProjectModelConverterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConverter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProjectDirToLibraries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static class RunConfigurationsConverter
    extends ConversionProcessor<RunManagerSettings> {
        private RunConfigurationsConverter() {
        }

        public boolean isConversionNeeded(@NotNull RunManagerSettings settings) {
            if (settings == null) {
                RunConfigurationsConverter.$$$reportNull$$$0(0);
            }
            for (Element element : settings.getRunConfigurations()) {
                String confType = element.getAttributeValue("type");
                if (!"GaeLocalAppEngineServer".equals(confType) && !"GoTestConfiguration".equals(confType)) continue;
                return true;
            }
            return false;
        }

        public void process(@NotNull RunManagerSettings settings) {
            if (settings == null) {
                RunConfigurationsConverter.$$$reportNull$$$0(1);
            }
            for (Element element : settings.getRunConfigurations()) {
                String confType = element.getAttributeValue("type");
                if (!"GaeLocalAppEngineServer".equals(confType) && !"GoTestConfiguration".equals(confType)) continue;
                element.detach();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/goide/project/migration/GoProjectModelConverterProvider$RunConfigurationsConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConversionNeeded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleFileConverter
    extends ConversionProcessor<ModuleSettings> {
        private ModuleFileConverter() {
        }

        public boolean isConversionNeeded(@NotNull ModuleSettings settings) {
            if (settings == null) {
                ModuleFileConverter.$$$reportNull$$$0(0);
            }
            if ("GO_APP_ENGINE_MODULE".equals(settings.getModuleType())) {
                return true;
            }
            for (Element element : settings.getOrderEntries()) {
                if (!GoProjectModelConverterProvider.isGoSdkType(element.getAttributeValue("jdkType"))) continue;
                return true;
            }
            return false;
        }

        public void process(@NotNull ModuleSettings settings) {
            if (settings == null) {
                ModuleFileConverter.$$$reportNull$$$0(1);
            }
            settings.setModuleType("GO_MODULE");
            for (Element element : settings.getOrderEntries()) {
                if (!GoProjectModelConverterProvider.isGoSdkType(element.getAttributeValue("jdkType"))) continue;
                element.setAttribute("jdkType", "Go SDK");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/goide/project/migration/GoProjectModelConverterProvider$ModuleFileConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConversionNeeded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProjectFileConverter
    extends ConversionProcessor<ComponentManagerSettings> {
        private ProjectFileConverter() {
        }

        public boolean isConversionNeeded(@NotNull ComponentManagerSettings settings) {
            Element projectRootManager;
            if (settings == null) {
                ProjectFileConverter.$$$reportNull$$$0(0);
            }
            return (projectRootManager = GoProjectModelConverterProvider.getProjectRootManager(settings.getRootElement())) != null && GoProjectModelConverterProvider.isGoSdkType(projectRootManager.getAttributeValue("project-jdk-type"));
        }

        public void process(@NotNull ComponentManagerSettings settings) throws CannotConvertException {
            Element projectRootManager;
            if (settings == null) {
                ProjectFileConverter.$$$reportNull$$$0(1);
            }
            if ((projectRootManager = GoProjectModelConverterProvider.getProjectRootManager(settings.getRootElement())) != null) {
                GoProjectModelConverterProvider.updateSdkType(settings.getPath(), projectRootManager);
            }
            if (GoProjectModelConverterProvider.isAttachProjectDirToLibraries(settings.getRootElement())) {
                GoProjectModelConverterProvider.addProjectDirToLibraries(settings.getPath(), settings.getRootElement());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/goide/project/migration/GoProjectModelConverterProvider$ProjectFileConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConversionNeeded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

